#!/bin/sh
# 
# setnwkcfg.sh
# Script to setup the current network interface. Parameters are passed in http URL style 
# Example:
# ipaddress=192.168.0.20&subnet=255.255.255.0&gateway=192.168.0.1&dhcp=0
# 
# When dhcp=1 the other parameters are irrelevant 
#
# (C) 2016, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za

IPADDRESS="0.0.0.0"
SUBNET="0.0.0.0"
GATEWAY="0.0.0.0"
DHCP="0"
IFACECFGFILE=/etc/network/interfaces
IFACECFGDHCP=/etc/network/interfaces.dhcp.template
IFDEVICE=eth0


PARAM=$2
OIFS="$IFS"
IFS='&'
set -- $PARAM
IFS=' '
PARAMS=$@
IFS="$OIFS"

for i in $PARAMS; do
    # process "$i"
    IFS='=';
    set -- $i;
    if [ $1 == "ipaddress" ]; then
	IPADDRESS=$2
    elif [ $1 == "gateway" ]; then
	GATEWAY=$2
    elif [ $1 == "subnet" ]; then
	SUBNET=$2
    elif [ $1 == "dhcp" ]; then
	DHCP=$2
#    else
#	echo -en "Unknown tag=$1 value=$2\n" >> interfaces.txt
    fi
done


if [ $DHCP == "1" ]; then
   cp $IFACECFGDHCP $IFACECFGFILE
else
   IFCFG=$(awk -f $1/cgi/writeInterfaces.awk $IFACECFGFILE dev=$IFDEVICE address=$IPADDRESS netmask=$SUBNET gateway=$GATEWAY mode="static")
   echo "$IFCFG" > "$IFACECFGFILE"
fi

echo '{"status":"ok"}'

/etc/init.d/networking restart



