#!/bin/sh
#
# setapplication.sh
# Script to save all application related parameters
#
# (C) 2017, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za

APP_DESC="
# Robot-T410 Application Settings\n
# (C) 2017, Radical Electronic Systems\n
# http://www.radicalsystems.co.za info@radicalsystems.co.za\n\n"

# Window Manager Settings
WM_LOAD_DESKTOP="no"
WM_LOAD_PANEL="no"
WM_LOAD_TITLEBAR="no"

# Web Browser Settings
WB_LOAD_STARTUP="no"
WB_LOAD_FULLSCREEN="no"
WB_LOAD_MENUBAR="no"
WB_LOAD_STATUSBAR="no"
WB_LOAD_NAVBAR="no"
WB_LOAD_WEBSITE="no"
WB_LOAD_URL="http://www.radicalsystems.co.za"

# \"appwbldnb\":\"1\",\"appwbldsb\":\"1\",\"appwbldws\":\"1\",\"appwbweburl\":\"http://www.google.com\"}"

# appwmdesk=1&appwmpanel=0&appwmtitlebar=1&appwbweburl=http://www.google.com

PARAM=$2
OIFS="$IFS"
IFS='&'
set -- $PARAM
IFS=' '
PARAMS=$@
IFS="$OIFS"

for i in $PARAMS; do
    # process "$i"
    IFS='=';
    set -- $i;

    if [ $2 = "1" ]; then
      VAL="yes";
    else
      VAL="no";
    fi

    if [ $1 = "appwmdesk" ]; then
	    WM_LOAD_DESKTOP=$VAL;
    elif [ $1 = "appwmpanel" ]; then
      WM_LOAD_PANEL=$VAL;
    elif [ $1 = "appwmtitlebar" ]; then
      WM_LOAD_TITLEBAR=$VAL;
    elif [ $1 = "appwbstartup" ]; then
      WB_LOAD_STARTUP=$VAL;
    elif [ $1 = "appwbfullscreen" ]; then
      WB_LOAD_FULLSCREEN=$VAL;
    elif [ $1 = "appwbldmb" ]; then
      WB_LOAD_MENUBAR=$VAL;
    elif [ $1 = "appwbldnb" ]; then
      WB_LOAD_NAVBAR=$VAL;
    elif [ $1 = "appwbldsb" ]; then
      WB_LOAD_STATUSBAR=$VAL;
    elif [ $1 = "appwbldws" ]; then
      WB_LOAD_WEBSITE=$VAL;
    elif [ $1 = "appwbweburl" ]; then
      WB_LOAD_URL=$2;

#    else
#	echo -en "Unknown tag=$1 value=$2\n" >> interfaces.txt
    fi
done

IFS="$OIFS"

APP_CFG="
# Window Manager Settings\n
WM_LOAD_DESKTOP=$WM_LOAD_DESKTOP\n
WM_LOAD_PANEL=$WM_LOAD_PANEL\n
WM_LOAD_TITLEBAR=$WM_LOAD_TITLEBAR\n\n
# Web Browser Settings\n
WB_LOAD_STARTUP=$WB_LOAD_STARTUP\n
WB_LOAD_FULLSCREEN=$WB_LOAD_FULLSCREEN\n
WB_LOAD_MENUBAR=$WB_LOAD_MENUBAR\n
WB_LOAD_NAVBAR=$WB_LOAD_NAVBAR\n
WB_LOAD_STATUSBAR=$WB_LOAD_STATUSBAR\n
WB_LOAD_WEBSITE=$WB_LOAD_WEBSITE\n
WB_LOAD_URL=$WB_LOAD_URL"

echo -e $APP_DESC > /etc/formfactor/appconfig
echo -e $APP_CFG >> /etc/formfactor/appconfig

echo '{"status":"ok"}'
