#!/bin/sh
# 
# getnwkcfg.sh
# Script to retrieve the current network setup and return as JSON result
#
# (C) 2016, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za

IFACECFGFILE=/etc/network/interfaces
IFDEVICE=eth0
IFCFG=$(awk -f $1/cgi/readInterfaces.awk $IFACECFGFILE device=$IFDEVICE)

# check if network was DHCP
if [ $? -eq 1 ]; then
	# user 'ifconfig' to retrieve the setup
	IFDATA=$(ifconfig $IFDEVICE | grep 'inet addr')
	IFIP=$(echo $IFDATA | awk '/inet addr/ {gsub("addr:", "", $2); print $2}')
	IFMASK=$(echo $IFDATA | awk '/inet addr/ {gsub("Mask:", "", $4); print $4}')
	IPGW=$(ip route | awk '/default/ { print $3 }')
	IFCFG="\"ipaddress\":\"$IFIP\",\"subnet\":\"$IFMASK\",\"gateway\":\"$IPGW\",\"dhcp\":\"1\""
fi


echo "{$IFCFG, \"dns\":\"8.8.8.8\"}"
