#!/bin/sh
#
# getapplication.sh
# Script to retrieve the device environment data
#
# (C) 2017, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za


CFGFILE=/etc/formfactor/appconfig

WM_LOAD_DESKTOP=no
WM_LOAD_PANEL=no
WM_LOAD_TITLEBAR=no

WB_LOAD_STARTUP=no
WB_LOAD_FULLSCREEN=no
WB_LOAD_MENUBAR=no
WB_LOAD_NAVBAR=no
WB_LOAD_STATUSBAR=no
WB_LOAD_WEBSITE=no
WB_LOAD_URL="http://www.radicalsystems.co.za"

if [ -e $CFGFILE ]; then
  . $CFGFILE
fi

if [ $WM_LOAD_DESKTOP = "yes" ]; then
  JSON="\"appwmdesk\":\"1"\";
else
  JSON="\"appwmdesk\":\"0"\";
fi

if [ $WM_LOAD_PANEL = "yes" ]; then
  JSON=$JSON",\"appwmpanel\":\"1"\";
else
  JSON=$JSON",\"appwmpanel\":\"0"\";
fi

if [ $WM_LOAD_TITLEBAR = "yes" ]; then
  JSON=$JSON",\"appwmtitlebar\":\"1"\";
else
  JSON=$JSON",\"appwmtitlebar\":\"0"\";
fi

if [ $WB_LOAD_STARTUP = "yes" ]; then
  JSON=$JSON",\"appwbstartup\":\"1"\";
else
  JSON=$JSON",\"appwbstartup\":\"0"\";
fi

if [ $WB_LOAD_FULLSCREEN = "yes" ]; then
  JSON=$JSON",\"appwbfullscreen\":\"1"\";
else
  JSON=$JSON",\"appwbfullscreen\":\"0"\";
fi

if [ $WB_LOAD_MENUBAR = "yes" ]; then
  JSON=$JSON",\"appwbldmb\":\"1"\";
else
  JSON=$JSON",\"appwbldmb\":\"0"\";
fi

if [ $WB_LOAD_NAVBAR = "yes" ]; then
  JSON=$JSON",\"appwbldnb\":\"1"\";
else
  JSON=$JSON",\"appwbldnb\":\"0"\";
fi

if [ $WB_LOAD_STATUSBAR = "yes" ]; then
  JSON=$JSON",\"appwbldsb\":\"1"\";
else
  JSON=$JSON",\"appwbldsb\":\"0"\";
fi

if [ $WB_LOAD_WEBSITE = "yes" ]; then
  JSON=$JSON",\"appwbldws\":\"1"\";
else
  JSON=$JSON",\"appwbldws\":\"0"\";
fi

JSON=$JSON",\"appwbweburl\":\"$WB_LOAD_URL\"";

echo -e "{$JSON}"
