#!/bin/sh
#
# controlwb.sh
# Script to control Midori Webbrowser
#
# (C) 2016-2017, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za

COMMAND="none"
URL="google.com"

PARAM=$2
OIFS="$IFS"
IFS='&'
set -- $PARAM
IFS=' '
PARAMS=$@
IFS="$OIFS"

for i in $PARAMS; do
    # process "$i"
    IFS='=';
    set -- $i;
    # echo "param $1"
    if [ $1 = "command" ]; then
	     COMMAND=$2
    elif [ $1 = "pageURL" ]; then
       URL=$2
    fi
done

# echo "Command: $COMMAND"

if [ $COMMAND = "toggleNavBar" ]; then
  midori -e Navigationbar
elif [ $COMMAND = "toggleMenuBar" ]; then
  midori -e Menubar
elif [ $COMMAND = "toggleStatusBar" ]; then
  midori -e Statusbar
elif [ $COMMAND = "toggleFullscreen" ]; then
  midori -e Fullscreen
elif [ $COMMAND = "loadURL" ]; then
  midori -e Go $URL
fi

if [ $? -eq 0 ]; then
    # app started OK
    STATUS="ok"
else
   # app failed
   STATUS="failed"
fi

echo "{\"status\":\"$STATUS\"}"
exit 0
