/*
 * Decompiled with CFR 0.152.
 */
package com.radicales.rbt400.apps.serialtest;

import com.radicales.cal.CalDriverEvent;
import com.radicales.cal.CalDriverException;
import com.radicales.cal.serial.SerialJSSC;
import com.radicales.cal.serial.SerialJSSCReader;
import com.radicales.cal.serial.SerialParameters;
import com.radicales.cal.serial.SerialPortSetupDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SerialTest
extends JFrame
implements CalDriverEvent {
    private SerialParameters gSerialParam;
    private SerialJSSC gSerial;
    private JButton btnDTRclr;
    private JButton btnDTRset;
    private JButton btnRTSclr;
    private JButton btnRTSset;
    private JButton btnSend;
    private JButton btnSetup;
    private JButton btnStart;
    private JButton btnStop;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JRadioButton rbtnCTSlo;
    private JRadioButton rbtnCTSon;
    private JTextArea taData;
    private JTextField tfSend;

    public SerialTest() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.taData = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.rbtnCTSon = new JRadioButton();
        this.rbtnCTSlo = new JRadioButton();
        this.jPanel6 = new JPanel();
        this.tfSend = new JTextField();
        this.btnSend = new JButton();
        this.jPanel2 = new JPanel();
        this.btnSetup = new JButton();
        this.btnRTSset = new JButton();
        this.btnRTSclr = new JButton();
        this.btnDTRset = new JButton();
        this.btnDTRclr = new JButton();
        this.btnStart = new JButton();
        this.btnStop = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Serial Port Testing");
        this.jPanel1.setLayout(new BorderLayout(10, 10));
        this.jPanel3.setLayout(new BorderLayout(10, 10));
        this.taData.setEditable(false);
        this.taData.setColumns(20);
        this.taData.setRows(5);
        this.jScrollPane1.setViewportView(this.taData);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel4.setLayout(new BorderLayout(10, 10));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("CTS"));
        this.rbtnCTSon.setText("High");
        this.jPanel5.add(this.rbtnCTSon);
        this.rbtnCTSlo.setText("Low");
        this.jPanel5.add(this.rbtnCTSlo);
        this.jPanel4.add((Component)this.jPanel5, "South");
        this.jPanel6.setLayout(new BorderLayout(10, 10));
        this.tfSend.setPreferredSize(new Dimension(300, 32));
        this.jPanel6.add((Component)this.tfSend, "Center");
        this.btnSend.setText("Send");
        this.btnSend.setPreferredSize(new Dimension(73, 32));
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnSendActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.btnSend, "East");
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setPreferredSize(new Dimension(400, 40));
        this.jPanel2.setLayout(new FlowLayout(4));
        this.btnSetup.setText("Setup");
        this.btnSetup.setPreferredSize(new Dimension(73, 32));
        this.btnSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnSetupActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnSetup);
        this.btnRTSset.setText("RTS Set");
        this.btnRTSset.setPreferredSize(new Dimension(73, 32));
        this.btnRTSset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnRTSsetActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnRTSset);
        this.btnRTSclr.setText("RTS Clear");
        this.btnRTSclr.setPreferredSize(new Dimension(80, 32));
        this.btnRTSclr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnRTSclrActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnRTSclr);
        this.btnDTRset.setText("DTR Set");
        this.btnDTRset.setPreferredSize(new Dimension(73, 32));
        this.btnDTRset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnDTRsetActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnDTRset);
        this.btnDTRclr.setText("DTR clear");
        this.btnDTRclr.setPreferredSize(new Dimension(80, 32));
        this.btnDTRclr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnDTRclrActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnDTRclr);
        this.btnStart.setText("Start");
        this.btnStart.setPreferredSize(new Dimension(73, 32));
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnStartActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnStart);
        this.btnStop.setText("Stop");
        this.btnStop.setPreferredSize(new Dimension(73, 32));
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialTest.this.btnStopActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnStop);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void btnSetupActionPerformed(ActionEvent evt) {
        SerialPortSetupDialog dlg = new SerialPortSetupDialog((Frame)this, true);
        dlg.setVisible(true);
        if (dlg.getExitResult()) {
            this.gSerialParam = dlg.getSetup();
            this.gSerial = new SerialJSSCReader(this.gSerialParam);
        }
        dlg.dispose();
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        this.taData.setText(null);
        if (this.gSerial == null) {
            String msg = "Serial port parameters not set!";
            JOptionPane.showMessageDialog(this, msg, "Start", 1);
        } else {
            this.gSerial.addEventListener(this);
            try {
                this.gSerial.Open();
                this.gSerial.Start();
                if (this.gSerial.IoControl(22, 0) == 0) {
                    this.rbtnCTSon.setSelected(false);
                    this.rbtnCTSlo.setSelected(true);
                } else {
                    this.rbtnCTSon.setSelected(true);
                    this.rbtnCTSlo.setSelected(false);
                }
            }
            catch (CalDriverException ex) {
                JOptionPane.showMessageDialog(this, "Starting serial port failed: " + ex.getMessage(), "Start", 2);
                this.gSerial = null;
            }
        }
    }

    private void btnStopActionPerformed(ActionEvent evt) {
        if (this.gSerial == null) {
            JOptionPane.showMessageDialog(this, "Not started", "Stop", 2);
        } else {
            this.gSerial.removeEventListener(this);
            this.gSerial.Stop();
            this.gSerial.Close();
        }
    }

    private void btnSendActionPerformed(ActionEvent evt) {
        if (this.gSerial == null) {
            JOptionPane.showMessageDialog(this, "Not started", "Send", 2);
        } else {
            byte[] bb = this.tfSend.getText().getBytes();
            try {
                this.gSerial.Write(bb);
            }
            catch (CalDriverException ex) {
                JOptionPane.showMessageDialog(this, "Failed to send data", "Send", 2);
            }
        }
    }

    private void btnRTSsetActionPerformed(ActionEvent evt) {
        try {
            this.gSerial.IoControl(20, 1);
        }
        catch (CalDriverException ex) {
            JOptionPane.showMessageDialog(this, "Failed to set RTS: " + ex.getMessage(), "RTS Control", 2);
        }
    }

    private void btnRTSclrActionPerformed(ActionEvent evt) {
        try {
            this.gSerial.IoControl(20, 0);
        }
        catch (CalDriverException ex) {
            JOptionPane.showMessageDialog(this, "Failed to clear RTS: " + ex.getMessage(), "RTS Control", 2);
        }
    }

    private void btnDTRsetActionPerformed(ActionEvent evt) {
        try {
            this.gSerial.IoControl(23, 1);
        }
        catch (CalDriverException ex) {
            JOptionPane.showMessageDialog(this, "Failed to set DTR: " + ex.getMessage(), "DTR Control", 2);
        }
    }

    private void btnDTRclrActionPerformed(ActionEvent evt) {
        try {
            this.gSerial.IoControl(23, 0);
        }
        catch (CalDriverException ex) {
            JOptionPane.showMessageDialog(this, "Failed to clear DTR: " + ex.getMessage(), "DTR Control", 2);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SerialTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SerialTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SerialTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SerialTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SerialTest().setVisible(true);
            }
        });
    }

    @Override
    public byte[] DriverEventRead() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void DriverEventWrite(byte[] Buffer, int Length) {
        byte[] bb = new byte[Length];
        System.arraycopy(Buffer, 0, bb, 0, Length);
        String bs = new String(bb) + "\r\n";
        this.taData.append(bs);
    }

    @Override
    public void DriverEventRun() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void DriverEventData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void DriverEventNotify(int Id, int Value) {
        if (Id == 31) {
            if (Value == 0) {
                this.rbtnCTSon.setSelected(false);
                this.rbtnCTSlo.setSelected(true);
            } else {
                this.rbtnCTSon.setSelected(true);
                this.rbtnCTSlo.setSelected(false);
            }
        }
    }
}

