/*
 * Decompiled with CFR 0.152.
 */
package com.radicales.cal.serial;

import com.radicales.cal.serial.SerialParameters;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jssc.SerialPortList;

public class SerialPortSetupDialog
extends JDialog {
    private SerialParameters gSerialParam;
    private boolean exitOk;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBox cbbBaudrate;
    private JComboBox cbbDataBits;
    private JComboBox cbbParity;
    private JComboBox cbbSerialPorts;
    private JComboBox cbbStopBits;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;

    public SerialPortSetupDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Serial Port Parameters");
        this.gSerialParam = new SerialParameters("SerialPortSetup");
        this.loadSerialPorts();
        this.exitOk = false;
    }

    private boolean loadSerialPorts() {
        boolean hasPorts = false;
        this.cbbSerialPorts.removeAllItems();
        this.cbbSerialPorts.enableInputMethods(false);
        String[] portNames = SerialPortList.getPortNames();
        for (int i = 0; i < portNames.length; ++i) {
            this.cbbSerialPorts.addItem(portNames[i]);
            hasPorts = true;
        }
        if (!hasPorts) {
            this.cbbSerialPorts.addItem("COM5");
            this.cbbSerialPorts.addItem("COM6");
        } else {
            this.cbbSerialPorts.enableInputMethods(true);
        }
        return hasPorts;
    }

    public SerialParameters getSetup() {
        return this.gSerialParam;
    }

    public boolean getExitResult() {
        return this.exitOk;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbbSerialPorts = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cbbBaudrate = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbbParity = new JComboBox();
        this.cbbStopBits = new JComboBox();
        this.jLabel5 = new JLabel();
        this.cbbDataBits = new JComboBox();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setResizable(false);
        this.jLabel1.setText("Serial Ports");
        this.cbbSerialPorts.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Baud Rate");
        this.cbbBaudrate.setModel(new DefaultComboBoxModel<String>(new String[]{"1200", "2400", "4800", "9600", "14400", "19200", "38400", "57600", "77400", "115200", ""}));
        this.jLabel3.setText("Parity");
        this.jLabel4.setText("Stop Bits");
        this.cbbParity.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Odd", "Even"}));
        this.cbbStopBits.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "1.5", "2"}));
        this.jLabel5.setText("Data Bits");
        this.cbbDataBits.setModel(new DefaultComboBoxModel<String>(new String[]{"5", "6", "7", "8"}));
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortSetupDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortSetupDialog.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(90, 90, 90).addComponent(this.btnCancel, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk, -1, 64, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbbSerialPorts, 0, 145, Short.MAX_VALUE).addComponent(this.cbbBaudrate, 0, -1, Short.MAX_VALUE).addComponent(this.cbbParity, 0, -1, Short.MAX_VALUE).addComponent(this.cbbStopBits, 0, -1, Short.MAX_VALUE)).addComponent(this.cbbDataBits, -2, 145, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbbSerialPorts, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.cbbBaudrate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbbDataBits, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbbParity, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbbStopBits, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.gSerialParam.setPortName(this.cbbSerialPorts.getSelectedItem().toString());
        this.gSerialParam.setBaudRate(this.cbbBaudrate.getSelectedItem().toString());
        this.gSerialParam.setDatabits("8");
        this.gSerialParam.setStopbits("0");
        this.gSerialParam.setParity("none");
        this.gSerialParam.setReceiveTimeout(0);
        this.exitOk = true;
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SerialPortSetupDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SerialPortSetupDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SerialPortSetupDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SerialPortSetupDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SerialPortSetupDialog dialog = new SerialPortSetupDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class PortDescriptor
    implements Comparator {
        private String gName;
        private String gPrefix;
        private int gIndex;

        public PortDescriptor(String Name, String Prefix, int Index) {
            this.gName = Name;
            this.gPrefix = Prefix;
            this.gIndex = Index;
        }

        public int compare(Object p1, Object p2) {
            PortDescriptor pd1 = (PortDescriptor)p1;
            PortDescriptor pd2 = (PortDescriptor)p2;
            return pd1.gIndex - pd2.gIndex;
        }
    }
}

