/*
 * Decompiled with CFR 0.152.
 */
package com.radicales.cal;

import com.radicales.cal.CalDriverEvent;
import com.radicales.cal.CalDriverException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class CalDriver
implements Runnable {
    public static final int DRIVER_TYPE_UNKNOWN = 0;
    public static final int DRIVER_TYPE_SERIAL = 1;
    public static final int DRIVER_TYPE_JSSC = 2;
    public static final int DRIVER_TYPE_RXTX = 3;
    public static final int DRIVER_TYPE_TCPIP = 4;
    protected InputStream drvInputStream = null;
    protected OutputStream drvOutputStream = null;
    protected final List<CalDriverEvent> drvEventListeners = new ArrayList<CalDriverEvent>();
    protected boolean drvOpen = false;
    protected boolean drvRunning = false;
    protected boolean drvThreading;
    protected Thread drvThread = null;
    protected int drvId;
    protected boolean drvStart;
    protected int drvType;

    public CalDriver(int Type, boolean Threading) {
        this.drvThreading = Threading;
        this.drvStart = true;
        this.drvId = 0;
        this.drvType = Type;
    }

    public CalDriver(int Type, int Id, boolean Start, boolean Threading) {
        this.drvThreading = Threading;
        this.drvStart = Start;
        this.drvId = Id;
        this.drvType = Type;
    }

    public int getType() {
        return this.drvType;
    }

    public boolean isOpen() {
        return this.drvOpen;
    }

    public boolean isRunning() {
        return this.drvRunning;
    }

    public void Open() throws CalDriverException {
        if (this.drvOpen) {
            throw new CalDriverException("Port is open");
        }
        if (this.drvThreading) {
            this.drvThread = new Thread(this);
        }
        this.drvOpen = true;
    }

    public void Close() {
        if (!this.drvOpen) {
            // empty if block
        }
        this.drvOpen = false;
    }

    public void Start() throws CalDriverException {
        if (!this.drvOpen) {
            throw new CalDriverException("Port not open");
        }
        if (!this.drvStart) {
            if (this.drvOpen) {
                this.Close();
            }
            throw new CalDriverException("Port not allowed to start");
        }
        if (this.drvRunning) {
            throw new CalDriverException("Driver already running");
        }
        this.drvRunning = true;
        if (this.drvThreading) {
            this.drvThread.start();
        }
    }

    public void Stop() {
        if (this.drvRunning && this.drvThread != null) {
            try {
                this.drvThread.interrupt();
                this.drvThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.drvRunning = false;
    }

    public int Write(byte[] Buffer, int Length) throws CalDriverException {
        int ret = 0;
        try {
            this.drvOutputStream.write(Buffer, 0, Length);
            ret = Length;
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public int Write(byte[] Buffer) throws CalDriverException {
        int ret = 0;
        try {
            this.drvOutputStream.write(Buffer, 0, Buffer.length);
            ret = Buffer.length;
        }
        catch (IOException ex) {
            throw new CalDriverException("::Driver::Write:" + ex.getMessage());
        }
        return ret;
    }

    public int Read(byte[] Buffer, int Length) throws CalDriverException {
        int ret = 0;
        try {
            ret = this.drvInputStream.read(Buffer, 0, Length);
        }
        catch (IOException ex) {
            throw new CalDriverException("::Driver::Write:" + ex.getMessage());
        }
        return ret;
    }

    public int Read(byte[] Buffer) throws CalDriverException {
        int ret = 0;
        try {
            ret = this.drvInputStream.read(Buffer, 0, Buffer.length);
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public int Read() throws CalDriverException {
        int ret = 0;
        try {
            ret = this.drvInputStream.read();
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public int WriteRead(byte[] Buffer, int Length) throws CalDriverException {
        int ret = 0;
        try {
            this.drvOutputStream.write(Buffer, 0, Length);
            ret = this.drvInputStream.read(Buffer, 0, Length);
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public int WriteRead(byte[] Buffer, int WriteLength, int ReadLength) throws CalDriverException {
        int ret = 0;
        try {
            this.drvOutputStream.write(Buffer, 0, WriteLength);
            ret = this.drvInputStream.read(Buffer, 0, ReadLength);
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public int WriteRead(byte[] Buffer) throws CalDriverException {
        int ret = 0;
        try {
            this.drvOutputStream.write(Buffer, 0, Buffer.length);
            ret = this.drvInputStream.read(Buffer, 0, Buffer.length);
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public void Flush() throws CalDriverException {
        try {
            if (this.drvOutputStream != null) {
                this.drvOutputStream.flush();
            }
            if (this.drvInputStream != null) {
                while (this.drvInputStream.available() > 0) {
                    this.drvInputStream.read();
                }
            }
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
    }

    public int IoControl(int Code, int Arg) throws CalDriverException {
        int ret = 0;
        try {
            switch (Code) {
                case 10: {
                    ret = this.drvInputStream.available();
                }
            }
        }
        catch (IOException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    public void addEventListener(CalDriverEvent EventListener) {
        this.drvEventListeners.add(EventListener);
    }

    public void removeEventListener(CalDriverEvent EventListener) {
        this.drvEventListeners.remove(EventListener);
    }

    @Override
    public void run() {
        for (CalDriverEvent ev : this.drvEventListeners) {
            ev.DriverEventRun();
        }
    }
}

