#!/bin/sh
# 
# setsolascfg.sh
# Script to setup the SOLAS application
#
# (C) 2016, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za

XMLCFG=/home/root/RobotApp/SysRobot/config.xml
#XMLCFG=config.xml
XMLBUSINESSTAG=HttpBusinessURLPrefix
XMLLOCTAG=ModuleAlias
XMLTYPETAG=TransactionType
XMLNAMETAG=ModuleName
XMLRS232TAG0=Serial1
XMLRS232TAG1=Serial2
BUSINESSURL=http://192.168.0.1:8080/palletizer?
RS232CONFIG0="9600"
RS232CONFIG1="9600"
LOCATION="Unknown"
TRANSTYPE="scale"
MODNAME="Robot"

PARAM=$2
OIFS="$IFS"
IFS='&'
set -- $PARAM
IFS=' '
PARAMS=$@
IFS="$OIFS"

for i in $PARAMS; do
    # process "$i"
    IFS='=';
    set -- $i;
    if [ $1 = "businessurl" ]; then
	BUSINESSURL=$2
    elif [ $1 = "location" ]; then
	LOCATION=$2
    elif [ $1 = "transtype" ]; then
	TRANSTYPE=$2
    elif [ $1 = "modname" ]; then
	MODNAME=$2
    elif [ $1 = "rs232config0" ]; then
	RS232CONFIG0=$2
    elif [ $1 = "rs232config1" ]; then
	RS232CONFIG1=$2
    fi
done
IFS="$OIFS"

sed -i "s%\(<$XMLBUSINESSTAG>\).*\(<\/$XMLBUSINESSTAG\)%\1$BUSINESSURL\2%" $XMLCFG
sed -i "s%\(<$XMLLOCTAG>\).*\(<\/$XMLLOCTAG\)%\1$LOCATION\2%" $XMLCFG
sed -i "s%\(<$XMLTYPETAG>\).*\(<\/$XMLTYPETAG\)%\1$TRANSTYPE\2%" $XMLCFG
sed -i "s%\(<$XMLNAMETAG>\).*\(<\/$XMLNAMETAG\)%\1$MODNAME\2%" $XMLCFG
# sed -i "s%\(<$XMLRS232TAG0>\).*\(<\/$XMLRS232TAG0\)%\1<Baudrate>$RS232CONFIG0</Baudrate>\2%" $XMLCFG
# sed -i "s%\(<$XMLRS232TAG1>\).*\(<\/$XMLRS232TAG1\)%\1<Baudrate>$RS232CONFIG1</Baudrate>\2%" $XMLCFG

S1PAT=$(awk -vbaud=$RS232CONFIG0 'BEGIN{doit=0} /.*/{if((doit < 1) && ($0 !~ "<Serial1>")) {print}} /<Serial1/{doit=1;} doit{sub(/<Baudrate[^<]+<\/Baudrate>/, "<Baudrate>"baud"</Baudrate>"); print} /<\/Serial1>/{doit=0}' $XMLCFG)

S1PAT=$(echo $S1PAT | awk -vbaud=$RS232CONFIG1 'BEGIN{doit=0} /.*/{if((doit < 1) && ($0 !~ "<Serial2>")) {print}} /<Serial2/{doit=1;} doit{sub(/<Baudrate[^<]+<\/Baudrate>/, "<Baudrate>"baud"</Baudrate>"); print} /<\/#Serial2>/{doit=0}') 
#echo $S1PAT
echo "$S1PAT" > "$XMLCFG"

#echo "$XMLBUSINESSTAG=$BUSINESSURL\n" > solas.txt
#echo "$XMLRS232TAG0=$RS232CONFIG0\n" >> solas.txt
#echo "$XMLRS232TAG1=$RS232CONFIG1\n" >> solas.txt

echo '{"status":"ok"}'

