#!/bin/sh
# 
# getsolascfg.sh
# Script to retrieve the current SOLAS configuration
#
# (C) 2016, Radical Electronic Systems - www.radicalsystems.co.za
# Written by Jan Zwiegers, jan@radicalsystems.co.za

STATUS="stop"
# XMLCFG=`cat /home/root/RobotApp/SysRobot/config.xml`
XMLCFG=/home/root/RobotApp/SysRobot/config.xml
#XMLCFG=config.xml
XMLBUSTAG=HttpBusinessURLPrefix
XMLLOCTAG=ModuleAlias
XMLTYPETAG=TransactionType
XMLNAMETAG=ModuleName

BUSINESSURL=$(cat $XMLCFG | sed -n -e "s/.*<$XMLBUSTAG>\(.*\)<\/$XMLBUSTAG>.*/\1/p")
LOCATION=$(cat $XMLCFG | sed -n -e "s/.*<$XMLLOCTAG>\(.*\)<\/$XMLLOCTAG>.*/\1/p")
TRANSTYPE=$(cat $XMLCFG | sed -n -e "s/.*<$XMLTYPETAG>\(.*\)<\/$XMLTYPETAG>.*/\1/p")
MODNAME=$(cat $XMLCFG | sed -n -e "s/.*<$XMLNAMETAG>\(.*\)<\/$XMLNAMETAG>.*/\1/p")
RS232CONFIG0=$(awk '/<Serial1/{doit=1;} doit{print} /<\/Serial1>/{doit=0}' $XMLCFG)
RS232CONFIG0=$(echo $RS232CONFIG0 | sed -n -e "s/.*<Baudrate>\(.*\)<\/Baudrate>.*/\1/p")
RS232CONFIG1=$(awk '/<Serial2/{doit=1;} doit{print} /<\/Serial2>/{doit=0}' $XMLCFG)
RS232CONFIG1=$(echo $RS232CONFIG1 | sed -n -e "s/.*<Baudrate>\(.*\)<\/Baudrate>.*/\1/p")
JAVAVER=$(java -version 2>&1 | awk '/version/{gsub(/\"/,"");print $NF}')
STATUS=$(ps | grep -v grep | grep 'SysRobot')

if [ -z $STATUS ]; then
   STATUS="stop"
else
   STATUS="run"
fi


echo "{\"appstatus\":\"$STATUS\", \"javaversion\":\"$JAVAVER\", \"appversion\":\"v1.09\", \"businessurl\":\"$BUSINESSURL\", \"modname\":\"$MODNAME\", \"transtype\":\"$TRANSTYPE\", \"location\":\"$LOCATION\", \"rs232config0\":\"$RS232CONFIG0\", \"rs232config1\":\"$RS232CONFIG1\"}"
