#!/bin/sh
#
#  
#
# BIN=/etc/init.d/robotd
BIN=/etc/init.d/robotd
STATUS="missing"
COMMAND="missing"

# break up elements into array
PARAM=$2
OIFS="$IFS"
IFS='&'
set -- $PARAM
IFS=' '
PARAMS=$@
IFS="$OIFS"

for i in $PARAMS; do
    # process "$i"
    IFS='=';
    set -- $i;
    if [ $1 == "command" ]; then
	COMMAND=$2
    fi
done


# check if robot daemon file exists
if [ ! -e $BIN  ]; then
    echo "{\"status\":\"daemon control script missing\"}"    
    exit 0
fi

$BIN $COMMAND >> /dev/null

if [ $? -eq 0 ]; then
    # app started OK
    STATUS="ok"
else
   # app failed
   STATUS="failed"
fi

echo "{\"status\":\"$STATUS\"}"
exit 0

