/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class SerialNativeInterface {
    private static final String libVersion = "0.9";
    private static final String libMinorSuffix = "0";
    public static final int OS_LINUX = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_MAC_OS_X = 3;
    private static int osType = -1;

    private static boolean isLibFolderExist(String libFolderPath) {
        boolean returnValue = false;
        File folder = new File(libFolderPath);
        if (folder.exists() && folder.isDirectory()) {
            returnValue = true;
        }
        return returnValue;
    }

    private static boolean isLibFileExist(String libFilePath) {
        boolean returnValue = false;
        File folder = new File(libFilePath);
        if (folder.exists() && folder.isFile()) {
            returnValue = true;
        }
        return returnValue;
    }

    private static boolean extractLib(String libFilePath, String osName, String libName) {
        boolean returnValue = false;
        File libFile = new File(libFilePath);
        InputStream input = null;
        FileOutputStream output = null;
        input = SerialNativeInterface.class.getResourceAsStream("/libs/" + osName + "/" + libName);
        if (input != null) {
            byte[] buffer = new byte[4096];
            try {
                int read;
                output = new FileOutputStream(libFilePath);
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                output.close();
                input.close();
                returnValue = true;
            }
            catch (Exception ex) {
                try {
                    output.close();
                    if (libFile.exists()) {
                        libFile.delete();
                    }
                }
                catch (Exception ex_out) {
                    // empty catch block
                }
                try {
                    input.close();
                }
                catch (Exception ex_in) {
                    // empty catch block
                }
            }
        }
        return returnValue;
    }

    public static int getOsType() {
        return osType;
    }

    public static String getLibraryVersion() {
        return "0.9.0";
    }

    public static String getLibraryBaseVersion() {
        return libVersion;
    }

    public static String getLibraryMinorSuffix() {
        return libMinorSuffix;
    }

    public native int openPort(String var1);

    public native boolean setParams(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public native boolean purgePort(int var1, int var2);

    public native boolean closePort(int var1);

    public native boolean setEventsMask(int var1, int var2);

    public native int getEventsMask(int var1);

    public native int[][] waitEvents(int var1);

    public native boolean setRTS(int var1, boolean var2);

    public native boolean setDTR(int var1, boolean var2);

    public native byte[] readBytes(int var1, int var2);

    public native boolean writeBytes(int var1, byte[] var2);

    public native int[] getBuffersBytesCount(int var1);

    public native boolean setFlowControlMode(int var1, int var2);

    public native int getFlowControlMode(int var1);

    public native String[] getSerialPortNames();

    public native int[] getLinesStatus(int var1);

    public native boolean sendBreak(int var1, int var2);

    static {
        String osName = System.getProperty("os.name");
        String architecture = System.getProperty("os.arch");
        String userHome = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        if (osName.equals("Linux")) {
            osName = "linux";
            osType = 0;
        } else if (osName.startsWith("Win")) {
            osName = "windows";
            osType = 1;
        } else if (osName.equals("SunOS")) {
            osName = "solaris";
            osType = 2;
        } else if (osName.equals("Mac OS X")) {
            osName = "mac_os_x";
            osType = 3;
        }
        if (architecture.equals("i386") || architecture.equals("i686")) {
            architecture = "x86";
        } else if (architecture.equals("amd64")) {
            architecture = "x86_64";
        }
        String libFolderPath = userHome + fileSeparator + ".jssc" + fileSeparator + osName;
        String libName = "jSSC-0.9_" + architecture;
        libName = System.mapLibraryName(libName);
        boolean loadLib = false;
        if (SerialNativeInterface.isLibFolderExist(libFolderPath)) {
            if (SerialNativeInterface.isLibFileExist(libFolderPath + fileSeparator + libName)) {
                loadLib = true;
            } else if (SerialNativeInterface.extractLib(libFolderPath + fileSeparator + libName, osName, libName)) {
                loadLib = true;
            }
        } else if (new File(libFolderPath).mkdirs() && SerialNativeInterface.extractLib(libFolderPath + fileSeparator + libName, osName, libName)) {
            loadLib = true;
        }
        if (loadLib) {
            System.load(libFolderPath + fileSeparator + libName);
        }
    }
}

