/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class XmlNode {
    public ArrayList children = new ArrayList();
    public String name;
    public String text;
    public Map attributes = new HashMap();
    public Map indentMap = new HashMap();
    private static int first = 0;
    private static String ctlString = "";
    private static String indentation = "";

    public XmlNode(Map attributes, String name) {
        this.name = name;
        this.attributes.putAll(attributes);
    }

    public void addChild(XmlNode node) {
        this.children.add(node);
    }

    public void addChild(XmlNode node, int position) {
        this.children.add(position, node);
    }

    public void removeChild(XmlNode node) {
        this.children.remove(node);
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public XmlNode getNode(String path) {
        XmlNode currentNode = this;
        String[] pathArray = this.constructPathArray(path);
        String searchTarget = pathArray[0].toString();
        XmlNode n = this.getSearchNode(currentNode, searchTarget);
        if (n != null) {
            currentNode = n;
        }
        pathArray = this.reducePathLength(pathArray);
        XmlNode returnNode = null;
        if (pathArray.length > 1) {
            if (currentNode.children.size() > 0) {
                XmlNode requiredNode = null;
                while (pathArray.length > 1) {
                    searchTarget = pathArray[0].toString();
                    pathArray = this.reducePathLength(pathArray);
                    requiredNode = this.getSearchNode(currentNode, searchTarget);
                    if (requiredNode == null) break;
                    currentNode = requiredNode;
                }
                if (requiredNode == null) {
                    returnNode = null;
                } else {
                    searchTarget = pathArray[0];
                    if (requiredNode.children.size() > 0) {
                        if (searchTarget.indexOf("[") == -1) {
                            returnNode = null;
                        } else {
                            int startIndex = searchTarget.indexOf("[");
                            int endIndex = searchTarget.indexOf("]");
                            String attrPhrase = searchTarget.substring(startIndex + 1, endIndex);
                            String nodeName = searchTarget.substring(0, startIndex);
                            Map attMap = this.getSearchAttributes(attrPhrase);
                            int searchMark = attMap.size();
                            for (int i = 0; i < requiredNode.children.size(); ++i) {
                                Iterator iter = attMap.keySet().iterator();
                                XmlNode childNode = (XmlNode)requiredNode.children.get(i);
                                while (iter.hasNext()) {
                                    String keyName = iter.next().toString().trim();
                                    if (!childNode.attributes.containsKey(keyName) || !childNode.name.trim().equalsIgnoreCase(nodeName)) continue;
                                    String attMapValue = (String)attMap.get(keyName);
                                    String attNodeValue = (String)childNode.attributes.get(keyName);
                                    if (!attMapValue.trim().equalsIgnoreCase(attNodeValue.trim())) continue;
                                    --searchMark;
                                }
                                if (searchMark == 0) {
                                    returnNode = childNode;
                                    break;
                                }
                                searchMark = attMap.size();
                            }
                        }
                    } else {
                        returnNode = null;
                    }
                }
            } else {
                returnNode = null;
            }
        } else if (currentNode.children.size() > 0) {
            searchTarget = pathArray[0].toString();
            if (searchTarget.indexOf("[") == -1) {
                returnNode = null;
            } else {
                int startIndex = searchTarget.indexOf("[");
                int endIndex = searchTarget.indexOf("]");
                String attrPhrase = searchTarget.substring(startIndex + 1, endIndex);
                String nodeName = searchTarget.substring(0, startIndex);
                Map attMap = this.getSearchAttributes(attrPhrase);
                int searchMark = attMap.size();
                for (int i = 0; i < currentNode.children.size(); ++i) {
                    Iterator iter = attMap.keySet().iterator();
                    XmlNode childNode = (XmlNode)currentNode.children.get(i);
                    while (iter.hasNext()) {
                        String keyName = iter.next().toString().trim();
                        if (!childNode.attributes.containsKey(keyName) || !childNode.name.trim().equalsIgnoreCase(nodeName)) continue;
                        String attMapValue = (String)attMap.get(keyName);
                        String attNodeValue = (String)childNode.attributes.get(keyName);
                        System.out.println("Attribute Map Value:" + attMapValue.trim());
                        System.out.println("Attribute Node Value:" + attNodeValue.trim());
                        if (!attMapValue.trim().equalsIgnoreCase(attNodeValue.trim())) continue;
                        --searchMark;
                    }
                    if (searchMark == 0) {
                        returnNode = childNode;
                        break;
                    }
                    searchMark = attMap.size();
                }
            }
        } else {
            returnNode = null;
        }
        return returnNode;
    }

    public ArrayList getNodeList(String path) {
        ArrayList<XmlNode> returnNodeList;
        block6: {
            String searchTarget;
            XmlNode currentNode;
            block7: {
                returnNodeList = new ArrayList<XmlNode>();
                if (path.toString().trim().equalsIgnoreCase("")) break block6;
                currentNode = this;
                String[] pathArray = this.constructPathArray(path);
                searchTarget = pathArray[0].toString().trim();
                if (pathArray.length <= 1) break block7;
                if (currentNode.children.size() <= 0) break block6;
                XmlNode requiredNode = null;
                while (pathArray.length > 1 && (requiredNode = this.getSearchNode(currentNode, searchTarget = pathArray[0].toString())) != null) {
                    currentNode = requiredNode;
                    pathArray = this.reducePathLength(pathArray);
                }
                if (requiredNode != null) {
                    searchTarget = pathArray[0].toString().trim();
                    if (requiredNode.children.size() > 0) {
                        for (int i = 0; i < requiredNode.children.size(); ++i) {
                            XmlNode childNode = (XmlNode)requiredNode.children.get(i);
                            if (!childNode.name.toString().equalsIgnoreCase(searchTarget)) continue;
                            returnNodeList.add(childNode);
                        }
                    }
                }
                break block6;
            }
            if (currentNode.children.size() > 0) {
                for (int i = 0; i < currentNode.children.size(); ++i) {
                    XmlNode childNode = (XmlNode)currentNode.children.get(i);
                    if (!childNode.name.trim().equalsIgnoreCase(searchTarget)) continue;
                    returnNodeList.add(childNode);
                }
            }
        }
        return returnNodeList;
    }

    public String toXml() {
        String nodeXml = "<" + this.name + " ";
        Set contents = this.attributes.entrySet();
        for (Map.Entry me : contents) {
            nodeXml = nodeXml + me.getKey().toString() + "=\"" + me.getValue().toString() + "\" ";
        }
        nodeXml = nodeXml + ">";
        if (this.text != null) {
            nodeXml = nodeXml + this.text;
        }
        if (!this.children.isEmpty()) {
            for (int i = 0; i < this.children.size(); ++i) {
                XmlNode childNode = (XmlNode)this.children.get(i);
                nodeXml = nodeXml + childNode.toXml();
            }
        }
        nodeXml = nodeXml + "</" + this.name + ">";
        return nodeXml;
    }

    public String toXml(int level, String ex) {
        String nodeXml = indentation + "<" + this.name + " ";
        nodeXml = first++ != 0 ? indentation + "<" + this.name + " " : "\n" + indentation + "<" + this.name + " ";
        Set contents = this.attributes.entrySet();
        for (Map.Entry me : contents) {
            nodeXml = nodeXml + me.getKey().toString() + "=\"" + me.getValue().toString() + "\" ";
        }
        nodeXml = nodeXml + ">";
        if (this.text != null) {
            nodeXml = nodeXml + this.text;
        }
        if (!this.children.isEmpty()) {
            ++level;
            for (int i = 0; i < this.children.size(); ++i) {
                nodeXml = nodeXml + "\n";
                XmlNode childNode = (XmlNode)this.children.get(i);
                nodeXml = nodeXml + childNode.toXml(level, "");
            }
            nodeXml = nodeXml + "\n" + indentation;
        }
        nodeXml = nodeXml + "</" + this.name + ">";
        return nodeXml;
    }

    private String[] constructPathArray(String path) {
        String[] pathArray;
        if (path.indexOf("/") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            pathArray = new String[tokenizer.countTokens()];
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                pathArray[count] = tokenizer.nextToken().toString();
                ++count;
            }
        } else {
            pathArray = new String[]{path};
        }
        return pathArray;
    }

    private Map getSearchAttributes(String attrPhrase) {
        StringTokenizer tokenizer = new StringTokenizer(attrPhrase, ",");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            StringTokenizer attTokenizer = new StringTokenizer(tokenizer.nextToken().trim(), "=");
            String attName = attTokenizer.nextToken();
            String attValue = attTokenizer.nextToken();
            attributeMap.put(attName, attValue);
        }
        return attributeMap;
    }

    private String[] reducePathLength(String[] pathArray) {
        String[] returnPath = new String[pathArray.length - 1];
        for (int i = 0; i < returnPath.length; ++i) {
            returnPath[i] = pathArray[i + 1];
        }
        return returnPath;
    }

    private String reConstructPath(String[] pathArray) {
        String retPath = "";
        for (int i = 0; i < pathArray.length; ++i) {
            retPath = retPath.equals("") ? retPath + pathArray[i].toString() : retPath + "/" + pathArray[i].toString();
        }
        return retPath;
    }

    private XmlNode getSearchNode(XmlNode parentNode, String nodeName) {
        XmlNode returnNode = null;
        if (nodeName.indexOf("[") != -1) {
            int startIndex = nodeName.indexOf("[");
            int endIndex = nodeName.indexOf("]");
            String attrPhrase = nodeName.substring(startIndex + 1, endIndex);
            String node_name = nodeName.substring(0, startIndex);
            Map attMap = this.getSearchAttributes(attrPhrase);
            int searchMark = attMap.size();
            for (int i = 0; i < parentNode.children.size(); ++i) {
                Iterator iter = attMap.keySet().iterator();
                XmlNode childNode = (XmlNode)parentNode.children.get(i);
                while (iter.hasNext()) {
                    String keyName = iter.next().toString().trim();
                    if (!childNode.attributes.containsKey(keyName) || !childNode.name.trim().equalsIgnoreCase(node_name)) continue;
                    String attMapValue = (String)attMap.get(keyName);
                    String attNodeValue = (String)childNode.attributes.get(keyName);
                    if (!attMapValue.trim().equalsIgnoreCase(attNodeValue.trim())) continue;
                    --searchMark;
                }
                if (searchMark == 0) {
                    returnNode = childNode;
                    break;
                }
                searchMark = attMap.size();
            }
        } else {
            for (int i = 0; i < parentNode.children.size(); ++i) {
                if (!((XmlNode)parentNode.children.get((int)i)).name.equalsIgnoreCase(nodeName)) continue;
                returnNode = (XmlNode)parentNode.children.get(i);
            }
        }
        return returnNode;
    }
}

