/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.xml;

import com.nosoft.mobile.mes.xml.HandlerBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;

public class SAXParser {
    private static SAXParser instance = new SAXParser();
    private HandlerBase dombuilder;

    private SAXParser() {
    }

    public static SAXParser getParser() {
        return instance;
    }

    public void parse(InputStream xmlConfig, HandlerBase hb) throws IOException {
        this.dombuilder = hb;
        InputStreamReader reader = new InputStreamReader(xmlConfig);
        BufferedReader in = new BufferedReader(reader);
        HashMap<String, String> attrList = new HashMap<String, String>();
        int previous_char = 32;
        Stack<String> tempStack = new Stack<String>();
        String closing_tag = "";
        boolean opening_tag = false;
        boolean end_element = false;
        boolean attr_name = false;
        boolean attr_value = false;
        boolean special_attr_value_char = false;
        int returnedChar = reader.read();
        if (returnedChar != -1 && returnedChar == 60) {
            opening_tag = true;
            previous_char = (char)returnedChar;
            returnedChar = reader.read();
        }
        String current_node_name = "";
        String current_attr_name = "";
        String current_attr_value = "";
        String char_string = "";
        while (returnedChar != -1) {
            if (previous_char == 60 && (char)returnedChar == '/') {
                end_element = true;
                closing_tag = (String)tempStack.pop();
                this.dombuilder.endElement(closing_tag);
            } else if (previous_char == 47 && (char)returnedChar == '>') {
                if (current_attr_name.trim().length() > 0) {
                    if ((current_attr_value = current_attr_value.substring(0, current_attr_value.length() - 1).trim()).length() > 1) {
                        current_attr_value = current_attr_value.substring(1, current_attr_value.length() - 1);
                    }
                    attrList.put(current_attr_name, current_attr_value.replace('^', '='));
                }
                tempStack.addElement(current_node_name);
                this.dombuilder.startElement(current_node_name, attrList);
                current_attr_name = "";
                current_attr_value = "";
                current_node_name = "";
                opening_tag = false;
                attrList.clear();
                end_element = false;
                closing_tag = (String)tempStack.pop();
                this.dombuilder.endElement(closing_tag);
            } else if (opening_tag && (char)returnedChar != '>' && !end_element) {
                if (!attr_name && !attr_value && (char)returnedChar != ' ' && (char)returnedChar != '=' && (char)returnedChar != '/' && previous_char != 32 && previous_char != 61) {
                    current_node_name = current_node_name + (char)returnedChar;
                } else if ((attr_name || previous_char == 32 && !attr_value) && previous_char != 61 && (char)returnedChar != '=' && (char)returnedChar != '/') {
                    attr_name = true;
                    current_attr_name = current_attr_name + (char)returnedChar;
                } else if (attr_value && (char)returnedChar != '=' || previous_char == 61) {
                    attr_value = true;
                    current_attr_value = current_attr_value + (char)returnedChar;
                } else if ((char)returnedChar == '=' && current_attr_value.length() > 0) {
                    StringTokenizer token = new StringTokenizer(current_attr_value, " ");
                    ArrayList<String> attr_value_tokens = new ArrayList<String>();
                    while (token.hasMoreTokens()) {
                        attr_value_tokens.add(token.nextToken());
                    }
                    String new_current_attr_name = (String)attr_value_tokens.get(attr_value_tokens.size() - 1);
                    int new_length = current_attr_value.length() - new_current_attr_name.length();
                    current_attr_value = current_attr_value.substring(0, new_length);
                    if ((current_attr_value = current_attr_value.trim()).length() > 1) {
                        current_attr_value = current_attr_value.substring(1, current_attr_value.length() - 1);
                    }
                    attrList.put(current_attr_name, current_attr_value.replace('^', '='));
                    current_attr_name = new_current_attr_name;
                    current_attr_value = "";
                    previous_char = (char)returnedChar;
                    attr_value = true;
                    attr_name = false;
                } else if ((char)returnedChar == '=') {
                    attr_name = false;
                }
            } else if ((char)returnedChar == '>') {
                if (current_attr_name.trim().length() > 0) {
                    if ((current_attr_value = current_attr_value.trim()).length() > 1) {
                        current_attr_value = current_attr_value.substring(1, current_attr_value.length() - 1);
                    }
                    attrList.put(current_attr_name, current_attr_value.replace('^', '='));
                }
                if (current_node_name.trim().length() > 0 && current_node_name.charAt(0) != '?') {
                    tempStack.addElement(current_node_name);
                    this.dombuilder.startElement(current_node_name, attrList);
                }
                current_attr_name = "";
                current_attr_value = "";
                current_node_name = "";
                opening_tag = false;
                attrList.clear();
                end_element = false;
            } else if ((char)returnedChar == '<' && returnedChar != -1) {
                char[] buff = char_string.toCharArray();
                if (buff.length > 0) {
                    this.dombuilder.characters(buff, 0, buff.length);
                }
                opening_tag = true;
                buff = null;
                char_string = "";
                attr_name = false;
                attr_value = false;
            } else if (!end_element) {
                char_string = char_string + (char)returnedChar;
            }
            previous_char = (char)returnedChar;
            returnedChar = reader.read();
        }
        this.dombuilder.endDocument();
    }
}

