/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.util;

import com.nosoft.mobile.mes.devices.DeviceConstants;
import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.mes.util.ScanInputDetail;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ScanEvaluation
implements DeviceConstants {
    private String deviceName = "";
    private String parameterData = "";
    private MessageInterface msg = null;
    private String primaryScanGrp = "";
    private String secondaryScanGrp = "";
    private int inputCnt = 0;
    private int inputNr = 0;
    private String inputDialog = "";
    private int scanGroup = 0;
    private Map inputDialogMap = Collections.synchronizedMap(new HashMap());
    private Map inputLengthMap = Collections.synchronizedMap(new HashMap());
    private Map inputLengthMap_L = Collections.synchronizedMap(new HashMap());
    private boolean inputRecogUse = false;
    private Map inputRecogMap = Collections.synchronizedMap(new HashMap());
    private Map idScanMap = Collections.synchronizedMap(new HashMap());
    private Map primaryScanMap = Collections.synchronizedMap(new HashMap());
    private Map primaryScanDetailMap = Collections.synchronizedMap(new HashMap());
    private Map secondaryScanMap = Collections.synchronizedMap(new HashMap());
    private Map secondaryScanDetailMap = Collections.synchronizedMap(new HashMap());
    private ScanInputDetail sidCurrent = null;
    private int primarySize = 0;
    private boolean primaryTrigger = false;
    private boolean primarySequence = false;
    private boolean primaryNoSeq = false;
    private String[] primaryInputValues = null;
    private int secondarySize = 0;
    private boolean secondaryTrigger = false;
    private boolean secondarySequence = false;
    private boolean secondaryNoSeq = false;
    private String[] secondaryInputValues = null;
    private XmlAttributeFactory xmlAttr = new XmlAttributeFactory();

    public ScanEvaluation(MessageInterface msg, String peripheralName, String parameterData) {
        this.msg = msg;
        this.deviceName = peripheralName;
        this.parameterData = parameterData;
        this.setPrimaryScanGroup(parameterData);
        this.setSecondaryScanGroup(parameterData);
        this.parseScannerIDs(parameterData);
        if (this.parseSetupData(parameterData)) {
            // empty if block
        }
    }

    private boolean parseSetupData(String parameterData) {
        boolean b = false;
        int l = 0;
        int len = 0;
        this.inputCnt = 0;
        boolean bl = true;
        int i = 1;
        while (bl) {
            block11: {
                String ft = this.xmlAttr.parseTagAttribute("Dialog" + i, parameterData);
                String fl = this.xmlAttr.parseTagAttribute("Length" + i, parameterData);
                String rs = this.xmlAttr.parseTagAttribute("RecognitionString" + i, parameterData);
                if (fl.length() < 1 && rs.length() < 1) {
                    b = true;
                    bl = false;
                    this.inputCnt = len;
                } else {
                    ScanInputDetail sce;
                    if (!rs.isEmpty()) {
                        l = rs.length();
                        this.inputRecogUse = true;
                        this.inputRecogMap.put(rs, i);
                    } else {
                        try {
                            l = Integer.parseInt(this.xmlAttr.parseTagAttribute("Length" + i, parameterData));
                        }
                        catch (NumberFormatException nfe) {
                            bl = false;
                            String m = this.deviceName + ": Parsing error in scanner length field ='Length" + i + "'...";
                            this.msg.sysMsg("bold+red", m);
                            break block11;
                        }
                    }
                    this.inputDialogMap.put(i, ft);
                    this.inputLengthMap.put(l, i);
                    this.inputLengthMap_L.put(i, l);
                    ++len;
                    if (this.primaryScanDetailMap.containsKey(i)) {
                        sce = (ScanInputDetail)this.primaryScanDetailMap.get(i);
                        if (sce != null) {
                            sce.setInputRecognitionStr(rs);
                            sce.setInputLengthDefinition(l);
                            sce.setInputDialog(ft);
                        }
                    } else if (this.secondaryScanDetailMap.containsKey(i) && (sce = (ScanInputDetail)this.secondaryScanDetailMap.get(i)) != null) {
                        sce.setInputRecognitionStr(rs);
                        sce.setInputLengthDefinition(l);
                        sce.setInputDialog(ft);
                    }
                }
            }
            ++i;
        }
        return b;
    }

    public int getScanGroup() {
        return this.scanGroup;
    }

    public String[] getInputIDs() {
        if (this.idScanMap.isEmpty()) {
            return null;
        }
        int len = this.idScanMap.size();
        String[] inputIDs = new String[len];
        int i = 0;
        int cnt = 1;
        while (i < len) {
            inputIDs[i] = (String)this.idScanMap.get("" + cnt);
            ++i;
            ++cnt;
        }
        return inputIDs;
    }

    public int getInputCount() {
        return this.inputCnt;
    }

    public int[] getInputLengths() {
        if (this.inputCnt == 0) {
            return null;
        }
        if (this.inputLengthMap.isEmpty()) {
            return null;
        }
        int[] inputLengths = new int[this.inputCnt];
        int i = 0;
        int cnt = 1;
        while (i < this.inputCnt) {
            inputLengths[i] = (Integer)this.inputLengthMap_L.get(cnt);
            ++i;
            ++cnt;
        }
        return inputLengths;
    }

    public String[] getInputLabels() {
        if (this.inputCnt == 0) {
            return null;
        }
        if (this.inputDialogMap.isEmpty()) {
            return null;
        }
        String[] inputLabels = new String[this.inputCnt];
        int i = 0;
        int cnt = 1;
        while (i < this.inputCnt) {
            inputLabels[i] = (String)this.inputDialogMap.get(cnt);
            ++i;
            ++cnt;
        }
        return inputLabels;
    }

    public String[] getRecognitionStrings() {
        if (this.inputRecogMap.isEmpty()) {
            return null;
        }
        int len = this.inputRecogMap.size();
        String[] recogStrings = new String[len];
        Set keys = this.inputRecogMap.keySet();
        Iterator ir = keys.iterator();
        int cnt = 0;
        try {
            while (ir.hasNext()) {
                String k = (String)ir.next();
                if ((k = k.trim()) == null) {
                    k = "";
                }
                recogStrings[cnt++] = k;
            }
        }
        catch (Exception e) {
            this.msg.sysMsg("bold+red", "Scanlist recognition string configuration error....");
        }
        return recogStrings;
    }

    public String getDialogInGroup(int scanGroup, int currentScanPos) {
        String label = "";
        boolean b = true;
        if (this.inputDialogMap.containsKey(currentScanPos)) {
            label = (String)this.inputDialogMap.get(currentScanPos);
        }
        return label;
    }

    public String getNextDialogInGroup(int scanGroup, int currentScanPos) {
        String label = "";
        boolean b = true;
        switch (scanGroup) {
            case 1: {
                if (this.primaryNoSeq) {
                    for (int j = 0; b && j < this.primarySize; ++j) {
                        ScanInputDetail sid;
                        if (!this.primaryScanMap.containsKey(j) || !(sid = (ScanInputDetail)this.primaryScanMap.get(j)).getInputValue().isEmpty()) continue;
                        b = false;
                        label = sid.getInputDialog();
                    }
                } else {
                    for (int j = currentScanPos + 1; b && j < this.primarySize; ++j) {
                        ScanInputDetail sid;
                        if (!this.primaryScanMap.containsKey(j) || !(sid = (ScanInputDetail)this.primaryScanMap.get(j)).getInputValue().isEmpty()) continue;
                        b = false;
                        label = sid.getInputDialog();
                    }
                }
                break;
            }
            case 2: {
                if (this.secondaryNoSeq) {
                    for (int j = 0; b && j < this.secondarySize; ++j) {
                        ScanInputDetail sid;
                        if (!this.secondaryScanMap.containsKey(j) || !(sid = (ScanInputDetail)this.secondaryScanMap.get(j)).getInputValue().isEmpty()) continue;
                        b = false;
                        label = sid.getInputDialog();
                    }
                } else {
                    for (int j = currentScanPos + 1; b && j < this.secondarySize; ++j) {
                        ScanInputDetail sid;
                        if (!this.secondaryScanMap.containsKey(j) || !(sid = (ScanInputDetail)this.secondaryScanMap.get(j)).getInputValue().isEmpty()) continue;
                        b = false;
                        label = sid.getInputDialog();
                    }
                }
                break;
            }
        }
        return label;
    }

    public ScanInputDetail getCurrentSID() {
        return this.sidCurrent;
    }

    public String[] getPrimaryInputValues() {
        if (this.primarySize < 1) {
            return null;
        }
        String[] tmp = new String[this.primarySize];
        for (int j = 0; j < this.primarySize; ++j) {
            if (!this.primaryScanMap.containsKey(j)) continue;
            ScanInputDetail sid = (ScanInputDetail)this.primaryScanMap.get(j);
            tmp[j] = sid.getInputValue();
        }
        return tmp;
    }

    public String[] getSecondaryInputValues() {
        if (this.secondarySize < 1) {
            return null;
        }
        String[] tmp = new String[this.secondarySize];
        for (int j = 0; j < this.secondarySize; ++j) {
            if (!this.secondaryScanMap.containsKey(j)) continue;
            ScanInputDetail sid = (ScanInputDetail)this.secondaryScanMap.get(j);
            tmp[j] = sid.getInputValue();
        }
        return tmp;
    }

    public void clearAllInputValues() {
        this.clearPrimaryInputValues();
        this.clearSecondaryInputValues();
    }

    public void clearPrimaryInputValues() {
        this.primaryTrigger = false;
        for (int j = 0; j < this.primarySize; ++j) {
            if (!this.primaryScanMap.containsKey(j)) continue;
            ScanInputDetail sid = (ScanInputDetail)this.primaryScanMap.get(j);
            sid.setInputValue("", 0);
        }
    }

    public void clearSecondaryInputValues() {
        this.secondaryTrigger = false;
        for (int j = 0; j < this.secondarySize; ++j) {
            if (!this.secondaryScanMap.containsKey(j)) continue;
            ScanInputDetail sid = (ScanInputDetail)this.secondaryScanMap.get(j);
            sid.setInputValue("", 0);
        }
    }

    public boolean checkPrimaryInputComplete() {
        boolean b = false;
        int cnt = 0;
        for (int j = 0; j < this.primarySize; ++j) {
            ScanInputDetail sid;
            if (!this.primaryScanMap.containsKey(j) || (sid = (ScanInputDetail)this.primaryScanMap.get(j)).getInputValue().isEmpty()) continue;
            ++cnt;
        }
        if (cnt == this.primarySize) {
            b = true;
        }
        return b;
    }

    public boolean checkSecondaryInputComplete() {
        boolean b = false;
        int cnt = 0;
        for (int j = 0; j < this.secondarySize; ++j) {
            ScanInputDetail sid;
            if (!this.secondaryScanMap.containsKey(j) || (sid = (ScanInputDetail)this.secondaryScanMap.get(j)).getInputValue().isEmpty()) continue;
            ++cnt;
        }
        if (cnt == this.secondarySize) {
            b = true;
        }
        return b;
    }

    private boolean checkPrimaryInputSequence(int countPosition, String value) {
        int cnt = 0;
        boolean b = false;
        if (!this.primaryScanMap.containsKey(countPosition)) {
            return false;
        }
        this.primaryTrigger = false;
        if (this.primaryNoSeq) {
            String vl = "";
            for (int j = 0; j < this.primarySize; ++j) {
                ScanInputDetail sid;
                if (!this.primaryScanMap.containsKey(j) || (sid = (ScanInputDetail)this.primaryScanMap.get(j)).getInputValue().isEmpty()) continue;
                ++cnt;
                vl = sid.getInputValue();
            }
            if (cnt == this.primarySize) {
                this.primaryTrigger = true;
            }
            return true;
        }
        for (int j = 0; j < countPosition; ++j) {
            ScanInputDetail sid;
            if (!this.primaryScanMap.containsKey(j) || !(sid = (ScanInputDetail)this.primaryScanMap.get(j)).getInputValue().isEmpty()) continue;
            this.clearPrimaryInputValues();
            return false;
        }
        b = true;
        if (countPosition == this.primarySize - 1) {
            this.primaryTrigger = true;
        }
        return b;
    }

    private boolean checkSecondaryInputSequence(int countPosition, String value) {
        int cnt = 0;
        boolean b = false;
        if (!this.secondaryScanMap.containsKey(countPosition)) {
            return false;
        }
        this.secondaryTrigger = false;
        if (this.secondaryNoSeq) {
            for (int j = 0; j < this.secondarySize; ++j) {
                ScanInputDetail sid;
                if (!this.secondaryScanMap.containsKey(j) || (sid = (ScanInputDetail)this.secondaryScanMap.get(j)).getInputValue().isEmpty()) continue;
                ++cnt;
            }
            if (cnt == this.secondarySize) {
                this.secondaryTrigger = true;
            }
            return true;
        }
        for (int j = 0; j < countPosition; ++j) {
            ScanInputDetail sid;
            if (!this.secondaryScanMap.containsKey(j) || !(sid = (ScanInputDetail)this.secondaryScanMap.get(j)).getInputValue().isEmpty()) continue;
            this.clearSecondaryInputValues();
            return false;
        }
        b = true;
        if (countPosition == this.secondarySize - 1) {
            this.secondaryTrigger = true;
        }
        return b;
    }

    private int evaluateInputValueDetail(boolean recognition, Map evaluationMap, int status, int valueLength, String key, String value) {
        int st = status;
        boolean sw = false;
        if (recognition) {
            sw = true;
            this.inputNr = (Integer)evaluationMap.get(key);
        } else if (evaluationMap.containsKey(valueLength)) {
            sw = true;
            this.inputNr = (Integer)evaluationMap.get(valueLength);
        } else if (evaluationMap.containsKey(0)) {
            this.inputNr = (Integer)evaluationMap.get(0);
        } else {
            return st;
        }
        if (sw) {
            if (this.inputNr != 0) {
                if (this.primaryScanDetailMap.containsKey(this.inputNr)) {
                    this.scanGroup = 1;
                    ScanInputDetail o = (ScanInputDetail)this.primaryScanDetailMap.get(this.inputNr);
                    if (o == null) {
                        st = 14;
                        this.clearPrimaryInputValues();
                        return st;
                    }
                    this.sidCurrent = o;
                    int pos = o.getInputSequenceNumberInGroup();
                    if (pos >= this.primarySize) {
                        st = 13;
                        this.clearPrimaryInputValues();
                        return st;
                    }
                    o.setInputValue(value, st);
                    if (!this.checkPrimaryInputSequence(pos, value)) {
                        st = 12;
                        this.clearPrimaryInputValues();
                        return st;
                    }
                    st = 1;
                } else if (this.secondaryScanDetailMap.containsKey(this.inputNr)) {
                    this.scanGroup = 2;
                    ScanInputDetail o = (ScanInputDetail)this.secondaryScanDetailMap.get(this.inputNr);
                    if (o == null) {
                        st = 24;
                        this.clearSecondaryInputValues();
                        return st;
                    }
                    this.sidCurrent = o;
                    int pos = o.getInputSequenceNumberInGroup();
                    if (pos >= this.secondarySize) {
                        st = 23;
                        this.clearSecondaryInputValues();
                        return st;
                    }
                    o.setInputValue(value, st);
                    if (!this.checkSecondaryInputSequence(pos, value)) {
                        st = 22;
                        this.clearSecondaryInputValues();
                        return st;
                    }
                    st = 2;
                }
            } else {
                st = 50;
            }
        } else if (this.inputNr != 0) {
            if (this.primaryScanDetailMap.containsKey(this.inputNr)) {
                this.scanGroup = 1;
                this.primaryTrigger = false;
                ScanInputDetail o = (ScanInputDetail)this.primaryScanDetailMap.get(this.inputNr);
                if (o == null) {
                    st = 14;
                    return st;
                }
                this.sidCurrent = o;
                int pos = o.getInputSequenceNumberInGroup();
                if (pos >= this.primarySize) {
                    st = 13;
                    this.clearPrimaryInputValues();
                    return st;
                }
                o.setInputValue(value, st);
                st = 1;
                this.primaryTrigger = true;
            } else if (this.secondaryScanDetailMap.containsKey(this.inputNr)) {
                this.scanGroup = 2;
                this.secondaryTrigger = false;
                ScanInputDetail o = (ScanInputDetail)this.secondaryScanDetailMap.get(this.inputNr);
                if (o == null) {
                    st = 24;
                    this.clearSecondaryInputValues();
                    return st;
                }
                this.sidCurrent = o;
                int pos = o.getInputSequenceNumberInGroup();
                if (pos >= this.secondarySize) {
                    st = 23;
                    this.clearSecondaryInputValues();
                    return st;
                }
                st = 2;
                o.setInputValue(value, st);
                this.secondaryTrigger = true;
            }
        } else {
            st = 50;
        }
        return st;
    }

    public int evaluateInputValue(String value) {
        int status = 51;
        int len = value.length();
        if (len < 1) {
            return status;
        }
        this.inputNr = 0;
        this.inputDialog = "";
        this.scanGroup = 0;
        this.sidCurrent = null;
        if (!this.inputRecogMap.isEmpty()) {
            boolean fnd = false;
            Set keys = this.inputRecogMap.keySet();
            Iterator ir = keys.iterator();
            String key = "";
            while (!fnd && ir.hasNext()) {
                key = (String)ir.next();
                if ((key = key.trim()) == null || key.isEmpty() || !value.contains(key)) continue;
                fnd = true;
            }
            if (fnd) {
                return this.evaluateInputValueDetail(true, this.inputRecogMap, status, 0, key, value);
            }
        }
        return this.evaluateInputValueDetail(false, this.inputLengthMap, status, len, "", value);
    }

    private void doPrimaryScanList() {
        for (int i = 0; i < this.inputCnt; ++i) {
            int k = i + 1;
            this.primaryScanDetailMap.put(k, new ScanInputDetail(1, k, i));
        }
    }

    private void doSecondaryScanList() {
        for (int i = 0; i < this.inputCnt; ++i) {
            int k = i + 1;
            if (this.primaryScanDetailMap.containsKey(k)) continue;
            this.secondaryScanDetailMap.put(k, new ScanInputDetail(1, k, i));
        }
    }

    private boolean parseScannerIDs(String parameterData) {
        int len;
        boolean b = false;
        String idList = this.xmlAttr.parseTagAttribute("IDList", parameterData);
        if (idList.isEmpty()) {
            return false;
        }
        b = true;
        String[] sp = idList.split(",");
        if (sp.length < (len = sp.length)) {
            String m = this.deviceName + ": ID List names does not match the ID List, reverting to empty ID list...";
            this.msg.sysMsg("bold+red", m);
            this.idScanMap.clear();
            return false;
        }
        if (len > 0) {
            boolean bl = true;
            for (int i = 0; bl && i < len; ++i) {
                try {
                    String id = sp[i].trim();
                    this.idScanMap.put(id, id);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    bl = false;
                    String m = this.deviceName + ": NFE: Scanner ID list failure, reverting to empty ID list...";
                    this.msg.sysMsg("bold+red", m);
                    this.idScanMap.clear();
                }
            }
        }
        return b;
    }

    private boolean setPrimaryScanGroup(String parameterData) {
        boolean b = false;
        this.primaryScanGrp = this.xmlAttr.parseTagAttribute("PrimaryScanGroup", parameterData);
        this.primaryNoSeq = "true".equalsIgnoreCase(this.xmlAttr.parseTagAttribute("PrimaryNoSequence", parameterData));
        if (this.primaryScanGrp.isEmpty()) {
            this.doPrimaryScanList();
        } else {
            String[] sp = this.primaryScanGrp.split(",");
            int len = sp.length;
            if (len > 0) {
                int cnt = 0;
                boolean bl = true;
                for (int i = 0; bl && i < len; ++i) {
                    String m;
                    try {
                        int n = Integer.parseInt(sp[i].trim());
                        if (n > 0) {
                            ScanInputDetail sid = new ScanInputDetail(1, n, cnt++);
                            this.primaryScanMap.put(i, sid);
                            this.primaryScanDetailMap.put(n, sid);
                            continue;
                        }
                        bl = false;
                        m = this.deviceName + ": Negative: Primary scanlist failure, reverting to a basic scanlist...";
                        this.msg.sysMsg("bold+red", m);
                        this.doPrimaryScanList();
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        bl = false;
                        m = this.deviceName + ": NFE: Primary scanlist failure, reverting to a basic scanlist...";
                        this.msg.sysMsg("bold+red", m);
                        this.doPrimaryScanList();
                    }
                }
            } else {
                this.doPrimaryScanList();
            }
        }
        if (!this.primaryScanDetailMap.isEmpty()) {
            b = true;
            this.primarySize = this.primaryScanDetailMap.size();
            this.primaryInputValues = new String[this.primarySize];
            this.clearPrimaryInputValues();
        }
        return b;
    }

    private boolean setSecondaryScanGroup(String parameterData) {
        boolean b = false;
        this.secondaryScanGrp = this.xmlAttr.parseTagAttribute("SecondaryScanGroup", parameterData);
        this.secondaryNoSeq = "true".equalsIgnoreCase(this.xmlAttr.parseTagAttribute("SecondaryNoSequence", parameterData));
        if (this.secondaryScanGrp.isEmpty()) {
            this.doSecondaryScanList();
        } else {
            String[] sp = this.secondaryScanGrp.split(",");
            int len = sp.length;
            if (len > 0) {
                int cnt = 0;
                boolean bl = true;
                for (int i = 0; bl && i < len; ++i) {
                    String m;
                    try {
                        int n = Integer.parseInt(sp[i].trim());
                        if (n > 0) {
                            if (!this.primaryScanDetailMap.containsKey(n)) {
                                ScanInputDetail sid = new ScanInputDetail(2, n, cnt++);
                                this.secondaryScanMap.put(i, sid);
                                this.secondaryScanDetailMap.put(n, sid);
                                continue;
                            }
                            m = this.deviceName + ": Ignoring Secondary scanlist item ='" + n + "' as it is in primary scanlist...";
                            this.msg.sysMsg("bold+red", m);
                            continue;
                        }
                        bl = false;
                        m = this.deviceName + ": Negative: Secondary scanlist failure, reverting to a basic scanlist...";
                        this.msg.sysMsg("bold+red", m);
                        this.doSecondaryScanList();
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        bl = false;
                        m = this.deviceName + ": NFE: Secondary scanlist failure, reverting to a basic scanlist...";
                        this.msg.sysMsg("bold+red", m);
                        this.doSecondaryScanList();
                    }
                }
            } else {
                this.doSecondaryScanList();
            }
        }
        if (!this.secondaryScanDetailMap.isEmpty()) {
            b = true;
            this.secondarySize = this.secondaryScanDetailMap.size();
            this.secondaryInputValues = new String[this.secondarySize];
            this.clearSecondaryInputValues();
        }
        return b;
    }

    public boolean isPrimaryTrigger() {
        return this.primaryTrigger;
    }

    public boolean isSecondaryTrigger() {
        return this.secondaryTrigger;
    }

    public boolean isPrimarySequence() {
        return this.primarySequence;
    }

    public boolean isSecondarySequence() {
        return this.secondarySequence;
    }

    public boolean isRecognitionUsage() {
        return this.inputRecogUse;
    }
}

