/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteStream {
    private static byte[] toByteArray(int in_int) {
        byte[] a = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byte b;
            int b_int = in_int >> i * 8 & 0xFF;
            a[i] = b = (byte)b_int;
        }
        return a;
    }

    private static int toInt(byte[] byte_array_4) {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            int b = byte_array_4[i];
            if (i < 3 && b < 0) {
                b = 256 + b;
            }
            ret += b << i * 8;
        }
        return ret;
    }

    public static int toInt(InputStream in) {
        try {
            byte[] byte_array_4 = new byte[]{(byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read()};
            return ByteStream.toInt(byte_array_4);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -1;
        }
    }

    public static String toString(InputStream ins) {
        int len = ByteStream.toInt(ins);
        if (len > -1) {
            return ByteStream.toString(ins, len);
        }
        return "0";
    }

    private static String toString(InputStream ins, int len) {
        String ret = new String();
        try {
            for (int i = 0; i < len; ++i) {
                ret = ret + (char)ins.read();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ret;
    }

    public static void toStream(OutputStream os, int i) {
        try {
            byte[] byte_array_4 = ByteStream.toByteArray(i);
            os.write(byte_array_4);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void toStream(OutputStream os, String s) {
        try {
            int len_s = s.length();
            ByteStream.toStream(os, len_s);
            for (int i = 0; i < len_s; ++i) {
                os.write((byte)s.charAt(i));
            }
            os.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static byte[] toByteArray(InputStream ins, int an_int) {
        byte[] ret = new byte[an_int];
        int offset = 0;
        int numRead = 0;
        int outstanding = an_int;
        try {
            while (offset < an_int && (numRead = ins.read(ret, offset, outstanding)) > 0) {
                outstanding = an_int - (offset += numRead);
            }
            if (offset < ret.length) {
                throw new Exception();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("Could not completely read from stream, numRead=" + numRead + ", ret.length=" + ret.length);
            ex.printStackTrace();
        }
        return ret;
    }

    private static boolean toFile(InputStream ins, FileOutputStream fos, int len, int buf_size) {
        byte[] buffer = new byte[buf_size];
        int len_read = 0;
        int total_len_read = 0;
        try {
            while (total_len_read + buf_size <= len) {
                len_read = ins.read(buffer);
                total_len_read += len_read;
                fos.write(buffer, 0, len_read);
            }
            if (total_len_read < len) {
                ByteStream.toFile(ins, fos, len - total_len_read, buf_size / 2);
            }
            fos.flush();
            fos.close();
            return true;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    private static boolean toFile(InputStream ins, File file, int len, int bufferSize) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            return ByteStream.toFile(ins, fos, len, bufferSize);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return false;
        }
    }

    public static boolean toFile(InputStream ins, File file, int bufferSize) {
        int len = ByteStream.toInt(ins);
        if (len > -1) {
            return ByteStream.toFile(ins, file, len, bufferSize);
        }
        return false;
    }

    public static boolean toStream(OutputStream os, int bufferSize, File file) {
        try {
            ByteStream.toStream(os, (int)file.length());
            byte[] b = new byte[bufferSize];
            FileInputStream is = new FileInputStream(file);
            int numRead = 0;
            while ((numRead = ((InputStream)is).read(b)) > 0) {
                os.write(b, 0, numRead);
            }
            os.flush();
            ((InputStream)is).close();
            return true;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }
}

