/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.sys;

import com.nosoft.mobile.mes.data.DataMobile;
import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.gui.FinalGuiData;
import com.nosoft.mobile.mes.gui.GuiJmtStartup;
import com.nosoft.mobile.mes.messages.Message;
import com.nosoft.mobile.mes.protocol.SysProtocol;
import com.nosoft.mobile.mes.security.Security;
import com.nosoft.mobile.mes.services.tcp.TcpClient;
import com.nosoft.mobile.mes.util.ScanInput;
import com.nosoft.mobile.sys.Sys;
import java.io.File;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class pdt
extends Sys
implements FinalData,
FinalGuiData,
SysProtocol,
Observer {
    private static int wsType = 1;
    private static String workstationType = "wsb";
    boolean b1 = false;
    boolean b2 = false;
    boolean b3 = false;
    boolean cn = false;
    boolean rf = false;
    boolean un = false;
    boolean ch = false;

    public pdt() {
        fsys = this;
    }

    @Override
    public boolean setUp(String[] args, String osName) {
        String typ;
        pdt.osName = osName;
        if (osName.contains("sunos") || osName.contains("solaris") || osName.contains("linux")) {
            this.setLinux(true);
        }
        if (singleton) {
            return false;
        }
        singleton = true;
        pdt.args = args;
        rootFolder = args[0];
        this.setMesServerCmdLineIp(args[1]);
        cfgFileName = rootFolder + "/config/config.xml";
        typeFileName = rootFolder + "/config/Packhouse.xml";
        this.setLmmType("packhouse");
        msg = new Message(true, true);
        lmmData = new DataMobile(fsys, msg, true, true, rootFolder);
        gui = new GuiJmtStartup(true, true, msg, "Generic Mobile", this.getLmmType(), this.getCfgFileName());
        if (!lmmData.doSetup()) {
            return false;
        }
        this.rfHdr = new HashMap();
        this.rfHdr.put("2002", "<ContainerFillRF PID=\"211\" ");
        this.rfHdr.put("2003", "<ContainerMoveRF PID=\"201\" ");
        this.rfHdr.put("2004", "<ProductLabelRF PID=\"224\" ");
        this.rfHdr.put("2006", "<ProductLabelRF PID=\"224\" ");
        this.rfHdr.put("2009", "<PalletizeRF PID=\"231\" ");
        this.rfHdr.put("2020", "<PDTRF PID=\"317\" ");
        this.rfHdr.put("2022", "<QualityControlRF PID=\"236\" ");
        this.rfHdr.put("2023", "<RequestServerRF PID=\"234\" ");
        gui.setSysInterface(this);
        runStatus = this.setRunParameters(this.getCfgFileName());
        msg.sysMsg("bold+black", "NoSoftTerminal Mes Server=" + lmmData.getMesServerIp() + ":" + lmmData.getMesServerPort());
        msg.sysMsg("bold+black", "NoSoftTerminal Web Server=" + lmmData.getWebServerIp() + ":" + lmmData.getWebServerPort());
        msg.sysMsg("bold+black", "NoSoftTerminal Rev: " + this.getSoftwareVersion() + " running...");
        msg.sysMsg("bold+black", "Started...");
        switch (typ = lmmData.getTransactionType()) {
            case "logistics": {
                typeFileName = rootFolder + "/config/Logistics.xml";
                this.setLmmType("logistics");
                break;
            }
            case "packhouse": {
                typeFileName = rootFolder + "/config/Packhouse.xml";
                this.setLmmType("packhouse");
            }
        }
        return runStatus;
    }

    @Override
    public Security getSecurityHandle() {
        return sec;
    }

    @Override
    public void reportLogonStatus(boolean status, int opt, String username) {
        loggedIn = status;
        loginStatus = opt;
        gui.setLoginStatus(loggedIn, username);
    }

    @Override
    public synchronized void mmEvent(TcpClient tcp, boolean eventEnd) {
        if (eventEnd && this.booting) {
            this.booting = false;
        }
    }

    private synchronized void doInputTransaction(final String data) {
        new Thread(){
            {
                this.start();
            }

            @Override
            public void run() {
                switch (wsType) {
                    case 1: {
                        if (!Sys.gui.setInputData(data)) break;
                        String[] upData = Sys.gui.getInputData();
                        try {
                            if (upData.length <= 0) break;
                            pdt.this.triggerEvent(Sys.gui.getTransactionHdr(), Sys.gui.getTransactionType(), 3, Sys.gui.getProcessingMode(), data);
                            break;
                        }
                        catch (NullPointerException npe) {
                            Sys.msg.sysMsg("bold+red", "Data input not complete...");
                        }
                    }
                }
            }
        };
    }

    @Override
    public synchronized void triggerEvent(String transactionHdr, String transactionType, int mode, int midwareMode, String data) {
        String txStr = "";
        String txHdr = transactionHdr;
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                txStr = "<MenuSelect PID=\"800\" Op=\"" + sec.getLoggedOnUser() + "\" Su=\"\"" + "\" TransactionType=\"" + transactionType + "\" Mode=\"" + midwareMode + "\" />";
                return;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.b1 = true;
                break;
            }
            case 5: {
                this.b2 = true;
                break;
            }
            case 6: {
                this.b3 = true;
                break;
            }
            case 7: {
                this.cn = true;
                break;
            }
            case 8: {
                this.rf = true;
                break;
            }
            case 9: {
                this.un = true;
                break;
            }
            case 10: {
                this.ch = true;
            }
        }
        txStr = this.buildData(txHdr, transactionType, midwareMode, data);
        if (txStr.length() > 0) {
            gui.clearLcdList();
            this.tcp = new TcpClient(gui.getServerIP(), gui.getApplicationPort());
            this.tcp.transmitLanString(txStr);
            gui.setInputFldClear(1);
            gui.setInputFldClear(2);
            gui.setInputFldClear(3);
            gui.setInputFldFocus(1);
        }
    }

    private String buildData(String txHdr, String transactionType, int midwareMode, String data) {
        String txStr = "";
        try {
            String key = "" + gui.getApplicationPort();
            if (!this.rfHdr.containsKey(key)) {
                return "";
            }
            txHdr = (String)this.rfHdr.get(key) + " ";
            txStr = txHdr + "Op=\"" + sec.getLoggedOnUser() + "\" Su=\"\"" + "\" TransactionType=\"" + transactionType + "\" Mode=\"" + midwareMode + "\" ServerName=\"" + gui.getServerName() + "\" Printer=\"" + gui.getPrinterName() + "\" PrinterIP=\"" + gui.getPrinterIP() + "\" PrinterPort=\"" + gui.getPrinterPort() + "\" PrintTemplateName=\"" + gui.getPrinterTemplate() + "\" PrintFormatFileName=\"" + gui.getPrinterFormat() + "\" GLNUnit=\"" + gui.getGLNUnit() + "\" Gate=\"" + gui.getGate() + "\" EntryLine=\"" + gui.getEntryLine() + "\" EntryLine=\"" + gui.getPreSortLine() + "\" ProductionLine=\"" + gui.getProductionLine() + "\" Sizer=\"" + gui.getSizer() + "\" Palletizer=\"" + gui.getPalletizer() + "\" RFBay=\"" + gui.getRFBay() + "\" Bay=\"" + gui.getBay() + "\" Button=\"" + gui.getButton() + "\" B1=\"" + this.b1 + "\" B1Enable=\"" + gui.getButtonStatus(1) + "\" B2=\"" + this.b2 + "\" B2Enable=\"" + gui.getButtonStatus(2) + "\" B3=\"" + this.b3 + "\" B3Enable=\"" + gui.getButtonStatus(3) + "\" Cancel=\"" + this.cn + "\" Refresh=\"" + this.rf + "\" Undo=\"" + this.un + "\" C1=\"" + gui.getChoiceValue(1) + "\" C1Enable=\"" + gui.getChoiceStatus(1) + "\" Input1=\"" + gui.getInputData(1) + "\" Input2=\"" + gui.getInputData(2) + "\" Mass=\"" + gui.getInputData(3) + "\" Args=\"" + gui.getInputData(1) + "," + gui.getInputData(2) + "\" />";
        }
        catch (NullPointerException npe) {
            txStr = "";
            msg.sysMsg("bold+red", "TX data buildup error...");
        }
        this.b1 = false;
        this.b2 = false;
        this.b3 = false;
        this.cn = false;
        this.rf = false;
        this.un = false;
        this.ch = false;
        return txStr;
    }

    @Override
    public synchronized boolean runSystem() {
        this.start();
        return true;
    }

    @Override
    public void interrupt() {
        runStatus = false;
        super.interrupt();
    }

    @Override
    public void run() {
        this.setAllowMsg(true);
        msg.sysMsg("bold+black", "NoSoftTerminal started...");
    }

    public boolean setRunParameters(String filename) {
        String packhouseFile = rootFolder + "/config/Packhouse.xml";
        String logisticsFile = rootFolder + "/config/Logistics.xml";
        File bootFile = new File(packhouseFile);
        System.out.println("1 " + packhouseFile);
        System.out.println("2 " + logisticsFile);
        if (!bootFile.exists()) {
            fetchPackhouseXml = true;
            this.getConfigurationRecords(2);
        }
        if (!(bootFile = new File(logisticsFile)).exists()) {
            fetchLogisticsXml = true;
            if (!fetchPackhouseXml) {
                this.getConfigurationRecords(1);
            }
        }
        return true;
    }

    @Override
    public int getWSType() {
        return wsType;
    }

    @Override
    public void setTransactionType(String tHdr, String tType, String tTypeStr) {
        this.tHdr = tHdr;
        this.tType = tType;
        this.tTypeStr = tTypeStr;
    }

    @Override
    public void shutDown(boolean allowMsg) {
        File lck;
        if (sec != null && sec.checkLogonStatus()) {
            sec.processLoginLogout(gui, false);
        }
        if (lmmData != null) {
            lmmData.shutDown(allowMsg);
        }
        Thread.currentThread().interrupt();
        if (gui != null) {
            gui.shutDown(allowMsg);
        }
        if ((lck = new File(this.lckFile)).exists()) {
            System.out.println("Shutdown: " + this.lckFile);
            lck.delete();
        } else {
            System.out.println("Shutdown...");
        }
        System.exit(0);
    }

    @Override
    public void update(Observable obs, Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof ScanInput) {
            this.doInputTransaction(((ScanInput)o).getValue());
        }
    }
}

