/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.services.tcp;

import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.mes.protocol.SysProtocol;
import com.nosoft.mobile.mes.services.ServiceInterface;
import com.nosoft.mobile.mes.util.ByteStream;
import com.nosoft.mobile.sys.Sys;
import com.nosoft.mobile.sys.SysInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;

public class TcpFileTransferBinary
extends Thread
implements FinalData,
SysProtocol,
ServiceInterface {
    private ServiceInterface tcp = null;
    private static SysInterface lmm = null;
    private static MessageInterface msg = null;
    private static GuiInterface gui = null;
    private String name;
    private boolean allowMsg = false;
    private boolean enable = false;
    private boolean runStatus = false;
    private boolean threadRun = true;
    private int LANRING = 100;
    private int inHdr = 0;
    private int inTail = 0;
    private int[] inputNum = new int[this.LANRING];
    private String[] inputStr = new String[this.LANRING];
    private long timeStopTr = 0L;
    private boolean tranActive = false;
    private String timeStr = "";
    private String dateStr = "";
    private long timeStartMs = 0L;
    private long timeStopMs = 0L;
    private String destName = "";
    private String destAddr = "";
    private Socket socket = null;
    private int serverPort = 1997;
    private int toSetting = 6500;
    private int toTCPSetting = 10000;
    private int toOffsetSetting = 2500;
    private int toTrigger = 4000;
    private long devicePort = 0L;
    private boolean edi = false;
    private boolean ediLog = false;
    private BufferedReader itStream = null;
    private PrintWriter otStream = null;
    private InputStream ibStream = null;
    private OutputStream obStream = null;
    private int bootCnt = 0;
    private String bootRecord = "<Edi Name=\"PCS\" TransferType=\"MES\" CycleTime=\"20\" CycleUnits=\"sec\" HostIP=\"127.0.0.1\" Username=\"\" Password=\"\" Timeout=\"3000\" FileVersioning=\"false\" Logging=\"true\" TransferBufferSize=\"1024\" />";
    private String[] bootRecords = null;
    private long fileNumber = 0L;
    private String folderNameLocal = "";
    private String folderPathLocal = "";
    private String folderFullPath = "";
    private String folderErLocal = "";
    private String folderRxLocal = "";
    private String folderTxLocal = "";
    private String folderFlLocal = "";
    private String folderLogFiles = "";
    private String folderNameRemote = "";
    private String folderPathRemote = "";
    protected String folderErRemote = "";
    protected String folderRxRemote = "";
    protected String folderTxRemote = "";
    protected String folderFlRemote = "";
    private int transferMode = 0;
    private String transferName = "";
    private boolean transferActive = false;
    private int transferType = 1;
    XmlAttributeFactory xmlAttr = new XmlAttributeFactory();
    private Receive rx = null;

    public TcpFileTransferBinary() {
        this.tcp = this;
        gui = Gui.gui;
        msg = Sys.msg;
        lmm = Sys.fsys;
    }

    public TcpFileTransferBinary(String host, int port, int toSetting, int toOffsetSetting, boolean ediLog) {
        this();
        this.destAddr = host;
        if (port == 0) {
            this.devicePort = 2091L;
            this.serverPort = 2091;
        } else {
            this.devicePort = port;
            this.serverPort = port;
        }
        this.ediLog = ediLog;
        this.transferMode = 0;
        this.transferType = 1;
        this.tcpConnect(toSetting, toOffsetSetting);
    }

    public TcpFileTransferBinary(Socket socket, int toSetting, int toOffsetSetting) {
        this();
        this.socket = socket;
        this.destAddr = socket.getInetAddress().getHostAddress();
        this.devicePort = socket.getLocalPort();
        this.transferMode = 0;
        this.transferType = 1;
        String m = "Mobile: File transfer failed...";
        try {
            this.itStream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.otStream = new PrintWriter(this.socket.getOutputStream(), true);
            this.ibStream = this.socket.getInputStream();
            this.obStream = this.socket.getOutputStream();
        }
        catch (SocketException sex) {
            msg.sysMsg("bold+red", m);
            return;
        }
        catch (IOException ioe) {
            msg.sysMsg("bold+red", m);
            this.shutDown(true);
            return;
        }
        catch (Exception e) {
            msg.sysMsg("bold+red", m);
            this.shutDown(true);
            return;
        }
        new Thread(){
            {
                this.start();
            }

            @Override
            public void run() {
                TcpFileTransferBinary.this.rx = new Receive();
                TcpFileTransferBinary.this.rx.start();
            }
        };
        this.enable = true;
    }

    private void tcpConnect(int toSetting, int toOffsetSetting) {
        this.toSetting = toSetting;
        this.toTCPSetting = toSetting + 3000;
        if (toSetting > toOffsetSetting) {
            this.toOffsetSetting = toOffsetSetting;
            this.toTrigger = toSetting - toOffsetSetting;
        } else {
            this.toSetting = 12000;
            this.toOffsetSetting = 3000;
            this.toTrigger = 3500;
        }
        try {
            this.socket = new Socket(this.destAddr, (int)this.devicePort);
            if (this.socket == null) {
                return;
            }
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.toTCPSetting);
            this.itStream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.otStream = new PrintWriter(this.socket.getOutputStream(), true);
            this.ibStream = this.socket.getInputStream();
            this.obStream = this.socket.getOutputStream();
            String m = "NoSoftTerminal Mobile connected to " + this.destAddr + " on port " + this.devicePort + "...";
            msg.sysMsg("bold+blue", m);
            this.enable = true;
        }
        catch (NullPointerException npe) {
        }
        catch (IOException ioe) {
            msg.sysMsg("bold+red", "NoSoftTerminal Mobile file transfer connection to " + this.destAddr + " on port " + this.serverPort + " failed to start...");
            this.shutDown(true);
        }
    }

    public boolean setup(String bootRecord) {
        this.transferName = this.xmlAttr.parseTagAttribute("Name", bootRecord);
        this.folderLogFiles = lmm.getRootFolder() + "/logs";
        this.folderPathLocal = lmm.getRootFolder() + "/data";
        this.folderRxLocal = this.folderPathLocal + "/receive";
        this.folderTxLocal = this.folderPathLocal + "/transmit";
        return this.enable;
    }

    @Override
    public synchronized void interrupt() {
        super.interrupt();
    }

    @Override
    public void run() {
    }

    @Override
    public synchronized boolean transmitLanString(String str) {
        if (this.otStream != null && str.length() > 0) {
            this.otStream.print(str + "\r\n");
            this.otStream.flush();
            return true;
        }
        return false;
    }

    private boolean processResponse(String srcFile) {
        String responseLine = "";
        if (this.itStream == null) {
            return false;
        }
        try {
            responseLine = this.itStream.readLine();
            if (responseLine == null) {
                this.timeStopMs = System.currentTimeMillis();
                msg.sysMsg("bold+red", "NPE: TransmitfileProcess Responseline=(" + responseLine + ") ...");
                return false;
            }
            int nr = 0;
            try {
                nr = Integer.parseInt(this.xmlAttr.parseTagAttribute("PID", responseLine));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            switch (nr) {
                case 20002: 
                case 20004: {
                    msg.sysMsg("red", "Transfer terminated: Remote system still busy or the file empty (File=" + srcFile + ")...");
                    return false;
                }
                case 20001: {
                    return true;
                }
                case 602: {
                    msg.sysMsg("bold+red", "Timeout trying to transmit the file '" + srcFile + "'...");
                    return false;
                }
            }
            msg.sysMsg("bold+red", "Illegal start of transmission response (" + responseLine + ") for file " + srcFile + "...");
            return false;
        }
        catch (NullPointerException npe) {
            this.timeStopMs = System.currentTimeMillis();
            msg.sysMsg("bold+red", "NPE: TransmitfileProcess Responseline=(" + responseLine + ") ...");
        }
        catch (IOException ex) {
            msg.sysMsg("bold+red", "Transmission of the file " + srcFile + " failed while waiting for an initial response...");
        }
        return false;
    }

    public synchronized boolean sendFile(String homeFolder, String folder, String fileName, boolean move, boolean append) {
        boolean b = false;
        String fldr = folder;
        fldr = fldr.length() == 0 ? this.folderTxLocal : (homeFolder.length() == 0 ? lmm.getRootFolder() + "/" + fldr : homeFolder + "/" + fldr);
        String fn = fldr + "/" + fileName;
        File fd = new File(fn);
        if (fd.exists()) {
            this.transferMode = 1;
            this.transferActive = true;
            long size = fd.length();
            String txStr = "<ReceiveFile PID=\"52\"  TransferName=\"" + this.transferName + "\" Folder=\"" + folder + "\" File=\"" + fileName + "\" Filesize=\"" + size + "\" TransferType=\"Binary\" Move=\"" + move + "\" Append=\"" + append + "\" />";
            this.transmitLanString(txStr);
            if (this.transmitBinaryFile(fldr, fileName, move)) {
                b = true;
            }
        } else {
            this.transmitLanString("<Eot PID=\"20004\" />");
        }
        String m = "NoSoftTerminal Mobile connection closing on socket " + this.socket + " to " + this.destAddr + " port " + this.devicePort + "...";
        msg.sysMsg("bold+blue", m);
        this.shutDown(false);
        this.transferMode = 0;
        this.transferActive = false;
        return b;
    }

    public synchronized boolean sendFile(String homeFolder, String folder, String fileName, String fileNameAlias, boolean move, boolean append) {
        boolean b = false;
        String fldr = folder;
        fldr = fldr.length() == 0 ? this.folderTxLocal : (homeFolder.length() == 0 ? lmm.getRootFolder() + "/" + fldr : homeFolder + "/" + fldr);
        String fn = fldr + "/" + fileName;
        File fd = new File(fn);
        if (fd.exists()) {
            this.transferMode = 1;
            this.transferActive = true;
            long size = fd.length();
            String txStr = "<ReceiveFile PID=\"52\"  TransferName=\"" + this.transferName + "\" Folder=\"" + folder + "\" File=\"" + fileNameAlias + "\" Filesize=\"" + size + "\" TransferType=\"Binary\" Move=\"" + move + "\" Append=\"" + append + "\" />";
            this.transmitLanString(txStr);
            if (this.transmitBinaryFile(fldr, fileName, move)) {
                b = true;
            }
        } else {
            this.transmitLanString("<Eot PID=\"20004\" />");
        }
        String m = "NoSoftTerminal Mobile connection closing on socket " + this.socket + " to " + this.destAddr + " port " + this.devicePort + "...";
        msg.sysMsg("bold+blue", m);
        this.shutDown(false);
        this.transferMode = 0;
        this.transferActive = false;
        return b;
    }

    public synchronized boolean transmitBinaryFile(String folder, String srcFile, boolean move) {
        boolean b = false;
        String m = "";
        String fn = folder + "/" + srcFile;
        if (!this.processResponse(srcFile)) {
            return b;
        }
        File rf = new File(fn + ".inuse");
        if (rf.exists() && !rf.delete()) {
            m = "The temporary transmit File='" + srcFile + ".inuse' could not be deleted...";
            msg.sysMsg("bold+red", m);
            this.transmitLanString("<Eot PID=\"20004\" />");
            return b;
        }
        File orig = new File(fn);
        try {
            if (!orig.renameTo(rf)) {
                m = "The transmit File='" + srcFile + "' could not be renamed...";
                msg.sysMsg("bold+red", m);
                this.transmitLanString("<Eot PID=\"20004\" />");
                return b;
            }
        }
        catch (SecurityException se) {
            m = "Security Exception: The transmit File='" + srcFile + "' could not be renamed...";
            msg.sysMsg("bold+red", m);
            this.transmitLanString("<Eot PID=\"20004\" />");
            return b;
        }
        msg.sysMsg("bold+blue", "Started transmission of the File='" + srcFile + "'...");
        if (ByteStream.toStream(this.obStream, 1024, rf)) {
            msg.sysMsg("bold+blue", "Transmit completed for File='" + srcFile + "'...");
            if (move) {
                if (!rf.delete()) {
                    rf.renameTo(orig);
                } else {
                    b = true;
                }
            } else if (rf.renameTo(orig)) {
                b = true;
            }
        } else {
            m = "Started transmission of File='" + srcFile + "' but a network IO error has occurred...";
            msg.sysMsg("bold+red", m);
            this.transmitLanString("<Eot PID=\"20004\" />");
            rf.renameTo(orig);
        }
        return b;
    }

    @Override
    public void setAllowMsg(boolean m) {
        this.allowMsg = m;
    }

    @Override
    public void setEnable(boolean e) {
        this.enable = e;
    }

    @Override
    public boolean getEnable() {
        return this.enable;
    }

    @Override
    public void setRunstatus(boolean r) {
        this.runStatus = r;
    }

    @Override
    public boolean getRunStatus() {
        return this.runStatus;
    }

    public int getTOSetting() {
        return this.toSetting;
    }

    public int getTOTCPSetting() {
        return this.toTCPSetting;
    }

    @Override
    public boolean transactionBan() {
        return false;
    }

    @Override
    public boolean transmitLanString(String multiTxStartMsg, String multiTxEndMsg, String[] str) {
        return false;
    }

    public boolean ftpConnect() {
        return false;
    }

    public boolean ftpDisconnect() {
        return false;
    }

    public boolean changeRemoteDirectory(String folderFlRemote) {
        return false;
    }

    public boolean fileCopyMove(String src, String dest) {
        return false;
    }

    public boolean createDirectory(String folderTxRemote, String string) {
        return false;
    }

    public boolean getFile(String folderRxLocal, String name) {
        return false;
    }

    public boolean deleteDirectory(String folderTxRemote, String string) {
        return false;
    }

    public boolean sendFile(String folderTxLocal, String string, String folderTransmitted) {
        return false;
    }

    @Override
    public synchronized boolean shutDown(final boolean allowMsg) {
        this.threadRun = false;
        if (this.rx != null) {
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpFileTransferBinary.this.rx.shutDown(allowMsg);
                }
            };
        }
        try {
            if (this.itStream != null) {
                this.itStream.close();
            }
            if (this.otStream != null) {
                this.otStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (NullPointerException npe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
        this.setEnable(false);
        this.setAllowMsg(allowMsg);
        return true;
    }

    class Receive
    extends Thread {
        private boolean threadRun = true;

        Receive() {
        }

        @Override
        public void run() {
            String m = "NoSoftTerminal Mobile connection to " + TcpFileTransferBinary.this.destAddr + " on port " + TcpFileTransferBinary.this.devicePort + "...";
            msg.sysMsg("bold+blue", m);
            try {
                int state = -1;
                String inputLine = "";
                while (this.threadRun && (inputLine = TcpFileTransferBinary.this.itStream.readLine()) != null) {
                    int len = inputLine.length();
                    if (len <= 0) continue;
                    int nr = 0;
                    try {
                        nr = Integer.parseInt(TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("PID", inputLine));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    switch (nr) {
                        case 20001: {
                            state = 6;
                            break;
                        }
                        case 20002: {
                            state = 23;
                            break;
                        }
                        case 20004: {
                            state = 4;
                            break;
                        }
                        case 20005: {
                            state = 21;
                            break;
                        }
                        case 20003: {
                            state = 3;
                            break;
                        }
                        case 20006: {
                            state = 1;
                            break;
                        }
                        case 20007: {
                            state = 2;
                            break;
                        }
                        default: {
                            state = this.parseProtocolClient(inputLine);
                        }
                    }
                    switch (state) {
                        case 0: {
                            break;
                        }
                        case 4: 
                        case 640: {
                            TcpFileTransferBinary.this.transferMode = 0;
                            this.threadRun = false;
                            break;
                        }
                        case 21: {
                            this.threadRun = false;
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 23: {
                            switch (TcpFileTransferBinary.this.transferMode) {
                                case 1: {
                                    TcpFileTransferBinary.this.transmitLanString("<Eof PID=\"20002\" />");
                                    break;
                                }
                                case 2: {
                                    TcpFileTransferBinary.this.transmitLanString("<Eot PID=\"20004\" />");
                                }
                            }
                            TcpFileTransferBinary.this.transferMode = 0;
                            this.threadRun = false;
                            break;
                        }
                        case -1: {
                            break;
                        }
                    }
                }
            }
            catch (InterruptedIOException iioe) {
                m = "NoSoftTerminal Mobile IIO Exception socket " + TcpFileTransferBinary.this.socket + " to " + TcpFileTransferBinary.this.destAddr + " port " + TcpFileTransferBinary.this.devicePort + "...";
                msg.sysMsg("bold+red", m);
            }
            catch (IOException ioe) {
                m = "NoSoftTerminal Mobile IO Exception socket " + TcpFileTransferBinary.this.socket + " to " + TcpFileTransferBinary.this.destAddr + " port " + TcpFileTransferBinary.this.devicePort + "...";
                msg.sysMsg("bold+blue", m);
            }
            m = "NoSoftTerminal Mobile connection now closing on socket " + TcpFileTransferBinary.this.socket + " to " + TcpFileTransferBinary.this.destAddr + " port " + TcpFileTransferBinary.this.devicePort + "...";
            msg.sysMsg("bold+blue", m);
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpFileTransferBinary.this.tcp.shutDown(true);
                }
            };
        }

        public boolean receiveBinaryFile(String fileName, String rxFolder, String rxFile, long fileSize, String transferType, boolean move, boolean append) {
            boolean b = false;
            String m = "";
            if (TcpFileTransferBinary.this.itStream != null && TcpFileTransferBinary.this.otStream != null) {
                File fldr = new File(rxFolder);
                if (!fldr.exists()) {
                    m = "Reception Folder='" + rxFolder + "' created...";
                    msg.sysMsg("black+red", m);
                }
                msg.sysMsg("bold+black", "Receiving file: " + fileName + " Size=" + fileSize + " bytes" + " TransferType=" + transferType + " Move=" + move + "...");
                TcpFileTransferBinary.this.transmitLanString("<Ack PID=\"20001\" />");
                int err = 0;
                File file = new File(rxFile + ".inuse");
                if (ByteStream.toFile(TcpFileTransferBinary.this.ibStream, file, 1024)) {
                    b = true;
                } else {
                    ++err;
                    m = "Reception error for File='" + rxFile + "' has occurred...";
                    msg.sysMsg("bold+red", m);
                    TcpFileTransferBinary.this.transmitLanString("<Eot PID=\"20004\" />");
                    file.delete();
                }
            }
            return b;
        }

        private void receiveCleanUp(String fileName, String rxFolder, String rxFile, long fileSize, String transferType, boolean move, boolean append) {
            String m = "";
            File tf0 = new File(rxFile);
            File tft = new File(rxFile + ".inuse");
            if (!tft.exists()) {
                m = "EDI " + TcpFileTransferBinary.this.transferName + " TCP Binary: File='" + fileName + ".inuse' was not created in transfer...";
                msg.sysMsg("black", m);
                return;
            }
            if (!move && !append && tf0.exists()) {
                m = "The receive File='" + rxFile + "' exists and moving or appending is not allowed...";
                msg.sysMsg("bold+red", m);
                return;
            }
            if (move && tf0.exists() && !tf0.delete()) {
                m = "The receive File='" + fileName + "' could not be overwritten...";
                msg.sysMsg("bold+red", m);
                return;
            }
            try {
                if (!tft.renameTo(tf0)) {
                    m = "The receive File='" + fileName + "' could not be renamed from '.inuse' profile...";
                    msg.sysMsg("bold+red", m);
                }
            }
            catch (SecurityException se) {
                m = "Security Exception: The receive File='" + fileName + "' could not be overwritten...";
                msg.sysMsg("bold+red", m);
            }
        }

        public synchronized int parseProtocolClient(final String pstring) {
            try {
                int nr = 0;
                try {
                    nr = Integer.parseInt(TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("PID", pstring));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                switch (nr) {
                    case 602: {
                        TcpFileTransferBinary.this.timeStopMs = System.currentTimeMillis();
                        String message = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Msg", pstring);
                        msg.sysMsg("bold+red", message);
                        break;
                    }
                    case 52: {
                        TcpFileTransferBinary.this.transferMode = 2;
                        TcpFileTransferBinary.this.transferType = 1;
                        TcpFileTransferBinary.this.transferActive = true;
                        String rx_folder = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Folder", pstring);
                        String rx_Name = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("TransferName", pstring);
                        final String rx_fileName = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("File", pstring);
                        final long rx_fileSize = Long.parseLong(TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Filesize", pstring));
                        final String rx_tType = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("TransferType", pstring);
                        final boolean rx_move = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Move", pstring).contains("true");
                        final boolean rx_append = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Append", pstring).contains("true");
                        if (rx_tType.contains("Binary")) {
                            TcpFileTransferBinary.this.transferName = rx_Name;
                            TcpFileTransferBinary.this.setup(TcpFileTransferBinary.this.bootRecord);
                            rx_folder = rx_fileName.contains(".lnk") ? lmm.getRootFolder() : (rx_fileName.contains(".jar") ? lmm.getHomeFolder() + "\\lib" : TcpFileTransferBinary.this.folderRxLocal);
                            final String rxFileNm = rx_folder + "\\" + rx_fileName;
                            if (this.receiveBinaryFile(rx_fileName, rx_folder, rxFileNm, rx_fileSize, rx_tType, rx_move, rx_append)) {
                                final String folder = rx_folder;
                                new Thread(){
                                    {
                                        this.start();
                                    }

                                    @Override
                                    public void run() {
                                        Receive.this.receiveCleanUp(rx_fileName, folder, rxFileNm, rx_fileSize, rx_tType, rx_move, rx_append);
                                        String pstr = pstring.replaceAll("/>", " Folder=\"" + folder + "\" />");
                                        lmm.parseProtocolClient(pstr);
                                    }
                                };
                            }
                        }
                        TcpFileTransferBinary.this.transferMode = 0;
                        TcpFileTransferBinary.this.transferActive = false;
                        break;
                    }
                    case 57: {
                        TcpFileTransferBinary.this.transferMode = 1;
                        TcpFileTransferBinary.this.transferType = 1;
                        TcpFileTransferBinary.this.transferActive = true;
                        String pstr = pstring.replaceAll("/>", " Folder=\"" + TcpFileTransferBinary.this.folderTxLocal + "\" />");
                        lmm.parseProtocolClient(pstr);
                        String tx_folder = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Folder", pstring);
                        String tr_Name = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("TransferName", pstring);
                        String tr_fileName = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("File", pstring);
                        String tr_tType = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("TransferType", pstring);
                        boolean tr_move = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Move", pstring).contains("true");
                        boolean tr_append = TcpFileTransferBinary.this.xmlAttr.parseTagAttribute("Append", pstring).contains("true");
                        TcpFileTransferBinary.this.setup(TcpFileTransferBinary.this.bootRecord);
                        if (tx_folder == null) {
                            tx_folder = TcpFileTransferBinary.this.folderTxLocal;
                        } else if (tx_folder.length() == 0) {
                            tx_folder = TcpFileTransferBinary.this.folderTxLocal;
                        }
                        String txFileNm = tx_folder + "/" + tr_fileName;
                        File fdDst = new File(txFileNm);
                        if (!fdDst.exists()) {
                            TcpFileTransferBinary.this.transferMode = 0;
                            TcpFileTransferBinary.this.transferActive = false;
                            return 23;
                        }
                        long tr_fileSize = fdDst.length();
                        String txStr = "<ReceiveFile PID=\"52\"  TransferName=\"" + tr_Name + "\" Folder=\"" + tx_folder + "\" File=\"" + tr_fileName + "\" Filesize=\"" + tr_fileSize + "\" TransferType=\"" + tr_tType + "\" Move=\"" + tr_move + "\" Append=\"" + tr_append + "\" />";
                        if (tr_tType.contains("Binary")) {
                            TcpFileTransferBinary.this.transmitLanString(txStr);
                            TcpFileTransferBinary.this.transmitBinaryFile(tx_folder, tr_fileName, tr_move);
                        }
                        TcpFileTransferBinary.this.transferMode = 0;
                        TcpFileTransferBinary.this.transferActive = false;
                        break;
                    }
                    default: {
                        TcpFileTransferBinary.this.timeStopMs = System.currentTimeMillis();
                        String m = "DATA: Unknown XML tag and/or data in (" + pstring + ")...";
                        msg.sysMsg("bold+red", m);
                        break;
                    }
                }
            }
            catch (NullPointerException npe) {
                TcpFileTransferBinary.this.timeStopMs = System.currentTimeMillis();
                TcpFileTransferBinary.this.transferMode = 0;
                TcpFileTransferBinary.this.transferActive = false;
                String m = "NPE: Invalid XML tag and/or data in (" + pstring + ")...";
                msg.sysMsg("bold+red", m);
            }
            catch (Exception ex) {
                TcpFileTransferBinary.this.timeStopMs = System.currentTimeMillis();
                TcpFileTransferBinary.this.transferMode = 0;
                TcpFileTransferBinary.this.transferActive = false;
                String m = "EXC: Invalid XML tag and/or data in (" + pstring + ")...";
                msg.sysMsg("bold+red", m);
            }
            return 4;
        }

        public synchronized boolean shutDown(boolean allowMsg) {
            this.threadRun = false;
            Thread.currentThread().interrupt();
            return true;
        }
    }
}

