/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.services.tcp;

import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.mes.protocol.SysProtocol;
import com.nosoft.mobile.mes.security.Security;
import com.nosoft.mobile.mes.services.ServiceInterface;
import com.nosoft.mobile.sys.Sys;
import com.nosoft.mobile.sys.SysInterface;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;

public class TcpClient
extends Thread
implements FinalData,
SysProtocol,
ServiceInterface {
    private TcpClient tcp = null;
    private static SysInterface lmm = null;
    private static MessageInterface msg = null;
    private static GuiInterface gui = null;
    private String name;
    private boolean allowMsg = false;
    private boolean enable = false;
    private boolean runStatus = false;
    private boolean threadRun = true;
    private Security sec = null;
    private int LANRING = 100;
    private int inHdr = 0;
    private int inTail = 0;
    private int[] inputNum = new int[this.LANRING];
    private String[] inputStr = new String[this.LANRING];
    private String destName = "";
    private String destAddr = "";
    private Socket socket = null;
    private int toSetting = 25000;
    private long devicePort = 0L;
    private long connectCnt = 0L;
    private BufferedReader iStream = null;
    private PrintWriter oStream = null;
    private BufferedWriter writeFile;
    private String transmitFilename = "";
    private String transmitWFilename;
    private String receiveFilename = "";
    private String tmpFileName;
    private BufferedReader txFile;
    private BufferedWriter rxFile;
    private Object obj = null;
    private String mwType = "";
    private String mwTypeDescription = "";
    private final int LMMSYS = 0;
    private final int OCTSYS = 1;
    private final int SECSYS = 2;
    private int callingSys = 0;
    private boolean multiTx = false;
    private String keepTxStr = "";
    private String[] multiTxStr = null;
    private int multiRecsTot = 0;
    private int multiRecsLen = 0;
    private String multiTxStartMsg = "";
    private String multiTxEndMsg = "";
    XmlAttributeFactory xmlAttr = new XmlAttributeFactory();
    private Receive rx = null;

    public TcpClient() {
        this.tcp = this;
        gui = Gui.gui;
        msg = Sys.msg;
        lmm = Sys.fsys;
    }

    public TcpClient(String host, int port) {
        this();
        this.callingSys = 0;
        this.destAddr = host;
        this.devicePort = port;
        this.tcpConnect(host, port);
    }

    public TcpClient(Security sec, String host, int port) {
        this();
        this.sec = sec;
        this.callingSys = 2;
        this.destAddr = host;
        this.devicePort = port;
        this.tcpConnect(host, port);
    }

    public TcpClient(String host, int port, int timeout) {
        this();
        this.callingSys = 0;
        this.destAddr = host;
        this.devicePort = port;
        this.toSetting = timeout;
        this.tcpConnect(host, port);
    }

    private void tcpConnect(String host, int port) {
        String m = "Con: Port " + this.devicePort + " connect failed...";
        try {
            this.socket = new Socket(this.destAddr, port);
            if (this.socket == null) {
                return;
            }
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.toSetting);
            this.iStream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.oStream = new PrintWriter(this.socket.getOutputStream(), true);
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    Receive rx = new Receive();
                    rx.start();
                }
            };
            this.connectCnt = lmm.increaseConnectionCnt();
            this.setEnable(true);
        }
        catch (SocketException sex) {
            msg.sysMsg("bold+red", m);
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpClient.this.shutDown(true);
                }
            };
        }
        catch (IOException ioe) {
            msg.sysMsg("bold+red", m);
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpClient.this.shutDown(true);
                }
            };
        }
        catch (Exception e) {
            msg.sysMsg("bold+red", m);
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpClient.this.shutDown(true);
                }
            };
        }
    }

    @Override
    public void interrupt() {
        this.threadRun = false;
        super.interrupt();
    }

    @Override
    public void run() {
    }

    @Override
    public void setAllowMsg(boolean m) {
        this.allowMsg = m;
    }

    @Override
    public void setEnable(boolean e) {
        this.enable = e;
    }

    @Override
    public boolean getEnable() {
        return this.enable;
    }

    @Override
    public void setRunstatus(boolean r) {
        this.runStatus = r;
    }

    @Override
    public boolean getRunStatus() {
        return this.runStatus;
    }

    public void setTransmitFilename(String filename) {
        this.transmitFilename = filename;
    }

    public void setReceiveFilename(String filename) {
        this.receiveFilename = filename;
    }

    @Override
    public boolean transmitLanString(String str) {
        if (this.oStream != null && str.length() > 0) {
            this.oStream.print(str + "\r\n");
            this.oStream.flush();
        }
        return true;
    }

    @Override
    public boolean transmitLanString(String multiTxStartMsg, String multiTxEndMsg, String[] str) {
        try {
            this.multiRecsTot = str.length;
        }
        catch (NullPointerException npe) {
            this.transmitLanString("<Eof PID=\"20002\" />");
            return false;
        }
        if (this.multiRecsTot > 0) {
            this.multiTx = true;
            this.multiTxStr = str;
            this.multiRecsLen = 0;
            this.multiTxStartMsg = multiTxStartMsg;
            this.multiTxEndMsg = multiTxEndMsg;
            try {
                if (multiTxStartMsg.length() > 0) {
                    msg.sysMsg("bold+black", multiTxStartMsg);
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            this.keepTxStr = this.multiTxStr[this.multiRecsLen];
            this.transmitLanString(this.multiTxStr[this.multiRecsLen++]);
            return true;
        }
        return false;
    }

    @Override
    public boolean transactionBan() {
        return false;
    }

    private boolean closeStreams(BufferedReader iStream, PrintWriter oStream) {
        try {
            if (iStream != null) {
                iStream.close();
            }
            if (oStream != null) {
                oStream.close();
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public boolean closeConnection(Socket socket, BufferedReader iStream, PrintWriter oStream) {
        if (!this.closeStreams(iStream, oStream)) {
            String m = "Socket close failed...";
            msg.sysMsg("bold+red", m);
        }
        return true;
    }

    @Override
    public boolean shutDown(final boolean allowMsg) {
        if (this.rx != null) {
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpClient.this.rx.shutDown(allowMsg);
                }
            };
        }
        switch (this.callingSys) {
            case 0: {
                if (lmm == null) break;
                lmm.setProcessStatus(false);
                break;
            }
            default: {
                if (lmm == null) break;
                lmm.setProcessStatus(false);
            }
        }
        try {
            this.closeConnection(this.socket, this.iStream, this.oStream);
            try {
                this.socket.close();
            }
            catch (NullPointerException npe) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
        this.setEnable(false);
        this.setAllowMsg(allowMsg);
        return true;
    }

    class Receive
    extends Thread {
        private boolean threadRun = true;

        Receive() {
        }

        @Override
        public void run() {
            int state = -1;
            String m = "Con: " + TcpClient.this.destAddr + " Port " + TcpClient.this.devicePort + "...";
            msg.sysMsg("bold+blue", m);
            try {
                String inputLine = "";
                block38: while (this.threadRun && (inputLine = TcpClient.this.iStream.readLine()) != null) {
                    int len = inputLine.length();
                    if (len <= 0) continue;
                    int nr = 0;
                    try {
                        nr = Integer.parseInt(TcpClient.this.xmlAttr.parseTagAttribute("PID", inputLine));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    block3 : switch (nr) {
                        case 20001: {
                            if (TcpClient.this.callingSys != -1) {
                                state = 6;
                                break;
                            }
                            state = 4;
                            break;
                        }
                        case 20002: {
                            state = 23;
                            break;
                        }
                        case 20004: {
                            state = 4;
                            break;
                        }
                        case 20005: {
                            state = 21;
                            break;
                        }
                        case 20003: {
                            state = 3;
                            break;
                        }
                        case 20006: {
                            state = 1;
                            break;
                        }
                        case 20007: {
                            state = 2;
                            break;
                        }
                        default: {
                            switch (TcpClient.this.callingSys) {
                                case 0: {
                                    state = lmm.parseProtocolClient(inputLine);
                                    break block3;
                                }
                                case 2: {
                                    state = TcpClient.this.sec.parseProtocolClient(inputLine);
                                    break block3;
                                }
                            }
                            state = 4;
                        }
                    }
                    switch (state) {
                        case 0: {
                            break;
                        }
                        case 4: 
                        case 640: {
                            this.threadRun = false;
                            TcpClient.this.multiTx = false;
                            TcpClient.this.multiRecsLen = 0;
                            TcpClient.this.multiRecsTot = 0;
                            TcpClient.this.multiTxStartMsg = "";
                            TcpClient.this.multiTxEndMsg = "";
                            break;
                        }
                        case 21: {
                            break;
                        }
                        case 6: {
                            if (!TcpClient.this.multiTx) break;
                            if (TcpClient.this.multiRecsLen < TcpClient.this.multiRecsTot) {
                                TcpClient.this.keepTxStr = TcpClient.this.multiTxStr[TcpClient.this.multiRecsLen];
                                TcpClient.this.transmitLanString(TcpClient.this.keepTxStr);
                                TcpClient.this.multiRecsLen++;
                                break;
                            }
                            TcpClient.this.multiTx = false;
                            TcpClient.this.transmitLanString("<Eof PID=\"20002\" />");
                            try {
                                if (TcpClient.this.multiTxEndMsg.length() <= 0) continue block38;
                                msg.sysMsg("bold+black", TcpClient.this.multiTxEndMsg);
                            }
                            catch (NullPointerException npe) {}
                            break;
                        }
                        case 256: {
                            TcpClient.this.transmitLanString("<Ack PID=\"20001\" />");
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 23: {
                            this.threadRun = false;
                            TcpClient.this.transmitLanString("<Eot PID=\"20004\" />");
                            lmm.mmEvent(TcpClient.this.tcp, true);
                            break;
                        }
                        case 57: {
                            this.threadRun = false;
                            return;
                        }
                        case 52: {
                            this.threadRun = false;
                            return;
                        }
                        case 53: {
                            this.threadRun = false;
                            return;
                        }
                        case 50: {
                            ((TcpClient)TcpClient.this).inputStr[((TcpClient)TcpClient.this).inHdr] = inputLine;
                            TcpClient.this.inHdr = (TcpClient.this.inHdr + 1) % TcpClient.this.LANRING;
                            break;
                        }
                        case -1: {
                            break;
                        }
                    }
                }
            }
            catch (SocketException ste) {
                TcpClient.this.transmitLanString("<Eof PID=\"20002\" />");
                msg.sysMsg("bold+red", "Timeout " + TcpClient.this.socket.getInetAddress() + ":" + TcpClient.this.devicePort + "...");
            }
            catch (NullPointerException npe) {
                TcpClient.this.transmitLanString("<Eof PID=\"20002\" />");
                msg.sysMsg("bold+red", "NPE " + TcpClient.this.socket.getInetAddress() + ":" + TcpClient.this.devicePort + "...");
            }
            catch (InterruptedIOException iioe) {
                TcpClient.this.transmitLanString("<Eof PID=\"20002\" />");
                msg.sysMsg("bold+red", "Timeout " + TcpClient.this.socket.getInetAddress() + ":" + TcpClient.this.devicePort + "...");
            }
            catch (IOException ioe) {
                TcpClient.this.transmitLanString("<Eof PID=\"20002\" />");
            }
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    TcpClient.this.tcp.shutDown(true);
                }
            };
        }

        public boolean shutDown(boolean allowMsg) {
            this.threadRun = false;
            Thread.currentThread().interrupt();
            return true;
        }
    }
}

