/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.services.http;

import com.nosoft.mobile.mes.data.DataInterface;
import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.mes.protocol.HTTPProtocol;
import com.nosoft.mobile.mes.protocol.SysProtocol;
import com.nosoft.mobile.mes.services.ServiceInterface;
import com.nosoft.mobile.mes.services.http.HTTPInputStream;
import com.nosoft.mobile.mes.services.http.HTTPOutputStream;
import com.nosoft.mobile.mes.services.http.HTTPRequest;
import com.nosoft.mobile.sys.SysInterface;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;

public class HttpClient
extends Thread
implements ServiceInterface,
FinalData,
SysProtocol,
HTTPProtocol {
    public HttpClient http = null;
    private SysInterface mwm = null;
    private SysInterface lmm = null;
    private MessageInterface msg = null;
    private DataInterface lmmData = null;
    private String name;
    private boolean allowMsg = false;
    private boolean enable = false;
    private boolean runStatus = false;
    private boolean threadRun = true;
    private int LANRING = 100;
    private int inHdr = 0;
    private int inTail = 0;
    private int[] inputNum = new int[this.LANRING];
    private String[] inputStr = new String[this.LANRING];
    private Socket socket = null;
    private int devicePort = 0;
    private long connectCnt = 0L;
    private String serverIP = "";
    private String destAddr = "";
    private int toSetting = 6500;
    private int toTCPSetting = 10000;
    private int toOffsetSetting = 2500;
    private int toTrigger = 4000;
    private HTTPInputStream iStream = null;
    private HTTPOutputStream oStream = null;
    private HTTPRequest request = null;
    private BufferedWriter writeFile;
    private String transmitFilename = "";
    private String transmitWFilename;
    private String receiveFilename = "";
    private String tmpFileName;
    private BufferedReader txFile;
    private BufferedWriter rxFile;
    private String mwType = "";
    private String mwTypeDescription = "";
    private boolean multiTx = false;
    private String keepTxStr = "";
    private String[] multiTxStr = null;
    private int multiRecsTot = 0;
    private int multiRecsLen = 0;
    private String multiTxStartMsg = "";
    private String multiTxEndMsg = "";

    public HttpClient() {
        this.http = this;
    }

    public HttpClient(String host, int port) {
        this();
        this.serverIP = host;
        this.devicePort = port;
    }

    public HttpClient(SysInterface sys, String host, int port, String mwType, String mwTypeDescription) {
        this(host, port);
        this.mwm = sys;
        this.lmm = sys;
        this.msg = sys.getMsg();
        this.lmmData = sys.getLmmData();
        this.mwType = mwType;
        this.mwTypeDescription = mwTypeDescription;
        try {
            this.socket = new Socket(this.serverIP, this.devicePort);
            this.iStream = new HTTPInputStream(this.socket.getInputStream());
            this.oStream = new HTTPOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.connectCnt = this.lmm.increaseConnectionCnt();
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    Receive rx = new Receive();
                    rx.start();
                }
            };
            this.enable = true;
        }
        catch (IOException ioe) {
            String m = "NoSoftTerminal network connection " + this.connectCnt + " on port " + this.devicePort + " failed to start...";
            this.msg.sysMsg("bold+red", m);
        }
    }

    private void tcpConnect(String host, int port, int toSetting, int toOffsetSetting) {
        String m = "Con: Port " + this.devicePort + " connect failed...";
        this.toSetting = toSetting;
        this.toTCPSetting = toSetting + 3000;
        if (toSetting > 0) {
            if (toSetting > toOffsetSetting) {
                this.toOffsetSetting = toOffsetSetting;
                this.toTrigger = toSetting - toOffsetSetting;
            } else {
                this.toSetting = 6500;
                this.toOffsetSetting = 3000;
                this.toTrigger = 3500;
            }
        } else {
            this.toTCPSetting = 0;
        }
        try {
            this.connectCnt = this.lmm.increaseConnectionCnt();
            this.socket = new Socket(this.serverIP, this.devicePort);
            if (this.socket == null) {
                return;
            }
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.toTCPSetting);
            this.iStream = new HTTPInputStream(this.socket.getInputStream());
            this.oStream = new HTTPOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    Receive rx = new Receive();
                    rx.start();
                }
            };
            this.enable = true;
        }
        catch (SocketException sex) {
            this.msg.sysMsg("bold+red", m);
            return;
        }
        catch (IOException ioe) {
            this.msg.sysMsg("bold+red", m);
            this.shutDown(true);
            return;
        }
        catch (Exception e) {
            this.msg.sysMsg("bold+red", m);
            this.shutDown(true);
            return;
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.threadRun = false;
        try {
            this.closeConnection(this.socket, this.iStream, this.oStream);
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void run() {
    }

    @Override
    public void setAllowMsg(boolean m) {
        this.allowMsg = m;
    }

    @Override
    public void setEnable(boolean e) {
        this.enable = e;
    }

    @Override
    public boolean getEnable() {
        return this.enable;
    }

    @Override
    public void setRunstatus(boolean r) {
        this.runStatus = r;
    }

    @Override
    public boolean getRunStatus() {
        return this.runStatus;
    }

    public void setTransmitFilename(String filename) {
        this.transmitFilename = filename;
    }

    public void setReceiveFilename(String filename) {
        this.receiveFilename = filename;
    }

    public String getHTTPFilename() {
        return this.request.getFileName();
    }

    @Override
    public synchronized boolean transactionBan() {
        return false;
    }

    @Override
    public synchronized boolean transmitLanString(String str) {
        if (this.oStream != null && str.length() > 0) {
            try {
                byte[] buffer = str.getBytes();
                int len = buffer.length;
                for (int i = 0; i < len; ++i) {
                    this.oStream.write(buffer[i]);
                }
                this.oStream.flush();
            }
            catch (IOException ioe) {
                this.msg.sysMsg("bold+red", "Error occurred while transmitting a string via HTTP...");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean transmitLanString(String multiTxStartMsg, String multiTxEndMsg, String[] str) {
        try {
            this.multiRecsTot = str.length;
        }
        catch (NullPointerException npe) {
            this.transmitLanString("<Eof PID=\"20002\" />");
            return false;
        }
        if (this.multiRecsTot > 0) {
            this.multiTx = true;
            this.multiTxStr = str;
            this.multiRecsLen = 0;
            this.multiTxStartMsg = multiTxStartMsg;
            this.multiTxEndMsg = multiTxEndMsg;
            try {
                if (multiTxStartMsg.length() > 0) {
                    this.msg.sysMsg("bold+black", multiTxStartMsg);
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            this.keepTxStr = this.multiTxStr[this.multiRecsLen];
            this.transmitLanString(this.multiTxStr[this.multiRecsLen++]);
            return true;
        }
        return false;
    }

    void sendHTTP404(File targ) throws IOException {
        this.transmitLanString("\r\n");
        this.transmitLanString("Not Found\n\nRequested resource " + targ + " not found.\n");
    }

    private synchronized boolean closeStreams(HTTPInputStream iStream, HTTPOutputStream oStream) {
        try {
            if (iStream != null) {
                iStream.close();
            }
            if (oStream != null) {
                oStream.close();
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public synchronized boolean closeConnection(Socket socket, HTTPInputStream iStream, HTTPOutputStream oStream) {
        String m;
        if (!this.closeStreams(iStream, oStream)) {
            m = "NoSoftTerminal could not read from socket " + socket + " port " + this.devicePort + " while closing the connection...";
            this.msg.sysMsg("bold+red", m);
        }
        if (this.mwType != "") {
            m = this.mwTypeDescription + " network connection " + this.connectCnt + " now closing on socket " + socket + " port " + this.devicePort + "...";
            this.msg.sysMsg("bold+blue", m);
        }
        this.lmm.decreaseConnectionCnt();
        return true;
    }

    @Override
    public boolean shutDown(boolean allowMsg) {
        Thread.currentThread().interrupt();
        this.setEnable(false);
        this.setAllowMsg(allowMsg);
        return true;
    }

    class Receive
    extends Thread {
        Receive() {
        }

        @Override
        public synchronized void run() {
            int state = -1;
            String m = HttpClient.this.mwTypeDescription + " network connection " + HttpClient.this.connectCnt + " from " + HttpClient.this.destAddr + " on port " + HttpClient.this.devicePort + "...";
            HttpClient.this.msg.sysMsg("bold+blue", m);
            try {
                String inputLine = "";
                while (HttpClient.this.threadRun) {
                    int len;
                    HttpClient.this.request = HttpClient.this.iStream.getRequest();
                    inputLine = HttpClient.this.request.isGetRequest();
                    if (inputLine != "") {
                        len = inputLine.length();
                        if (len > 0) {
                            state = HttpClient.this.mwm.parseProtocolClient(inputLine);
                        }
                    } else {
                        inputLine = HttpClient.this.request.isPutRequest();
                        if (inputLine == "" || (len = inputLine.length()) > 0) {
                            // empty if block
                        }
                    }
                    HttpClient.this.threadRun = false;
                }
            }
            catch (InterruptedIOException iioe) {
                HttpClient.this.threadRun = false;
            }
            catch (IOException ioe) {
                HttpClient.this.threadRun = false;
            }
            HttpClient.this.shutDown(false);
        }
    }
}

