/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.security;

import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.sys.SysInterface;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class UserPasswordDialog
extends Frame {
    public UserPasswordDialog upd = this;
    private SysInterface lmm = null;
    private MessageInterface msg = null;
    private GuiInterface frame;
    private String userName = "";
    private String passWord = "";
    private boolean changePwd = false;
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    private Button cancelButton;
    private Button okButton;
    private TextField passwordField1;
    private TextField passwordField2;
    private Label passwordLabel1;
    private Label passwordLabel2;
    private TextField spacerField1;
    private TextField spacerField2;
    private Label userLabel;
    private TextField usernameField;

    public UserPasswordDialog(GuiInterface parent, boolean modal) {
        this.lmm = parent.getSysHandle();
        this.msg = this.lmm.getMsg();
        this.frame = parent;
        this.initComponents();
        this.jmtInitComponents();
    }

    public UserPasswordDialog(GuiInterface parent, boolean modal, String user, boolean changePwd) {
        this(parent, modal);
        this.userName = user;
        this.changePwd = changePwd;
    }

    private void jmtInitComponents() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.getMaximumSize().width;
        int x = (dim.width - width) / 2;
        int y = 20;
        this.setLocation(x, y);
        this.passwordLabel2.setVisible(this.changePwd);
        this.passwordField2.setEnabled(this.changePwd);
        this.passwordField2.setVisible(this.changePwd);
        if (this.userName.length() == 0) {
            this.usernameField.setText("Admin");
        } else {
            this.usernameField.setText(this.userName);
        }
        if (!this.changePwd) {
            this.initUserPwdComponents();
        } else {
            this.initChangePwdComponents();
        }
        this.setVisible(true);
    }

    public void initUserPwdComponents() {
    }

    public void initChangePwdComponents() {
    }

    @Override
    public void setUndecorated(boolean dec) {
    }

    public void run() {
    }

    private void initComponents() {
        this.okButton = new Button();
        this.cancelButton = new Button();
        this.userLabel = new Label();
        this.usernameField = new TextField();
        this.passwordLabel1 = new Label();
        this.passwordField1 = new TextField();
        this.passwordLabel2 = new Label();
        this.passwordField2 = new TextField();
        this.spacerField1 = new TextField();
        this.spacerField2 = new TextField();
        this.setBackground(new Color(204, 204, 204));
        this.setFont(new Font("Arial", 1, 12));
        this.setMaximumSize(new Dimension(230, 160));
        this.setUndecorated(true);
        this.setResizable(false);
        this.setTitle("Access Control");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UserPasswordDialog.this.closeDialog(evt);
            }
        });
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setLabel("OK");
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserPasswordDialog.this.okButtonMouseClicked(evt);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPasswordDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.okButton, new AbsoluteConstraints(90, 120, -1, -1));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setLabel("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPasswordDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.cancelButton, new AbsoluteConstraints(140, 120, -1, -1));
        this.userLabel.setFont(new Font("Arial", 1, 12));
        this.userLabel.setText("Username:");
        this.add((Component)this.userLabel, new AbsoluteConstraints(10, 30, -1, -1));
        this.usernameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                UserPasswordDialog.this.usernameFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                UserPasswordDialog.this.usernameFieldFocusLost(evt);
            }
        });
        this.add((Component)this.usernameField, new AbsoluteConstraints(90, 30, 100, -1));
        this.passwordLabel1.setFont(new Font("Arial", 1, 12));
        this.passwordLabel1.setText("Password:");
        this.add((Component)this.passwordLabel1, new AbsoluteConstraints(10, 60, -1, -1));
        this.passwordField1.setEchoChar('*');
        this.passwordField1.setText("*****");
        this.passwordField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPasswordDialog.this.passwordField1ActionPerformed(evt);
            }
        });
        this.passwordField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                UserPasswordDialog.this.passwordField1FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                UserPasswordDialog.this.passwordField1FocusLost(evt);
            }
        });
        this.add((Component)this.passwordField1, new AbsoluteConstraints(90, 60, 100, -1));
        this.passwordLabel2.setFont(new Font("Arial", 1, 12));
        this.passwordLabel2.setText("Retype:");
        this.add((Component)this.passwordLabel2, new AbsoluteConstraints(10, 90, -1, -1));
        this.passwordField2.setEchoChar('*');
        this.passwordField2.setEnabled(false);
        this.passwordField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                UserPasswordDialog.this.passwordField2FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                UserPasswordDialog.this.passwordField2FocusLost(evt);
            }
        });
        this.add((Component)this.passwordField2, new AbsoluteConstraints(90, 90, 100, -1));
        this.spacerField1.setEditable(false);
        this.spacerField1.setEnabled(false);
        this.spacerField1.setText("textField1");
        this.spacerField1.setVisible(false);
        this.add((Component)this.spacerField1, new AbsoluteConstraints(0, 0, 230, 10));
        this.spacerField2.setEditable(false);
        this.spacerField2.setEnabled(false);
        this.spacerField2.setText("textField1");
        this.spacerField2.setVisible(false);
        this.add((Component)this.spacerField2, new AbsoluteConstraints(220, 0, 10, 160));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        final String[] unpw = new String[4];
        try {
            unpw[0] = this.usernameField.getText();
        }
        catch (NullPointerException npe) {
            unpw[0] = "";
        }
        try {
            char[] ca = this.passwordField1.getText().toCharArray();
            unpw[1] = "";
            for (int i = 0; i < ca.length; ++i) {
                unpw[1] = unpw[1] + ca[i];
            }
            if (this.changePwd) {
                int i;
                char[] cp1 = this.passwordField1.getText().toCharArray();
                char[] cp2 = this.passwordField2.getText().toCharArray();
                unpw[2] = "";
                for (i = 0; i < cp1.length; ++i) {
                    unpw[2] = unpw[2] + cp1[i];
                }
                unpw[3] = "";
                for (i = 0; i < cp2.length; ++i) {
                    unpw[3] = unpw[3] + cp2[i];
                }
                if (!unpw[2].equals(unpw[3])) {
                    this.msg.sysMsg("bold+red", "Password fields differ...");
                    return;
                }
            }
        }
        catch (NullPointerException npe) {
            unpw[1] = "";
        }
        if (this.lmm != null) {
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    if (!UserPasswordDialog.this.changePwd) {
                        UserPasswordDialog.this.lmm.getSecurityHandle().systemLogon(unpw);
                    } else {
                        UserPasswordDialog.this.lmm.getSecurityHandle().systemChangePwdLogon(unpw);
                    }
                }
            };
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void usernameFieldFocusGained(FocusEvent evt) {
    }

    private void usernameFieldFocusLost(FocusEvent evt) {
    }

    private void passwordField1FocusGained(FocusEvent evt) {
    }

    private void passwordField1FocusLost(FocusEvent evt) {
    }

    private void passwordField2FocusGained(FocusEvent evt) {
    }

    private void passwordField2FocusLost(FocusEvent evt) {
    }

    private void passwordField1ActionPerformed(ActionEvent evt) {
    }

    private void okButtonMouseClicked(MouseEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserPasswordDialog dialog = new UserPasswordDialog((GuiInterface)((Object)new Frame()), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

