/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.security;

import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.mes.protocol.SysProtocol;
import com.nosoft.mobile.mes.security.UserPasswordDialog;
import com.nosoft.mobile.mes.services.tcp.TcpClient;
import com.nosoft.mobile.mes.util.WaitTimer;
import com.nosoft.mobile.sys.Sys;
import com.nosoft.mobile.sys.SysInterface;
import java.util.Random;

public class Security
extends Thread
implements FinalData,
SysProtocol {
    private static Security security = null;
    private static SysInterface lmm = null;
    private static MessageInterface msg = null;
    private static GuiInterface gui = null;
    private String name;
    private boolean allowMsg = false;
    private boolean enable = false;
    private boolean runStatus = true;
    private TcpClient tcp = null;
    private TcpClient tcpA = null;
    private String hostURL = "http://127.0.0.1";
    private String serverIP = "127.0.0.1";
    private int listenPort = 2000;
    private int serverPort = 2071;
    XmlAttributeFactory xmlAttr = new XmlAttributeFactory();
    private static boolean logIn = true;
    private static boolean loggedIn = false;
    private static int loginStatus = 0;
    private static String username = "";
    private static String password = "";
    private boolean changePwd = false;
    private static long loginCnt = 0L;
    private String srvUsrNm = "";
    private String srvUsrPw = "";
    private String srvSuperUsrNm = "";
    private String srvSuperUsrPw = "";
    private String usrNm = "";
    private String usrPw = "";
    private String SuperUsrNm = "";
    private String SuperUsrPw = "";
    private String licenseNr = "1";
    private String startDate = "2008-01-01";
    private String endDate = "2009-01-01";
    private String[] licStr = new String[5];
    private long licVal = 0L;
    private boolean licenseValid = true;
    private int licenseRandomSec = new Random().nextInt(60);
    private boolean licenseCheck = false;
    private static String licenseNumber = "";
    private boolean licenseStatus = false;
    private String key = "05668011022015";

    public Security() {
        security = this;
        gui = Gui.gui;
        msg = Sys.msg;
        lmm = Sys.fsys;
    }

    public Security(boolean allowMsg, boolean enable) {
        this();
        this.allowMsg = allowMsg;
        this.enable = enable;
    }

    public Security(boolean allowMsg, boolean enable, String serverIP) {
        this(allowMsg, enable);
        this.serverIP = serverIP;
        this.start();
    }

    public boolean xmlConfig(String nl) {
        logIn = "true".equals(this.xmlAttr.parseTagAttribute("Logon", nl));
        return logIn;
    }

    public void setupServerSecurityData(String nl) {
        try {
            this.srvUsrNm = this.xmlAttr.parseTagAttribute("UserName", nl);
            this.srvUsrPw = this.xmlAttr.parseTagAttribute("UserPassword", nl);
            this.srvSuperUsrNm = this.xmlAttr.parseTagAttribute("SuperUserName", nl);
            this.srvSuperUsrPw = this.xmlAttr.parseTagAttribute("SuperUserPassword", nl);
            msg.sysMsg("bold+italic+black", "Security data input done...");
        }
        catch (NullPointerException npe) {
            msg.sysMsg("bold+red", "Security data not available...");
        }
    }

    public void setupModuleSecurityData(String nl) {
        try {
            this.usrNm = this.xmlAttr.parseTagAttribute("UserName", nl);
            this.usrPw = this.xmlAttr.parseTagAttribute("UserPassword", nl);
            this.SuperUsrNm = this.xmlAttr.parseTagAttribute("SuperUserName", nl);
            this.SuperUsrPw = this.xmlAttr.parseTagAttribute("SuperUserPassword", nl);
            msg.sysMsg("bold+italic+black", "\nNoSoftTerminal Plant Management Module Security data has been successfully input...");
        }
        catch (NullPointerException npe) {
            msg.sysMsg("bold+red", "\nNoSoftTerminal Plant Management Module security data not available...");
        }
    }

    private boolean parseLicenseKeys(String nl) {
        return false;
    }

    public boolean checkLicenseValidity(String licStr) {
        int switchValue = 0;
        switch (switchValue) {
            case -5: {
                msg.sysMsg("bold+red", "Invalid license key...");
                return false;
            }
            case -4: {
                msg.sysMsg("bold+red", "License expires in 4 weeks...");
                return true;
            }
            case -3: {
                msg.sysMsg("bold+red", "License expires in 3 weeks...");
                return true;
            }
            case -2: {
                msg.sysMsg("bold+red", "License expires in 2 weeks...");
                return true;
            }
            case -1: {
                msg.sysMsg("bold+red", "License expires in 1 week...");
                return true;
            }
            case 0: {
                System.out.println("System license has expired...");
                return false;
            }
            case 1: {
                this.showLicenseData(licStr);
                return true;
            }
        }
        msg.sysMsg("bold+red", "License key problem...");
        return false;
    }

    private void showLicenseData(String licStr) {
        msg.sysMsg("bold+italic+black", "License OK - Key: " + licStr);
    }

    public boolean runSystem() {
        this.start();
        return true;
    }

    @Override
    public void interrupt() {
        this.runStatus = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLoginTimeout() {
        Security security = this;
        synchronized (security) {
            loginCnt = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setAllowMsg(true);
        WaitTimer wt = new WaitTimer();
        while (this.runStatus) {
            wt.waitFor(1000);
            if (!this.checkLogonStatus() || (loginCnt += 1000L) <= 900000L) continue;
            Security security = this;
            synchronized (security) {
                loginCnt = 0L;
            }
            loginStatus = 2;
            this.systemLogoff(username);
        }
        msg.sysMsg("bold+black", "NoSoftTerminal shutting down...");
    }

    public boolean systemLogon(String[] str) {
        username = str[0];
        password = str[1];
        if (!this.checkLogonStatus()) {
            this.initiateAccessControl(str);
        }
        return true;
    }

    public boolean systemLogoff(String username) {
        if (this.checkLogonStatus()) {
            String[] str = new String[]{username, ""};
            this.initiateAccessControl(str);
        }
        return true;
    }

    public void processLoginLogout(GuiInterface frame, final boolean changePwd) {
        if (!logIn) {
            loggedIn = true;
            return;
        }
        new Thread(){
            {
                this.start();
            }

            @Override
            public void run() {
                String user = Security.this.getLoggedOnUser();
                if (changePwd) {
                    new UserPasswordDialog(gui, true, user, changePwd);
                } else if (!Security.this.checkLogonStatus()) {
                    new UserPasswordDialog(gui, true, user, changePwd);
                } else {
                    Security.this.systemLogoff(user);
                }
            }
        };
    }

    public boolean systemChangePwdLogon(String[] str) {
        if (!logIn) {
            return false;
        }
        this.changePwd = true;
        this.initiateAccessControl(str);
        return true;
    }

    public boolean checkLogonStatus() {
        if (logIn) {
            return loggedIn;
        }
        return true;
    }

    public void initiateAccessControl(String[] unpw) {
        if (this.changePwd) {
            this.changePwd = false;
            username = unpw[0];
            password = unpw[1];
            String str = "<ChangePassword PID=\"47\" TransactionType=\"ChangePassword\" Username=\"" + unpw[0] + "\" Password=\"" + unpw[1] + "\" NewPassword=\"" + unpw[2] + "\" />";
            this.tcpA = new TcpClient(this, this.serverIP, this.serverPort);
            if (this.tcpA != null) {
                this.tcpA.transmitLanString(str);
            }
        } else if (loginStatus == 0) {
            username = unpw[0];
            password = unpw[1];
            String str = "<Logon PID=\"40\" TransactionType=\"Logon\" Mode=\"1\" Username=\"" + unpw[0] + "\" Password=\"" + unpw[1] + "\" />";
            this.tcpA = new TcpClient(this, this.serverIP, this.serverPort);
            if (this.tcpA != null) {
                loginStatus = 1;
                this.tcpA.transmitLanString(str);
            }
        } else if (loginStatus == 2) {
            String str = "<Logoff PID=\"42\" TransactionType=\"Logoff\" Mode=\"1\" Username=\"" + username + "\" />";
            this.tcpA = new TcpClient(this, this.serverIP, this.serverPort);
            if (this.tcpA != null) {
                this.tcpA.transmitLanString(str);
            }
        } else {
            loginStatus = 0;
        }
    }

    public int parseProtocolClient(String pstring) {
        System.out.println(pstring);
        try {
            XmlAttributeFactory xmlAttr = new XmlAttributeFactory();
            int nr = 0;
            try {
                nr = Integer.parseInt(xmlAttr.parseTagAttribute("PID", pstring));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            switch (nr) {
                case 41: {
                    if (!logIn) break;
                    username = xmlAttr.parseTagAttribute("Username", pstring);
                    String status = xmlAttr.parseTagAttribute("Status", pstring);
                    String message = xmlAttr.parseTagAttribute("Msg", pstring);
                    if (status.equals("true")) {
                        loggedIn = true;
                        loginStatus = 2;
                        msg.sysMsg("bold+black", "User " + username + " logged in...");
                        lmm.reportLogonStatus(true, 1, username);
                    } else {
                        loggedIn = false;
                        loginStatus = 0;
                        msg.sysMsg("bold+red", message);
                        lmm.reportLogonStatus(false, 1, username);
                    }
                    return 23;
                }
                case 43: {
                    if (!logIn) break;
                    String status = xmlAttr.parseTagAttribute("Status", pstring);
                    username = xmlAttr.parseTagAttribute("Username", pstring);
                    String message = xmlAttr.parseTagAttribute("Msg", pstring);
                    if (status.equals("true")) {
                        loggedIn = false;
                        loginStatus = 0;
                        msg.sysMsg("bold+black", "User " + username + " logged out...");
                        lmm.reportLogonStatus(false, 0, username);
                        this.processLoginLogout(gui, false);
                    } else {
                        msg.sysMsg("bold+red", message);
                        lmm.reportLogonStatus(false, 0, username);
                    }
                    return 23;
                }
                case 48: {
                    if (!logIn) break;
                    String status = xmlAttr.parseTagAttribute("Status", pstring);
                    username = xmlAttr.parseTagAttribute("Username", pstring);
                    String message = xmlAttr.parseTagAttribute("Msg", pstring);
                    if (status.equals("true")) {
                        msg.sysMsg("bold+black", "User " + username + " password changed...");
                        lmm.reportLogonStatus(true, 2, username);
                    } else {
                        msg.sysMsg("bold+red", message);
                        lmm.reportLogonStatus(false, 2, username);
                    }
                    return 23;
                }
                default: {
                    String m = "Unknown security module XML tag...";
                    msg.sysMsg("bold+red", m);
                }
            }
        }
        catch (NullPointerException npe) {
            String m = "NPE: Invalid security module XML tag and/or data in (" + pstring + ")...";
            msg.sysMsg("bold+red", m);
            return 4;
        }
        catch (Exception ex) {
            String m = "EXC: Invalid security module XML tag and/or data in (" + pstring + ")...";
            msg.sysMsg("bold+red", m);
            return 4;
        }
        return 256;
    }

    public void setAllowMsg(boolean m) {
        this.allowMsg = m;
    }

    public String getDName() {
        return this.name;
    }

    public void setEnable(boolean e) {
        this.enable = e;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setRunstatus(boolean r) {
        this.runStatus = r;
    }

    public boolean getRunStatus() {
        return this.runStatus;
    }

    public Security getInstance() {
        return security;
    }

    public boolean getLoginStatus() {
        if (logIn) {
            return loggedIn;
        }
        return true;
    }

    public void setGuiHandle(GuiInterface gui) {
        Security.gui = gui;
    }

    public void setLoginStatus(boolean status) {
        loggedIn = status;
    }

    public String getLoggedOnUser() {
        return username;
    }

    public void setLoggedOnUser(String username) {
        Security.username = username;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        Security.password = password;
    }

    public void setLicenseNumber(String licenseNr) {
        this.licenseNr = licenseNr;
    }

    public String getLicenseNumber() {
        return this.licenseNr;
    }

    public void setLicenseValid(boolean licenseValid) {
        this.licenseValid = licenseValid;
    }

    public boolean getLicenseValid() {
        return this.licenseValid;
    }

    public void setLicenseChecked(boolean licenseCheck) {
        this.licenseCheck = licenseCheck;
    }

    public boolean getLicenseChecked() {
        return this.licenseCheck;
    }

    public boolean shutDown(boolean allowMsg) {
        this.enable = false;
        this.setAllowMsg(allowMsg);
        return true;
    }
}

