/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.messages;

import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.factories.XmlFactory;
import com.nosoft.mobile.mes.gui.FinalGuiData;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.gui.pdtadvanced.MessagePanel;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.mes.util.WaitTimer;
import com.nosoft.mobile.sys.Sys;
import com.nosoft.mobile.sys.SysInterface;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Message
extends Thread
implements FinalGuiData,
MessageInterface {
    private static MessageInterface msg = null;
    private SysInterface fsys = null;
    public GuiInterface gui = null;
    private String name = "Message";
    private boolean allowMsg = true;
    private boolean enable = false;
    private boolean runStatus = false;
    private boolean msgToggle = false;
    public int MESSAGERING = 100;
    private int msgHdr = 0;
    private int msgTail = 0;
    private int msgQueTot = this.MESSAGERING;
    private String[] msgQue = new String[this.MESSAGERING];
    private String[] msgColor = new String[this.MESSAGERING];
    private boolean msgLog = false;
    private int msgLineTot = this.MESSAGERING;
    private String msgDefColor = "black";
    private XmlAttributeFactory xmlAttr = new XmlAttributeFactory();

    public Message() {
        msg = this;
        this.fsys = Sys.fsys;
    }

    public Message(boolean allowMsg, boolean enable) {
        this();
        this.allowMsg = allowMsg;
        this.enable = enable;
        this.startMessages();
    }

    public static MessageInterface getInstance() {
        if (msg == null) {
            msg = new Message(true, true);
        }
        return msg;
    }

    @Override
    public MessageInterface getMsg() {
        return msg;
    }

    public void setMsg(MessageInterface aMsg) {
        msg = aMsg;
    }

    public void startMessages() {
        if (this.enable && !this.runStatus) {
            this.runStatus = true;
            this.start();
        }
    }

    @Override
    public boolean xmlConfigDevice(Node xmlnode) {
        NodeList nodes = xmlnode.getChildNodes();
        try {
            String ql = XmlFactory.lookupValue(nodes, "MsgQueLength");
            if (!ql.isEmpty()) {
                try {
                    int q;
                    this.MESSAGERING = q = Integer.parseInt(ql);
                }
                catch (NumberFormatException nfe) {}
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private synchronized void addMsgToQue(String colorAndStyle, String msg) {
        if ((this.msgHdr + 1) % this.msgQueTot == this.msgTail) {
            return;
        }
        if (msg.length() > 0) {
            this.msgQue[this.msgHdr] = msg;
            this.msgColor[this.msgHdr] = colorAndStyle;
            this.msgHdr = (this.msgHdr + 1) % this.msgQueTot;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMsgQue() {
        block8: {
            try {
                if (this.msgQue[this.msgTail].length() <= 0) break block8;
                try {
                    boolean bl = this.msgToggle = !this.msgToggle;
                    if (this.msgToggle) {
                        this.gui.displayLCDLine(6, this.msgColor[this.msgTail], this.msgQue[this.msgTail]);
                        break block8;
                    }
                    this.gui.displayLCDLine(7, this.msgColor[this.msgTail], this.msgQue[this.msgTail]);
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            finally {
                this.msgTail = (this.msgTail + 1) % this.msgQueTot;
            }
        }
    }

    @Override
    public synchronized void sysMsgClear() {
        if (this.allowMsg) {
            if (this.gui == null) {
                System.out.println(this.getMsg());
            } else {
                this.addMsgToQue(this.msgDefColor, " ");
                this.addMsgToQue(this.msgDefColor, " ");
            }
        }
    }

    @Override
    public synchronized void sysMsg(String msg) {
        if (this.allowMsg) {
            if (this.gui == null) {
                System.out.println(msg);
            } else {
                this.addMsgToQue(this.msgDefColor, msg);
            }
        }
    }

    @Override
    public synchronized void sysMsg(String colorAndStyle, String msg) {
        if (this.allowMsg) {
            try {
                switch (this.fsys.getLmmType()) {
                    case "logistics": {
                        MessagePanel.instance.addMessage(msg);
                        break;
                    }
                    case "packhouse": {
                        this.addMsgToQue(colorAndStyle, msg);
                        break;
                    }
                    default: {
                        System.out.println(msg);
                        break;
                    }
                }
            }
            catch (NullPointerException npe) {
                System.out.println(msg);
            }
        }
    }

    @Override
    public synchronized void sysMsg(String colorAndStyle, String msg, int code) {
        if (this.allowMsg) {
            try {
                switch (this.fsys.getLmmType()) {
                    case "logistics": {
                        MessagePanel.instance.addMessage(msg + ": " + code + " ...");
                        break;
                    }
                    case "packhouse": {
                        this.addMsgToQue(colorAndStyle, msg + ": " + code + " ...");
                        break;
                    }
                    default: {
                        System.out.println(msg);
                        break;
                    }
                }
            }
            catch (NullPointerException npe) {
                System.out.println(msg);
            }
        }
    }

    @Override
    public void run() {
        WaitTimer wt = new WaitTimer();
        while (this.runStatus) {
            wt.waitFor(500);
            while (this.msgTail != this.msgHdr) {
                this.processMsgQue();
            }
        }
    }

    @Override
    public void setAllowMsg(boolean m) {
        this.allowMsg = m;
    }

    @Override
    public void setSysInterface(SysInterface fsys) {
        this.fsys = fsys;
    }

    @Override
    public void setGuiInterface(GuiInterface gui) {
        this.gui = gui;
    }

    @Override
    public void setEnable(boolean e) {
        this.enable = false;
    }

    @Override
    public boolean getEnable() {
        return false;
    }

    @Override
    public void setRunstatus(boolean r) {
        this.runStatus = false;
    }

    @Override
    public boolean getRunStatus() {
        return false;
    }

    @Override
    public void setMessageToggle() {
        if (this.allowMsg) {
            try {
                switch (this.fsys.getLmmType()) {
                    case "logistics": {
                        MessagePanel.instance.addMessage("System messages now disabled...");
                        break;
                    }
                    case "packhouse": {
                        this.sysMsg("bold+black", "System messages now disabled...");
                        break;
                    }
                    default: {
                        System.out.println(this.getMsg());
                    }
                }
                this.allowMsg = false;
            }
            catch (NullPointerException npe) {
                System.out.println(this.getMsg());
            }
        } else {
            try {
                switch (this.fsys.getLmmType()) {
                    case "logistics": {
                        MessagePanel.instance.addMessage("System messages now enabled...");
                        break;
                    }
                    case "packhouse": {
                        this.sysMsg("bold+black", "System messages now enabled...");
                        break;
                    }
                    default: {
                        System.out.println(this.getMsg());
                    }
                }
                this.allowMsg = true;
            }
            catch (NullPointerException npe) {
                System.out.println(this.getMsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutDown(boolean allowMsg) {
        this.enable = false;
        this.runStatus = false;
        this.setAllowMsg(allowMsg);
        Message message = this;
        synchronized (message) {
            this.notify();
        }
        return true;
    }
}

