/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtstandard;

import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.gui.DynamicConfigurationInterface;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.gui.pdtstandard.MenuItemObject;
import com.nosoft.mobile.mes.gui.pdtstandard.MenuObject;
import com.nosoft.mobile.mes.gui.pdtstandard.PeripheralMenuObject;
import com.nosoft.mobile.sys.SysInterface;
import java.awt.Menu;
import java.util.HashMap;

public class DynamicConfiguration
implements DynamicConfigurationInterface {
    protected SysInterface lmm = null;
    protected GuiInterface gui = null;
    protected Menu rootMain = null;
    protected String menuFileName = "";
    protected String menuFmtStr = "";
    private HashMap hashMenu = new HashMap();
    private HashMap serverMenu = new HashMap();
    private HashMap printerMenu = new HashMap();
    private HashMap userMenu = new HashMap();
    private int depth = 0;
    private int depthPrev = 0;
    private String curKey = "0.0";
    private String[] menu = new String[4];
    private String[] pmenu = new String[4];
    private Menu curMenu = null;
    private Menu[] parent = new Menu[6];
    XmlAttributeFactory xmlAttr = new XmlAttributeFactory();

    public DynamicConfiguration(SysInterface lmm, GuiInterface gui, Menu rootMain) {
        this.lmm = lmm;
        this.gui = gui;
        this.rootMain = rootMain;
        this.makeUserMenuOptions();
    }

    private void makeUserMenuOptions() {
        this.userMenu.put("0.0", "0");
        for (int i = 1; i < 3; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.userMenu.put("" + i + "." + j, "0");
                for (int k = 1; k < 13; ++k) {
                    this.userMenu.put("" + i + "." + j + "." + k, "1");
                    for (int l = 1; l < 13; ++l) {
                        this.userMenu.put("" + i + "." + j + "." + k + "." + l, "2");
                    }
                }
            }
        }
    }

    private int menuDepth(String key) {
        int deep = -1;
        if (this.userMenu.containsKey(key)) {
            String mk = (String)this.userMenu.get(key);
            try {
                deep = Integer.parseInt(mk);
            }
            catch (NumberFormatException nfe) {
                deep = -1;
            }
        }
        return deep;
    }

    @Override
    public boolean buildMenu(String pstring) {
        try {
            String str = pstring.trim();
            if (str.startsWith("#")) {
                return false;
            }
            this.menu[0] = this.xmlAttr.parseTagAttribute("Item", str);
            this.menu[1] = this.xmlAttr.parseTagAttribute("Name", str);
            this.menu[2] = this.xmlAttr.parseTagAttribute("NodeType", str);
            this.depth = this.menuDepth(this.menu[0]);
            if (this.depth == -1) {
                System.out.println("Invalid menu configuration=" + this.menu[0]);
                return false;
            }
            if (this.depth > this.depthPrev) {
                this.parent[this.depth] = (Menu)this.hashMenu.get(this.curKey);
            }
            this.curKey = this.menu[0];
            this.depthPrev = this.depth;
            if (this.menu[0].equals("0.0") && this.menu[2].equals("0")) {
                this.parent[this.depth] = this.rootMain;
                this.hashMenu.clear();
                if (pstring.contains("Enable")) {
                    boolean enable = "true".equals(this.xmlAttr.parseTagAttribute("Enable", pstring));
                    if (enable) {
                        this.rootMain.setEnabled(enable);
                    } else {
                        this.rootMain.setEnabled(false);
                    }
                }
                this.curKey = this.menu[0];
                this.menuFmtStr = str;
                this.gui.setMainLabel(this.menu[1]);
                this.gui.setButtonConfiguration(str);
                this.gui.setInputConfiguration(str);
            } else if (this.menu[2].equals("1")) {
                this.hashMenu.put(this.menu[0], new MenuObject(this.gui, this.parent[this.depth], this.menu, str));
            } else if (this.menu[2].equals("2")) {
                this.hashMenu.put(this.menu[0], new MenuItemObject(this.lmm, this.gui, this.parent[this.depth], this.menu, str));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String getMenuItemConfiguration(String key) {
        String str = "";
        boolean b = false;
        if (this.hashMenu.containsKey(key)) {
            try {
                MenuItemObject mio = (MenuItemObject)this.hashMenu.get(key);
                str = mio.getConfigurationData();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return str;
    }

    @Override
    public boolean setMenuItemConfiguration(String key, String pstring) {
        boolean b = false;
        try {
            MenuObject mo = (MenuObject)this.hashMenu.get(key);
            mo.setConfigurationData(pstring);
            b = true;
        }
        catch (NullPointerException npe) {
            System.out.println();
        }
        try {
            if (!b) {
                MenuItemObject mio = (MenuItemObject)this.hashMenu.get(key);
                mio.setConfigurationData(pstring);
                b = true;
            }
        }
        catch (NullPointerException npe) {
            System.out.println();
        }
        return b;
    }

    @Override
    public boolean buildPeripheralMenu(Menu root, int type, String pstring) {
        try {
            String str = pstring.trim();
            if (str.startsWith("#")) {
                return false;
            }
            this.pmenu[0] = this.xmlAttr.parseTagAttribute("Item", str);
            this.pmenu[1] = this.xmlAttr.parseTagAttribute("Name", str);
            this.pmenu[2] = "" + type;
            switch (type) {
                case 1: {
                    if (this.pmenu[0].equals("1")) {
                        this.serverMenu.clear();
                        if (root.getItemCount() > 0) {
                            root.removeAll();
                        }
                    }
                    this.serverMenu.put(this.pmenu[1], new PeripheralMenuObject(this.gui, root, this.pmenu, str));
                    break;
                }
                case 2: {
                    if (this.pmenu[0].equals("1")) {
                        this.printerMenu.clear();
                        if (root.getItemCount() > 0) {
                            root.removeAll();
                        }
                    }
                    this.printerMenu.put(this.pmenu[1], new PeripheralMenuObject(this.gui, root, this.pmenu, str));
                }
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String getServerConfiguration(String key) {
        String str = "";
        try {
            PeripheralMenuObject pmo = (PeripheralMenuObject)this.serverMenu.get(key);
            str = pmo.getConfigurationData();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return str;
    }

    @Override
    public boolean setServerConfiguration(String key, String pstring) {
        boolean b = false;
        try {
            String str = pstring.trim();
            if (str.startsWith("#")) {
                return false;
            }
            PeripheralMenuObject pmo = (PeripheralMenuObject)this.serverMenu.get(key);
            pmo.setConfigurationData(str);
            b = true;
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return b;
    }

    @Override
    public String getPrinterConfiguration(String key) {
        String str = "";
        try {
            PeripheralMenuObject pmo = (PeripheralMenuObject)this.printerMenu.get(key);
            str = pmo.getConfigurationData();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return str;
    }

    @Override
    public boolean setPrinterConfiguration(String key, String pstring) {
        boolean b = false;
        try {
            PeripheralMenuObject pmo = (PeripheralMenuObject)this.printerMenu.get(key);
            pmo.setConfigurationData(pstring);
            b = true;
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return b;
    }
}

