/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtSettings;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RecordSet {
    protected ArrayList records = new ArrayList();
    protected ArrayList filters = new ArrayList();
    public String name;
    public long byte_size;
    private int char_byte_size;

    public RecordSet() {
    }

    public RecordSet(XmlNode raw_recordset) {
        this.setRecordSet(raw_recordset);
    }

    protected void setRecordSet(XmlNode raw_recordset) {
        ArrayList record_nodes = raw_recordset.children;
        for (int i = 0; i < record_nodes.size(); ++i) {
            XmlNode record_node = (XmlNode)record_nodes.get(i);
            Map record_map = record_node.attributes;
            for (Map.Entry entry : record_map.entrySet()) {
                this.byte_size += (long)((entry.getKey().toString().length() + entry.getValue().toString().length()) * this.getChar_byte_size());
            }
            this.records.add(record_map);
        }
    }

    public void addFilter(String filter_column, String filter_value) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put(filter_column, filter_value);
        this.filters.add(filter);
    }

    public List getList(String column_name) {
        if (!this.filters.isEmpty()) {
            return this.getFilteredList(column_name);
        }
        ArrayList queryResult = new ArrayList();
        for (int i = 0; i < this.records.size(); ++i) {
            Map record = (Map)this.records.get(i);
            if (queryResult.contains(record.get(column_name))) continue;
            queryResult.add(record.get(column_name));
        }
        return queryResult;
    }

    private List getFilteredList(String column_name) {
        ArrayList queryResult = new ArrayList();
        for (int i = 0; i < this.records.size(); ++i) {
            Map record = (Map)this.records.get(i);
            if (!this.testRecord(record) || queryResult.contains(record.get(column_name))) continue;
            queryResult.add(record.get(column_name));
        }
        return queryResult;
    }

    public void clearFilters() {
        this.filters.clear();
    }

    private boolean testRecord(Map record) {
        for (int j = 0; j < this.filters.size(); ++j) {
            Map.Entry filter = ((Map)this.filters.get(j)).entrySet().iterator().next();
            String filterKey = filter.getKey().toString();
            String filterValue = filter.getValue().toString();
            if (record.containsKey(filterKey) && ((String)record.get(filterKey)).equals(filterValue)) continue;
            return false;
        }
        return true;
    }

    public int getChar_byte_size() {
        if (this.char_byte_size < 1) {
            PdtSettings.getInstance();
            Properties settings = PdtSettings.getSettings();
            String str_char_byte_size = (String)settings.get("char_byte_size");
            this.char_byte_size = str_char_byte_size != null ? Integer.parseInt(str_char_byte_size) : 10;
        }
        return this.char_byte_size;
    }
}

