/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.EventArgs;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PLugin;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtSettings;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;

public class PluginManager
implements Observer {
    public static final int SCOPE_SCREEN = 5;
    public static final int SCOPE_FUNCTIONAL_AREA = 4;
    public static final int SCOPE_PROGRAM = 3;
    public static final int SCOPE_PROGRAM_FUNCTION = 2;
    public static final int SCOPE_FORM = 1;
    public static final PluginManager instance = new PluginManager();
    public ArrayList screen_plugins = new ArrayList();
    public ArrayList workspace_plugins = new ArrayList();

    public PluginManager() {
        PdtWorkSpace.trace("......... contstructing PluginManager...........");
        Event.instance.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        EventArgs arguments = (EventArgs)((Object)o);
        this.managePlugins(arguments.getEventType());
        if (this.workspace_plugins != null) {
            for (int i = 0; i < this.workspace_plugins.size(); ++i) {
                HashMap plugin = (HashMap)this.workspace_plugins.get(i);
                PLugin pluginInstance = (PLugin)plugin.get("plugin");
                pluginInstance.systemEvent(arguments.getEventSource(), arguments.getEventData(), arguments.getEventType());
            }
        }
    }

    public int getScopeAsInt(String scope) {
        if (scope.equals("screen")) {
            return 5;
        }
        if (scope.equals("functional_area")) {
            return 4;
        }
        if (scope.equals("program")) {
            return 3;
        }
        if (scope.equals("function")) {
            return 2;
        }
        if (scope.equals("form")) {
            return 1;
        }
        return -1;
    }

    private PLugin loadPlugin(String class_name) {
        try {
            PdtSettings.getInstance();
            Properties settings = PdtSettings.getSettings();
            String plugins_dir = settings.getProperty("plugins_dir");
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("http://192.168.10.191:8080/PDTSimulator/PDT_Plugins/")});
            Class<?> c = loader.loadClass("Test3");
            PLugin plugin = (PLugin)c.newInstance();
            return plugin;
        }
        catch (NullPointerException npe) {
            throw new Error("Error while trying to load plugin ... " + npe);
        }
        catch (InstantiationException instex) {
            throw new Error("Error while trying to load plugin ... " + instex);
        }
        catch (Exception clnfe) {
            throw new Error("Error while trying to load plugin ... " + clnfe);
        }
    }

    public void setPlugin(XmlNode pluginConfig) {
        String pluginClassName = (String)pluginConfig.attributes.get("class_name");
        if (pluginClassName != null && !pluginClassName.trim().equals("")) {
            String pluginType = (String)pluginConfig.attributes.get("plugin_type");
            PLugin pluginInstance = this.loadPlugin(pluginClassName);
            HashMap<String, Object> plugin = new HashMap<String, Object>();
            plugin.put("config", pluginConfig);
            plugin.put("plugin", pluginInstance);
            if (pluginType.equals("screen")) {
                this.screen_plugins.add(plugin);
            } else if (pluginType.equals("workspace")) {
                this.workspace_plugins.add(plugin);
            } else {
                throw new UnsupportedOperationException("Error in setting a plugin ... PluginType = " + pluginType.toString() + " is not supported");
            }
        }
    }

    public void expirePlugins(int currentScope) {
        ArrayList workSpacePlugins = PluginManager.instance.workspace_plugins;
        for (int i = 0; i < workSpacePlugins.size(); ++i) {
            HashMap plugin = (HashMap)workSpacePlugins.get(i);
            String life_cycle = (String)((XmlNode)plugin.get((Object)"config")).attributes.get("life_cycle");
            if (this.getScopeAsInt(life_cycle) > currentScope) continue;
            workSpacePlugins.remove(plugin);
        }
    }

    public void managePlugins(int eventType) {
        if (instance != null && PluginManager.instance.workspace_plugins != null) {
            if (eventType == 17) {
                this.expirePlugins(4);
            } else if (eventType == 18) {
                this.expirePlugins(3);
            } else if (eventType == 19) {
                this.expirePlugins(2);
            } else if (eventType == 10) {
                this.expirePlugins(1);
            }
        }
    }
}

