/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.EventArgs;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.MessagePanel;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Overridable;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtControl;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtControlFactory;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtDropDown;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtHelper;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtScreen;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtTextBox;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PluginManager;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.WorkSpaceDimensions;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.WorkspaceHeader;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class PdtWorkSpace
extends ScrollPane
implements Overridable,
Observer {
    public static final int TRANSACTION_TRIGGER_BTN1_CLICKED = 4;
    public static final int TRANSACTION_TRIGGER_BTN2_CLICKED = 5;
    public static final int TRANSACTION_TRIGGER_BTN3_CLICKED = 6;
    public static final int TRANSACTION_TRIGGER_FORM_SUBMIT = 1;
    public static final int TRANSACTION_TRIGGER_MENU_CLICK = 0;
    public static final int TRANSACTION_TRIGGER_MENU_CANCEL = 7;
    public static final int TRANSACTION_TRIGGER_MENU_UNDO = 9;
    public static final int TRANSACTION_TRIGGER_MENU_REFRESH = 8;
    public static final int TRANSACTION_TRIGGER_MENU_SAVE_PROCESS = 12;
    public static final int TRANSACTION_TRIGGER_MENU_LOAD_PROCESS = 11;
    public static final int TRANSACTION_TRIGGER_MENU_REDO = 13;
    public static final int TRANSACTION_TRIGGER_MENU_EXIT_PROCESS = 14;
    public static final int TRANSACTION_TRIGGER_CONTROL_VALUE_REPLACE = 15;
    public Panel panel;
    public XmlNode workspace_config;
    public ArrayList controls;
    public static PdtWorkSpace instance = new PdtWorkSpace();
    private PdtControl active_control;
    private PdtTextBox active_text_box;
    private boolean action_cancelled = false;
    public int widest_label;
    private Properties settings;
    public static String HARDWARE_PLATFORM = null;
    public boolean switch_trace;
    private boolean busy = false;

    public PdtWorkSpace() {
        this.setBackground(new Color(246, 246, 236));
        this.panel = new Panel();
        GridBagLayout PdtWorkSpaceContentGridBag = new GridBagLayout();
        int[] PdtWorkSpaceContentGridBagColumnsWidths = new int[]{10};
        int[] PdtWorkSpaceContentGridBagRowHeights = new int[]{};
        PdtWorkSpaceContentGridBag.columnWidths = PdtWorkSpaceContentGridBagColumnsWidths;
        PdtWorkSpaceContentGridBag.rowHeights = PdtWorkSpaceContentGridBagRowHeights;
        this.panel.setLayout(PdtWorkSpaceContentGridBag);
        this.add(this.panel);
    }

    public void addComponent(PdtControl control) {
        this.panel.add(control);
    }

    @Override
    public void cancel_action() {
        this.action_cancelled = true;
    }

    @Override
    public void update(Observable o, Object arg) {
        EventArgs eventArguments = (EventArgs)((Object)o);
        if (eventArguments.getEventType() == 7) {
            if (this.workspace_config != null) {
                XmlNode currentScreenControls = (XmlNode)this.workspace_config.getNodeList("controls").get(0);
                if (currentScreenControls.attributes.get("auto_submit").equals("false")) {
                    return;
                }
            }
            if (!(Gui.gui.getPdtB1().isVisible() && Gui.gui.getPdtB1().isEnabled() || Gui.gui.getPdtB2().isVisible() && Gui.gui.getPdtB2().isEnabled() || Gui.gui.getPdtB3().isVisible() && Gui.gui.getPdtB3().isEnabled())) {
                this.submitForm(1);
            }
        }
    }

    public boolean isFormInputComplete() {
        if (this.controls != null) {
            String validationErrors = "";
            for (int i = 0; i < this.controls.size(); ++i) {
                PdtControl control = (PdtControl)this.controls.get(i);
                if (control.control_config.attributes.get("is_required") == null || !((String)control.control_config.attributes.get("is_required")).equals("true")) continue;
                if (control.getValue() == null || control.getValue().trim().equals("")) {
                    validationErrors = validationErrors + control.isInputValid() + "\n";
                    control.styleValidationError();
                    continue;
                }
                control.clearValidationStyle();
            }
            if (validationErrors.equals("")) {
                MessagePanel.instance.setMessage("");
                return true;
            }
            MessagePanel.instance.setMessage(validationErrors);
            this.setMessageDialog(validationErrors);
            return false;
        }
        return false;
    }

    private void setMessageDialog(String message) {
    }

    public boolean isFormInputValid() {
        String validationErrors = "";
        for (int i = 0; i < this.controls.size(); ++i) {
            PdtControl control = (PdtControl)this.controls.get(i);
            if (control.isInputValid() != null) {
                validationErrors = validationErrors + control.isInputValid() + "\n";
                control.styleValidationError();
                continue;
            }
            control.clearValidationStyle();
        }
        if (validationErrors.equals("")) {
            return true;
        }
        MessagePanel.instance.setMessage(validationErrors);
        return false;
    }

    private void calculateWidestLabel() {
        XmlNode pdtControls = (XmlNode)this.workspace_config.getNodeList("controls").get(0);
        for (int i = 0; i < pdtControls.children.size(); ++i) {
            String labelCaption = (String)((XmlNode)pdtControls.children.get((int)i)).attributes.get("label");
            if (labelCaption == null) {
                labelCaption = (String)((XmlNode)pdtControls.children.get((int)i)).attributes.get("name");
            }
            WorkSpaceDimensions dim = WorkSpaceDimensions.getWorkSpaceDimensions();
            int controlLabelWidth = labelCaption.length() * dim.getAvgCharSize();
            if (controlLabelWidth <= this.widest_label) continue;
            this.widest_label = controlLabelWidth + dim.getLabelRightPadding();
        }
    }

    public boolean differentScreenFromPrevious(XmlNode workspace_config) {
        XmlNode newPdtControls = (XmlNode)workspace_config.getNodeList("controls").get(0);
        if (newPdtControls != null && PdtWorkSpace.instance.workspace_config != null) {
            XmlNode previousPdtControls = (XmlNode)PdtWorkSpace.instance.workspace_config.getNodeList("controls").get(0);
            if (newPdtControls.children.size() != previousPdtControls.children.size()) {
                return true;
            }
            for (int i = 0; i < newPdtControls.children.size(); ++i) {
                XmlNode newPdtControl = (XmlNode)newPdtControls.children.get(i);
                XmlNode previousPdtControl = (XmlNode)previousPdtControls.children.get(i);
                if (newPdtControl.attributes.get("name").equals(previousPdtControl.attributes.get("name")) && newPdtControl.attributes.get("type").equals(previousPdtControl.attributes.get("type"))) continue;
                return true;
            }
        }
        return false;
    }

    public void refreshScreen(XmlNode workspace_config) {
        XmlNode pdtControls = (XmlNode)workspace_config.getNodeList("controls").get(0);
        if (pdtControls != null && pdtControls.children.size() > 0) {
            for (int i = 0; i < this.controls.size(); ++i) {
                PdtControl pdtControl = (PdtControl)this.controls.get(i);
                String controlName = pdtControl.getNativeControl().getName();
                XmlNode pdtControlNode = pdtControls.getNode("controls/control[name=" + controlName + "]");
                if (pdtControl instanceof PdtTextBox && instance.getActiveTextBox() == null) {
                    instance.setActiveTextBox((PdtTextBox)pdtControl);
                }
                if (pdtControl instanceof PdtDropDown) {
                    ((PdtDropDown)pdtControl).clearValues();
                    pdtControl.setValue(pdtControlNode.attributes);
                    pdtControl.control_config.attributes = pdtControlNode.attributes;
                } else if (pdtControlNode != null && pdtControlNode.attributes.get("value") != null && !pdtControlNode.attributes.get("value").equals(pdtControl.getValue())) {
                    pdtControl.setValue(pdtControlNode.attributes.get("value"));
                } else if (pdtControl != null && pdtControlNode != null && pdtControlNode.attributes.get("value") == null || pdtControlNode == null) {
                    pdtControl.setValue("");
                }
                if (i != this.controls.size() - 1 || pdtControls.attributes.get("content_header_caption") == null || WorkspaceHeader.instance.getWorkSpaceHeaderLabel().equals(pdtControls.attributes.get("content_header_caption"))) continue;
                WorkspaceHeader.instance.setWorkSpaceHeaderLabel((String)pdtControls.attributes.get("content_header_caption"));
            }
            Event.instance.RaiseEvent(20, null, this);
        }
    }

    public void construct(XmlNode workspace_config, Panel parent) throws Exception {
        ArrayList plugins = workspace_config.getNodeList("plugin");
        try {
            for (int i = 0; i < plugins.size(); ++i) {
                XmlNode plugin = (XmlNode)plugins.get(i);
                PluginManager.instance.setPlugin(plugin);
            }
        }
        catch (Exception e) {
            System.out.println("Plugin error" + e.getMessage());
        }
        this.workspace_config = workspace_config;
        Event.instance.addObserver(this);
        Event.instance.RaiseEvent(12, null, this);
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else {
            instance.setActiveTextBox(null);
            this.calculateWidestLabel();
            XmlNode pdtControls = (XmlNode)workspace_config.getNodeList("controls").get(0);
            this.controls = new ArrayList();
            if (pdtControls.attributes.get("content_header_caption") != null) {
                WorkspaceHeader.instance.setWorkSpaceHeaderLabel((String)pdtControls.attributes.get("content_header_caption"));
            }
            if (pdtControls != null && pdtControls.children.size() > 0) {
                HashMap<String, String> temp = new HashMap<String, String>();
                for (int i = 0; i < pdtControls.children.size(); ++i) {
                    String controlName;
                    XmlNode pdtControlNode = (XmlNode)pdtControls.children.get(i);
                    PdtControl pdtControl = PdtControlFactory.createControl(pdtControlNode);
                    if (!this.isUniqueControl(pdtControl, controlName = (String)pdtControlNode.attributes.get("name"), temp)) {
                        throw new Exception("ERROR in Workspace.construct....Control,name=" + controlName + " is not unique");
                    }
                    temp.put(controlName, String.valueOf(pdtControl.isInputControl()));
                    this.controls.add(pdtControl);
                }
                if (pdtControls.children.size() < 13) {
                    int emptyLines = 13 - pdtControls.children.size();
                    PdtControlFactory.addBottomPadding(emptyLines);
                }
            }
            Event.instance.RaiseEvent(20, null, this);
            parent.setLayout((LayoutManager)new AbsoluteLayout());
            parent.add((Component)this, new AbsoluteConstraints(0, 0, Gui.gui.getWidth(), Gui.gui.getHeight()));
            Gui.gui.pack();
            if (this.active_text_box != null) {
                this.active_text_box.setFocus();
            }
        }
    }

    private boolean isUniqueControl(PdtControl control, String controlName, HashMap temp) {
        if (control.isInputControl() && temp.containsKey(controlName)) {
            return false;
        }
        return control.isInputControl() || !temp.containsKey(controlName) || !((String)temp.get(controlName)).equals("true");
    }

    public void submitForm(int transaction_trigger) {
        Event.instance.RaiseEvent(10, null, this);
        PdtScreen.instance.resetPdtMonitor();
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else if (this.isFormInputComplete() && this.isFormInputValid() && this.workspace_config != null) {
            this.updateXml();
            String xml_state = this.workspace_config.toXml();
            try {
                PdtHelper.instance.serverTransaction(xml_state, transaction_trigger);
            }
            catch (Exception ekse) {
                throw new Error("Error while submitting form .... " + ekse.getMessage());
            }
        }
    }

    private void updateXml() {
        for (int i = 0; i < this.controls.size(); ++i) {
            PdtControl control = (PdtControl)this.controls.get(i);
            control.updateXml();
        }
    }

    public PdtTextBox getActiveTextBox() {
        return this.active_text_box;
    }

    public void setActiveTextBox(PdtTextBox active_text_box) {
        this.active_text_box = active_text_box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanReceived(String scanCode) {
        try {
            if (this.busy) {
                return;
            }
            this.busy = true;
            if (this.active_text_box != null && this.controls.size() > 0) {
                ((TextField)this.active_text_box.getNativeControl()).setText(scanCode);
                instance.nextInputControl(this.active_text_box);
                this.active_text_box.valueEntered();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.busy = false;
        }
    }

    public boolean nextInputControl(PdtControl currentControl) {
        int nextControlIndex = PdtWorkSpace.instance.controls.indexOf(currentControl) + 1;
        if (nextControlIndex < PdtWorkSpace.instance.controls.size()) {
            PdtControl nextControl = (PdtControl)PdtWorkSpace.instance.controls.get(nextControlIndex);
            if (!nextControl.isInputControl()) {
                boolean next = this.nextInputControl(nextControl);
                return next;
            }
            nextControl.setFocus();
            return true;
        }
        return false;
    }

    public boolean previousInputControl(PdtControl currentControl) {
        int previousControlIndex = PdtWorkSpace.instance.controls.indexOf(currentControl) - 1;
        if (previousControlIndex >= 0) {
            PdtControl nextControl = (PdtControl)PdtWorkSpace.instance.controls.get(previousControlIndex);
            if (!nextControl.isInputControl()) {
                boolean prev = this.previousInputControl(nextControl);
                return prev;
            }
            nextControl.setFocus();
            return true;
        }
        Event.instance.RaiseEvent(21, this, null);
        return false;
    }

    public PdtControl getActiveControl() {
        return this.active_control;
    }

    public void setActiveControl(PdtControl active_control) {
        this.active_control = active_control;
    }

    public static void trace(String message) {
        if (PdtWorkSpace.instance.switch_trace) {
            System.out.println("trace : " + message);
        }
    }
}

