/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtControl;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.WorkSpaceDimensions;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Component;
import java.awt.TextField;
import java.util.StringTokenizer;

public class PdtTextBox
extends PdtControl {
    private TextField text_box;

    public PdtTextBox(XmlNode control_config) {
        super(control_config);
    }

    @Override
    public String getValue() {
        String value = this.text_box.getText();
        if (this.control_config.attributes.get("remove_left") != null && !((String)this.control_config.attributes.get("remove_left")).trim().equals("")) {
            int leftChopValue = Integer.parseInt((String)this.control_config.attributes.get("remove_left"));
            if (value.length() > 0 && value.length() > leftChopValue) {
                value = value.substring(leftChopValue, value.length());
            }
        }
        if (this.control_config.attributes.get("remove_right") != null && !((String)this.control_config.attributes.get("remove_right")).trim().equals("")) {
            int rightChopValue = Integer.parseInt((String)this.control_config.attributes.get("remove_right"));
            if (value.length() > rightChopValue) {
                value = value.substring(0, value.length() - rightChopValue);
            }
        }
        return value;
    }

    @Override
    public void setValue(Object input) {
        this.text_box.setText((String)input);
    }

    @Override
    public void buildSpecificControl() {
        if (this.control_config.attributes.get("name") != null && !((String)this.control_config.attributes.get("name")).trim().equals("")) {
            this.text_box = new TextField(WorkSpaceDimensions.getWorkSpaceDimensions().getTextBoxWidth());
            this.text_box.setName((String)this.control_config.attributes.get("name"));
            if (this.control_config.attributes.get("value") != null) {
                this.setValue(this.control_config.attributes.get("value"));
            }
            if (this.control_config.attributes.get("scan_only") != null && this.control_config.attributes.get("scan_only").equals("true")) {
                this.text_box.setEditable(false);
            }
        } else {
            throw new Error("Error while creating control .... control doesn't have a name.");
        }
        this.text_box.addFocusListener(this);
        this.text_box.addKeyListener(this);
        this.drawControl();
    }

    @Override
    public String isInputValid() {
        if (super.isInputValid() != null) {
            return super.isInputValid();
        }
        String validationErrorStackTrace = "";
        String requiredLengthValidationErrorStackTrace = "";
        String requiredTypeValidationErrorStackTrace = "";
        String value = this.getValue();
        if (this.control_config.attributes.get("required_length") != null) {
            StringTokenizer tokenHeizer = new StringTokenizer((String)this.control_config.attributes.get("required_length"), ",");
            while (tokenHeizer.hasMoreTokens()) {
                String length = tokenHeizer.nextToken();
                if (value.length() == Integer.parseInt(length)) {
                    requiredLengthValidationErrorStackTrace = "";
                    break;
                }
                if (tokenHeizer.hasMoreTokens()) {
                    requiredLengthValidationErrorStackTrace = requiredLengthValidationErrorStackTrace + this.getNativeControl().getName() + " : value must be of length " + length + " OR\n";
                    continue;
                }
                requiredLengthValidationErrorStackTrace = requiredLengthValidationErrorStackTrace + this.getNativeControl().getName() + " : value must be of length " + length;
            }
        }
        if (this.control_config.attributes.get("required_type") != null && !((String)this.control_config.attributes.get("required_type")).equals("")) {
            requiredTypeValidationErrorStackTrace = "";
            if (((String)this.control_config.attributes.get("required_type")).equals("number")) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    requiredTypeValidationErrorStackTrace = requiredTypeValidationErrorStackTrace + this.getNativeControl().getName() + " : must be a number.";
                }
            } else if (((String)this.control_config.attributes.get("required_type")).equals("decimal")) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    requiredTypeValidationErrorStackTrace = requiredTypeValidationErrorStackTrace + this.getNativeControl().getName() + " : must be a decimal number.";
                }
            }
        }
        validationErrorStackTrace = validationErrorStackTrace + requiredLengthValidationErrorStackTrace;
        if ((validationErrorStackTrace = validationErrorStackTrace + requiredTypeValidationErrorStackTrace).trim().equals("")) {
            return null;
        }
        return validationErrorStackTrace;
    }

    @Override
    public Component getNativeControl() {
        return this.text_box;
    }

    @Override
    public boolean isInputControl() {
        return true;
    }
}

