/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.MessagePanel;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtHelper;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtProgressBar;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtSettings;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.xml.DomBuilder;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Frame;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PdtServerProxy {
    public static XmlNode transaction(int mode, String transaction_type, String user, String ip, String workspace_xml) {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("mode", "" + mode);
        hash.put("trans_type", transaction_type);
        hash.put("user", user);
        hash.put("ip", ip);
        hash.put("input", workspace_xml);
        XmlNode result = PdtServerProxy.call("services/pdt", "handle_request", hash);
        return result;
    }

    public static XmlNode call(String controller, String method, Map params) {
        String url_string = "";
        GuiInterface f = Gui.gui;
        PdtProgressBar progresBar = new PdtProgressBar((Frame)((Object)f), "processing request");
        try {
            PdtSettings.getInstance();
            Properties settings = PdtSettings.getSettings();
            String base_url = (String)settings.get("pdt_server");
            if (base_url == null) {
                return MessagePanel.returnErrorScreen(progresBar, "Pdt Server not specified. Please set server and restart.");
            }
            url_string = base_url + "/" + controller + "/" + method;
            String request_params = "?";
            for (Map.Entry entry : params.entrySet()) {
                if (entry.getKey().toString().equals("input")) {
                    request_params = request_params + entry.getKey().toString() + "=" + PdtServerProxy.encodeUrl(entry.getValue().toString()) + "&";
                    continue;
                }
                request_params = request_params + entry.getKey().toString() + "=" + entry.getValue().toString() + "&";
            }
            url_string = url_string + request_params.substring(0, request_params.length() - 1);
            PdtWorkSpace.trace("Call to server = " + url_string);
            URL url = new URL(url_string);
            if (controller.equals("services/pdt_data_service") || params.get("mode") == null || !params.get("mode").equals("15")) {
                // empty if block
            }
            InputStream instream = url.openStream();
            progresBar.dispose();
            XmlNode result = DomBuilder.loadDom(instream);
            PdtWorkSpace.trace("Screen Def from Rails = " + result.toXml(0, ""));
            ArrayList screenControls = result.getNodeList("controls");
            if (screenControls.size() > 0) {
                XmlNode controls = (XmlNode)screenControls.get(0);
                String current_menu_leaf_value = (String)controls.attributes.get("current_menu_item");
                if (current_menu_leaf_value != null && !current_menu_leaf_value.trim().equals("")) {
                    PdtHelper.instance.current_menu_leaf_value = current_menu_leaf_value;
                }
            }
            return result;
        }
        catch (ConnectException cone) {
            return MessagePanel.returnErrorScreen(progresBar, cone);
        }
        catch (Exception e) {
            return MessagePanel.returnErrorScreen(progresBar, e);
        }
    }

    private static String encodeUrl(String raw_url) throws UnsupportedEncodingException {
        String defaultEncoding = System.getProperty("file.encoding");
        System.setProperty("file.encoding", "UTF-8");
        String encodedurl = URLEncoder.encode(raw_url);
        System.setProperty("file.encoding", defaultEncoding);
        return encodedurl;
    }
}

