/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Cache;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Overridable;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtFooter;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtHeader;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtHelper;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtServerProxy;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtUserLogout;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PluginManager;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.RecordSet;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class PdtScreen
extends Panel
implements Observer,
Overridable {
    public String logged_on_user;
    public String ip;
    public PdtHeader pdt_header;
    public PdtFooter footer;
    public PdtWorkSpace work_space;
    public PluginManager plugin_manager;
    public XmlNode screen_config;
    public static final PdtScreen instance = new PdtScreen();
    public Label workspace_title;
    public Label progress_bar;
    private boolean action_cancelled;
    private Properties settings;
    public Date pdtMonitor;

    public void construct(XmlNode screen_config) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            System.err.println("Error occured while getting Client IP address  .... " + uhe);
        }
        this.screen_config = screen_config;
        this.plugin_manager = PluginManager.instance;
        Event.instance.addObserver(this.plugin_manager);
        XmlNode plugin = screen_config.getNode("ConfigurationRecords/plugin");
        if (plugin != null) {
            this.plugin_manager.setPlugin(plugin);
        }
        Event.instance.RaiseEvent(15, null, this);
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else {
            GridBagLayout pdtScreenGridbag = new GridBagLayout();
            int[] columns_widths = new int[]{300};
            int[] row_heigths = new int[]{10, 5, 320, 100};
            pdtScreenGridbag.columnWidths = columns_widths;
            pdtScreenGridbag.rowHeights = row_heigths;
            this.setLayout(pdtScreenGridbag);
            this.pdt_header = new PdtHeader();
            this.pdt_header.construct(screen_config);
            GridBagConstraints content_header_caption_con = new GridBagConstraints();
            content_header_caption_con.fill = 1;
            content_header_caption_con.insets = new Insets(5, 0, 0, 0);
            content_header_caption_con.gridwidth = 0;
            GridBagLayout contentHeadeCaptionGridbag = new GridBagLayout();
            int[] contentHeadeCaptionGridbagColumnsWidths = new int[]{250, 50};
            int[] contentHeadeCaptionGridbagRowHeigths = new int[]{5};
            contentHeadeCaptionGridbag.columnWidths = contentHeadeCaptionGridbagColumnsWidths;
            contentHeadeCaptionGridbag.rowHeights = contentHeadeCaptionGridbagRowHeigths;
            Panel contentHeadeCaption = new Panel(contentHeadeCaptionGridbag);
            GridBagConstraints contentHeadeCaptionCon = new GridBagConstraints();
            contentHeadeCaptionCon.fill = 1;
            contentHeadeCaptionCon.insets = new Insets(0, 0, 0, 0);
            this.workspace_title = new Label("");
            this.workspace_title.setBackground(new Color(152, 156, 158));
            this.workspace_title.setVisible(false);
            contentHeadeCaption.add((Component)this.workspace_title, contentHeadeCaptionCon);
            this.progress_bar = new Label();
            this.progress_bar.setBackground(new Color(152, 156, 158));
            this.progress_bar.setFont(new Font("Arial", 1, 12));
            this.progress_bar.setVisible(false);
            contentHeadeCaption.add((Component)this.progress_bar, contentHeadeCaptionCon);
            this.add((Component)contentHeadeCaption, content_header_caption_con);
            GridBagConstraints emptyWorkspacePanel_con = new GridBagConstraints();
            emptyWorkspacePanel_con.gridwidth = 0;
            emptyWorkspacePanel_con.fill = 1;
            this.work_space = PdtWorkSpace.instance;
            this.work_space.setVisible(false);
            this.add((Component)this.work_space, emptyWorkspacePanel_con);
            ArrayList buttonsList = screen_config.getNodeList("ConfigurationRecords/Buttons");
            XmlNode buttons = (XmlNode)buttonsList.get(0);
            this.footer = new PdtFooter();
            this.footer.construct(buttons);
            this.footer.setVisible(false);
            Event.instance.RaiseEvent(16, null, this);
        }
    }

    public void serverTransaction(String xml_state, int mode) throws Exception {
    }

    public void setWorkSpaceTitle(String title) {
        this.workspace_title.setText(title);
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public void cancel_action() {
        this.action_cancelled = true;
    }

    public RecordSet getRecordSet(String data_service_name, Map params) {
        RecordSet resultRecordSet;
        if (Cache.instance.getCached_recordsets().containsKey(data_service_name)) {
            resultRecordSet = (RecordSet)Cache.instance.getCached_recordsets().get(data_service_name);
        } else {
            XmlNode workspaceDefinition = PdtServerProxy.call("services/pdt_data_service", data_service_name, params);
            resultRecordSet = new RecordSet(workspaceDefinition);
            Cache.instance.addRecordSet(data_service_name, resultRecordSet);
        }
        return resultRecordSet;
    }

    public Properties getSettings() {
        try {
            if (this.settings == null) {
                this.settings = new Properties();
                URL properties_url = new URL("http://192.168.10.191:8080/PDTSimulator/pdt_server_settings.properties");
                URLConnection urlConn = properties_url.openConnection();
                urlConn.setConnectTimeout(10000);
                urlConn.setReadTimeout(10000);
                InputStream pdt_sever_settings_file = urlConn.getInputStream();
                this.settings.load(pdt_sever_settings_file);
            }
            return this.settings;
        }
        catch (Exception e) {
            System.err.println("Error.  = " + e);
            return null;
        }
    }

    public void resetPdtMonitor() {
        PdtHelper.lmm.getSecurityHandle().resetLoginTimeout();
    }

    public static void timeUserActivity() {
        instance.resetPdtMonitor();
        PdtUserLogout task = new PdtUserLogout();
        Timer timer = new Timer();
        timer.schedule((TimerTask)task, 0L, 1000L);
    }
}

