/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.GuiInterface;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Cache;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.EventArgs;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.MessagePanel;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtScreen;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtServerProxy;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtSettings;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.WorkspaceHeader;
import com.nosoft.mobile.mes.security.Security;
import com.nosoft.mobile.mes.util.MwString;
import com.nosoft.mobile.mes.xml.DomBuilder;
import com.nosoft.mobile.mes.xml.XmlNode;
import com.nosoft.mobile.sys.SysInterface;
import java.awt.Button;
import java.awt.MenuBar;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;

public class PdtHelper
implements Observer {
    public static GuiInterface gui = null;
    public static SysInterface lmm = null;
    public static Security sec = null;
    private static String[] current_menu_position = null;
    public String current_menu_leaf_value;
    public String logged_on_user;
    public String password;
    public String ip;
    public static String sIp;
    public static PdtHelper instance;
    private static String platform;
    public static String ipWebServer;
    public static String ipMesServer;
    public static String printerName;
    public static String printerIP;
    public static int printerPort;

    public PdtHelper() {
        gui = Gui.gui;
        lmm = gui.getSysHandle();
        sec = lmm.getSecurityHandle();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            sIp = this.ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            System.err.println("Error occured while getting Client IP address  .... " + uhe);
        }
        Event.instance.addObserver(this);
    }

    public static synchronized void setGui(GuiInterface guiHandle) {
        gui = guiHandle;
    }

    public static synchronized void setDefaultPrinter(String name, String ip, int port) {
        printerName = name;
        printerIP = ip;
        printerPort = port;
        System.out.println("Default printer=" + printerName + " IP=" + printerIP + " Port=" + printerPort);
    }

    public static String getDefaultPrinterName() {
        return printerName;
    }

    public static String getDefaultPrinterIP() {
        return printerIP;
    }

    public static int getDefaultPrinterPort() {
        return printerPort;
    }

    public static synchronized void setPlatform(String name) {
        PdtWorkSpace.HARDWARE_PLATFORM = platform = name;
    }

    public static synchronized void setIpMesServer(String string) {
        ipMesServer = string;
    }

    public static synchronized void setIpWebServer(String string) {
        ipWebServer = string;
    }

    public static String getPlatform() {
        return platform;
    }

    public synchronized void enableMenus() {
        MenuBar mb = Gui.gui.getMenuBar();
        int tot = mb.getMenuCount();
    }

    public synchronized void disableMenus() {
        MenuBar mb = Gui.gui.getMenuBar();
        int tot = mb.getMenuCount();
    }

    public synchronized void remoteLogin(String user, String password) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("pwd", password);
        XmlNode noddy = PdtServerProxy.call("services/authentication", "authenticate", params);
        if (noddy != null) {
            XmlNode requiredNode;
            ArrayList searchResult = noddy.getNodeList("authenticated");
            if (!searchResult.isEmpty()) {
                requiredNode = (XmlNode)searchResult.get(0);
            } else {
                searchResult = noddy.getNodeList("error");
                requiredNode = (XmlNode)searchResult.get(0);
            }
            String authenticated = requiredNode.text;
            if (authenticated.equals("1")) {
                this.logged_in(user, password);
            } else if (authenticated.equals("0")) {
                this.logInFailure();
            }
        }
    }

    public static synchronized void traceOnForDeviceRefresh() {
        PdtSettings.resetInstance();
        PdtWorkSpace.instance.switch_trace = PdtHelper.traceOnForDevice(sIp);
    }

    public static synchronized boolean traceOnForDevice(String ip) {
        PdtSettings.getInstance();
        Properties settings = PdtSettings.getSettings();
        String device_ip_list = (String)settings.get("trace_on");
        if (device_ip_list == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(device_ip_list, ",");
        while (tokenizer.hasMoreTokens()) {
            String device_ip = tokenizer.nextToken();
            if (!device_ip.equals(PdtHelper.instance.ip)) continue;
            return true;
        }
        return false;
    }

    public synchronized void logged_in(String user, String password) {
        String screen = "";
        this.clearScreen();
        PdtHelper.instance.logged_on_user = user;
        PdtHelper.instance.password = password;
        PdtWorkSpace.instance.switch_trace = PdtHelper.traceOnForDevice(this.ip);
        if (sec != null) {
            sec.setLoggedOnUser(user);
            sec.setPassword(password);
        }
        screen = screen + "<PDTRF Status='true' B3Label='Clear' B2Label='Cancel' B1Label='Submit' B1Enable='false' Msg='' B2Enable='false' B3Enable='false' >";
        screen = screen + "<controls auto_submit='false' content_header_caption='' >";
        screen = screen + "<control name='output' type='static_text' label='User' value='" + PdtHelper.instance.logged_on_user + "' ></control>";
        screen = screen + "<control name='output' type='static_text' label='is now' value='logged in' ></control>";
        screen = screen + "</controls>";
        screen = screen + "</PDTRF>";
        this.enableMenus();
        try {
            ByteArrayInputStream instream = new ByteArrayInputStream(screen.getBytes());
            XmlNode pdtRF = DomBuilder.loadDom(instream);
            PdtWorkSpace.instance.construct(pdtRF, Gui.gui.getPanelWorkspace());
            MessagePanel.instance.setMessage(pdtRF.toXml(1, ""));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public synchronized void logInFailure() {
        MessagePanel.instance.setMessage("Login Error : Invalid user/password combination ");
    }

    public synchronized void serverTransaction(String xml_state, int mode) throws Exception {
        PdtWorkSpace.instance.setActiveTextBox(null);
        XmlNode pdtRF = PdtServerProxy.transaction(mode, this.current_menu_leaf_value, this.logged_on_user, this.ip, xml_state);
        String cache_screen_attr = (String)((XmlNode)pdtRF.getNodeList((String)"controls").get((int)0)).attributes.get("cache_screen");
        if (!PdtWorkSpace.instance.differentScreenFromPrevious(pdtRF) && cache_screen_attr != null && cache_screen_attr.equals("true") && (mode == 1 || mode == 4 || mode == 5 || mode == 6) && mode != 7 && mode != 14 && mode != 11 && mode != 13 && mode != 8 && mode != 12 && mode != 9) {
            PdtWorkSpace.instance.refreshScreen(pdtRF);
        } else {
            PdtWorkSpace.instance.panel.removeAll();
            PdtWorkSpace.instance.widest_label = 0;
            try {
                PdtWorkSpace.instance.construct(pdtRF, Gui.gui.getPanelWorkspace());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            Button button1 = Gui.gui.getPdtB1();
            Button button2 = Gui.gui.getPdtB2();
            Button button3 = Gui.gui.getPdtB3();
            button1.setEnabled(true);
            button2.setEnabled(true);
            button3.setEnabled(true);
            boolean invisibleButtons = false;
            if ((String)pdtRF.attributes.get("B1Label") != null) {
                button1.setLabel((String)pdtRF.attributes.get("B1Label"));
                if (pdtRF.attributes.get("B1Enable") != null && pdtRF.attributes.get("B1Enable").equals("false") || pdtRF.attributes.get("B1Enable") == null) {
                    button1.setVisible(false);
                    button1.setEnabled(false);
                } else {
                    button1.setVisible(true);
                    button1.setEnabled(true);
                }
            } else {
                button1.setVisible(false);
                button1.setEnabled(false);
            }
            if ((String)pdtRF.attributes.get("B2Label") != null) {
                button2.setLabel((String)pdtRF.attributes.get("B2Label"));
                if (pdtRF.attributes.get("B2Enable") != null && pdtRF.attributes.get("B2Enable").equals("false") || pdtRF.attributes.get("B2Enable") == null) {
                    button2.setVisible(false);
                    button2.setEnabled(false);
                } else {
                    button2.setVisible(true);
                    button2.setEnabled(true);
                }
            } else {
                button2.setVisible(false);
                button2.setEnabled(false);
            }
            if ((String)pdtRF.attributes.get("B3Label") != null) {
                button3.setLabel((String)pdtRF.attributes.get("B3Label"));
                if (pdtRF.attributes.get("B3Enable") != null && pdtRF.attributes.get("B3Enable").equals("false") || pdtRF.attributes.get("B3Enable") == null) {
                    button3.setVisible(false);
                    button3.setEnabled(false);
                } else {
                    button3.setVisible(true);
                    button3.setEnabled(true);
                }
            } else {
                button3.setVisible(false);
                button3.setEnabled(false);
            }
            Gui.gui.getPanelWorkspace().paintAll(Gui.gui.getGraphics());
        }
        if (cache_screen_attr != null && cache_screen_attr.equals("true")) {
            this.showButtonsOnCachedScreen(pdtRF);
        }
    }

    private void showButtonsOnCachedScreen(XmlNode resultScreen) {
        Button button1 = Gui.gui.getPdtB1();
        Button button2 = Gui.gui.getPdtB2();
        Button button3 = Gui.gui.getPdtB3();
        button1.setEnabled(new Boolean(resultScreen.attributes.get("B1Enable") + ""));
        button2.setEnabled(new Boolean(resultScreen.attributes.get("B2Enable") + ""));
        button3.setEnabled(new Boolean(resultScreen.attributes.get("B3Enable") + ""));
        boolean refreshButtons = false;
        if (resultScreen.attributes.get("B1Enable") != null && resultScreen.attributes.get("B1Label") != null && !button1.isVisible() && resultScreen.attributes.get("B1Enable").equals("true") || !resultScreen.attributes.get("B1Label").equals(button1.getLabel())) {
            refreshButtons = true;
            button1.setLabel(resultScreen.attributes.get("B1Label").toString());
            if (resultScreen.attributes.get("B1Submit") != null && !resultScreen.attributes.get("B1Submit").equals(PdtWorkSpace.instance.workspace_config.attributes.get("B1Submit"))) {
                PdtWorkSpace.instance.workspace_config.attributes.put("B1Submit", resultScreen.attributes.get("B1Submit"));
            }
        }
        if (resultScreen.attributes.get("B2Submit") != null && resultScreen.attributes.get("B2Enable") != null && resultScreen.attributes.get("B2Label") != null && (resultScreen.attributes.get("B2Submit") != null && !button2.isVisible() && resultScreen.attributes.get("B2Enable").equals("true") || !resultScreen.attributes.get("B2Label").equals(button2.getLabel()))) {
            refreshButtons = true;
            button2.setLabel(resultScreen.attributes.get("B2Label").toString());
            if (!resultScreen.attributes.get("B2Submit").equals(PdtWorkSpace.instance.workspace_config.attributes.get("B2Submit"))) {
                PdtWorkSpace.instance.workspace_config.attributes.put("B2Submit", resultScreen.attributes.get("B2Submit"));
            }
        }
        if (resultScreen.attributes.get("B3Submit") != null && resultScreen.attributes.get("B3Enable") != null && resultScreen.attributes.get("B3Label") != null && (resultScreen.attributes.get("B3Submit") != null && !button3.isVisible() && resultScreen.attributes.get("B3Enable").equals("true") || !resultScreen.attributes.get("B3Label").equals(button3.getLabel()))) {
            refreshButtons = true;
            button3.setLabel(resultScreen.attributes.get("B3Label").toString());
            if (!resultScreen.attributes.get("B3Submit").equals(PdtWorkSpace.instance.workspace_config.attributes.get("B3Submit"))) {
                PdtWorkSpace.instance.workspace_config.attributes.put("B3Submit", resultScreen.attributes.get("B3Submit"));
            }
        }
        button1.setVisible(true);
        button2.setVisible(true);
        button3.setVisible(true);
    }

    public synchronized void getScreenSpecial(String selectedCommand) throws Exception {
        PdtScreen.instance.resetPdtMonitor();
        this.current_menu_leaf_value = selectedCommand;
        String xmlState = PdtWorkSpace.instance.workspace_config == null ? "<PDTRF></PDTRF>" : PdtWorkSpace.instance.workspace_config.toXml();
        if (selectedCommand.equals("1a")) {
            this.serverTransaction(xmlState, 8);
        } else if (selectedCommand.equals("1b")) {
            this.serverTransaction(xmlState, 9);
        } else if (selectedCommand.equals("1c")) {
            this.serverTransaction(xmlState, 7);
        } else if (selectedCommand.equals("Log off")) {
            System.out.println("HOW TO HANDLE = " + selectedCommand + "   ???");
        } else if (selectedCommand.equals("1d")) {
            this.serverTransaction(xmlState, 12);
        } else if (selectedCommand.equals("1e")) {
            this.serverTransaction(xmlState, 11);
        } else if (selectedCommand.equals("1f")) {
            this.serverTransaction(xmlState, 13);
        } else if (selectedCommand.equals("1g")) {
            this.serverTransaction(xmlState, 14);
        }
    }

    public synchronized void getScreen(String key) throws Exception {
        String xmlState = PdtWorkSpace.instance.workspace_config == null ? "<PDTRF></PDTRF>" : PdtWorkSpace.instance.workspace_config.toXml();
        this.serverTransaction(xmlState, 0);
    }

    public synchronized void CalculateMenuChange(String key, String value) {
        String[] menu_depth = null;
        this.current_menu_leaf_value = key;
        try {
            this.getScreen(key);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (current_menu_position != null) {
            menu_depth = MwString.split(key.toString(), ".");
            int current_menu_depth = current_menu_position.length;
            int depth_used = 0;
            depth_used = menu_depth.length >= current_menu_depth ? current_menu_depth : menu_depth.length;
            boolean differ = false;
            for (int level_number = 1; level_number < depth_used; ++level_number) {
                if (current_menu_position[level_number].equalsIgnoreCase(menu_depth[level_number]) || differ) continue;
                differ = true;
                PdtHelper.RaiseMenuChangeEvent(level_number, value);
            }
            current_menu_position = MwString.split(key.toString(), ".");
        } else {
            current_menu_position = MwString.split(key.toString() + "", ".");
        }
    }

    public static synchronized void RaiseMenuChangeEvent(int menu_nr, String menu_selected) {
    }

    public synchronized void moveToFirstActiveButton() {
        Button button1 = Gui.gui.getPdtB1();
        Button button2 = Gui.gui.getPdtB2();
        Button button3 = Gui.gui.getPdtB3();
        if (button1.isVisible() && button1.isEnabled()) {
            button1.requestFocus();
        } else if (button2.isVisible() && button2.isEnabled()) {
            button2.requestFocus();
        } else if (button3.isVisible() && button3.isEnabled()) {
            button3.requestFocus();
        }
    }

    public synchronized int findIndex(String btn_name) {
        String[] button_names = new String[]{"button0", "button1", "button2"};
        for (int btn_nr = 0; btn_nr < button_names.length; ++btn_nr) {
            if (!button_names[btn_nr].equals(btn_name)) continue;
            return btn_nr;
        }
        return -1;
    }

    public synchronized void moveFocus(KeyEvent evt) {
        Button[] gui_button = new Button[]{Gui.gui.getPdtB1(), Gui.gui.getPdtB2(), Gui.gui.getPdtB3()};
        Button x = (Button)evt.getComponent();
        String button_name = x.getName();
        boolean searchnextbutton = true;
        boolean raiseEvent = false;
        System.out.println(evt.getKeyCode());
        int keycode = evt.getKeyCode();
        int button_index = this.findIndex(button_name);
        if (keycode == 39) {
            if (button_index + 1 < gui_button.length) {
                do {
                    if (gui_button[button_index + 1].isVisible() && gui_button[button_index + 1].isEnabled()) {
                        gui_button[button_index + 1].requestFocus();
                        searchnextbutton = false;
                        continue;
                    }
                    if (++button_index < gui_button.length || !searchnextbutton) continue;
                    searchnextbutton = false;
                    raiseEvent = true;
                } while (searchnextbutton);
                if (raiseEvent) {
                    System.out.println("I need to raise an EVENT3");
                }
            } else {
                System.out.println("I need to raise an EVENT4");
            }
        }
        if (keycode == 37) {
            if (button_index - 1 > -1) {
                do {
                    if (gui_button[button_index - 1].isVisible() && gui_button[button_index - 1].isEnabled()) {
                        gui_button[button_index - 1].requestFocus();
                        searchnextbutton = false;
                        continue;
                    }
                    if (--button_index > -1 || !searchnextbutton) continue;
                    searchnextbutton = false;
                    raiseEvent = true;
                } while (searchnextbutton);
                if (raiseEvent) {
                    System.out.println("I need to raise an EVENT1");
                }
            } else {
                System.out.println("I need to raise an EVENT2");
            }
        }
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        EventArgs eventArguments = (EventArgs)((Object)o);
        if (eventArguments.getEventType() == 23) {
            this.moveToFirstActiveButton();
        }
    }

    public void clearScreen() {
        PdtScreen.instance.removeAll();
        if (Gui.gui.getPanelWorkspace() != null) {
            Gui.gui.getPanelWorkspace().removeAll();
        }
        PdtHelper.instance.logged_on_user = null;
        PdtWorkSpace.instance.panel.removeAll();
        Cache.instance.lists_cache_max_size = 0L;
        WorkspaceHeader.instance.setWorkSpaceHeaderLabel("");
        Gui.gui.getPdtB1().setVisible(false);
        Gui.gui.getPdtB1().setEnabled(false);
        Gui.gui.getPdtB2().setVisible(false);
        Gui.gui.getPdtB2().setEnabled(false);
        Gui.gui.getPdtB3().setVisible(false);
        Gui.gui.getPdtB3().setEnabled(false);
        instance.disableMenus();
    }

    public void logOff() {
        try {
            if (sec != null) {
                sec.setLoginStatus(false);
            }
            this.clearScreen();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static {
        instance = new PdtHelper();
        platform = null;
        ipWebServer = null;
        ipMesServer = null;
        printerName = "";
        printerIP = "";
        printerPort = 0;
    }
}

