/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Cache;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Overridable;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtScreen;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PdtHeader
extends Panel
implements Overridable,
ItemListener {
    private boolean action_cancelled;
    private Choice level1_menus;
    private Choice level2_menus;
    private Choice level3_menus;
    private Choice special_commands;
    public String level1_menu_value;
    public String level2_menu_value;
    public String level3_menu_value;
    public XmlNode header_config;
    public String current_menu_leaf_value;

    public void login() {
    }

    public void logged_in(String user) {
        PdtScreen.instance.logged_on_user = user;
        this.remove(this.getComponent(0));
        this.construct(this.header_config);
    }

    public void construct(XmlNode header_config) {
        this.header_config = header_config;
        if (PdtScreen.instance.logged_on_user == null) {
            this.login();
        } else {
            Event.instance.RaiseEvent(11, null, this);
            if (this.action_cancelled) {
                this.action_cancelled = false;
            } else {
                GridBagLayout headerGridBag = new GridBagLayout();
                int[] header_columns_widths = new int[]{300};
                headerGridBag.columnWidths = header_columns_widths;
                this.setLayout(headerGridBag);
                this.level1_menus = new Choice();
                this.level1_menus.setName("level1");
                this.level1_menus.addItemListener(this);
                GridBagConstraints level1_menus_con = new GridBagConstraints();
                level1_menus_con.gridwidth = 0;
                level1_menus_con.fill = 1;
                this.level2_menus = new Choice();
                this.level2_menus.setName("level2");
                this.level2_menus.addItemListener(this);
                GridBagConstraints level2_menus_con = new GridBagConstraints();
                level2_menus_con.gridwidth = 0;
                level2_menus_con.fill = 1;
                this.level3_menus = new Choice();
                this.level3_menus.setName("level3");
                this.level3_menus.addItemListener(this);
                GridBagConstraints level3_menus_con = new GridBagConstraints();
                level3_menus_con.gridwidth = 0;
                level3_menus_con.fill = 1;
                this.special_commands = new Choice();
                this.special_commands.setName("special_commands");
                this.special_commands.addItemListener(this);
                this.special_commands.setBackground(new Color(173, 184, 199));
                GridBagConstraints special_commands_con = new GridBagConstraints();
                special_commands_con.gridwidth = 0;
                special_commands_con.fill = 1;
                this.populateLevel1();
                this.add((Component)this.level1_menus, level1_menus_con);
                this.add((Component)this.level2_menus, level1_menus_con);
                this.add((Component)this.level3_menus, level2_menus_con);
                this.add((Component)this.special_commands, special_commands_con);
                PdtScreen.instance.workspace_title.setVisible(true);
                PdtScreen.instance.work_space.setVisible(true);
                PdtScreen.instance.footer.setVisible(true);
            }
        }
    }

    private void populateLevel1() {
        XmlNode slms = this.header_config.getNode("ConfigurationRecords/menus/menu[node_type=0,display=SLMS,value=1.0]");
        if (slms != null && slms.children != null) {
            ArrayList level1Menus = slms.children;
            this.level1_menus.addItem("<empty>");
            for (int i = 0; i < level1Menus.size(); ++i) {
                XmlNode menu_node = (XmlNode)level1Menus.get(i);
                String menu_item = menu_node.attributes.get("value") + "[" + menu_node.attributes.get("display") + "]";
                this.level1_menus.addItem(menu_item);
            }
            this.level2_menus.addItem("<empty>");
            this.level3_menus.addItem("<empty>");
            this.populateSpecialCommands();
        }
    }

    private void populateLevel2(XmlNode clickedLevelOneNode) {
        this.level2_menus.removeAll();
        this.level2_menus.addItem("<empty>");
        this.level3_menus.removeAll();
        this.level3_menus.addItem("<empty>");
        for (int i = 0; i < clickedLevelOneNode.children.size(); ++i) {
            XmlNode secLevelNode = (XmlNode)clickedLevelOneNode.children.get(i);
            String menu_item = secLevelNode.attributes.get("value") + "[" + secLevelNode.attributes.get("display") + "]";
            this.level2_menus.addItem(menu_item);
        }
    }

    private void populateLevel3(XmlNode clickedLevelTwoNode) {
        this.level3_menus.removeAll();
        this.level3_menus.addItem("<empty>");
        for (int i = 0; i < clickedLevelTwoNode.children.size(); ++i) {
            XmlNode thirdLevelNode = (XmlNode)clickedLevelTwoNode.children.get(i);
            String menu_item = thirdLevelNode.attributes.get("value") + "[" + thirdLevelNode.attributes.get("display") + "]";
            this.level3_menus.addItem(menu_item);
        }
    }

    private void getScreen() throws Exception {
        String xmlState = PdtWorkSpace.instance.workspace_config == null ? "<PDTRF></PDTRF>" : PdtWorkSpace.instance.workspace_config.toXml();
        PdtScreen.instance.serverTransaction(xmlState, 0);
    }

    private void populateSpecialCommands() {
        this.special_commands.addItem("<empty>");
        this.special_commands.addItem("1.2.3[Refresh]");
        this.special_commands.addItem("1.2.4[Undo]");
        this.special_commands.addItem("1.2.5[Cancel]");
        this.special_commands.addItem("Log off");
    }

    private void getScreenSpecial(String selectedCommand) throws Exception {
        this.current_menu_leaf_value = selectedCommand;
        String xmlState = PdtWorkSpace.instance.workspace_config == null ? "<PDTRF></PDTRF>" : PdtWorkSpace.instance.workspace_config.toXml();
        if (selectedCommand.equals("1.2.3")) {
            PdtScreen.instance.serverTransaction(xmlState, 8);
        } else if (selectedCommand.equals("1.2.4")) {
            PdtScreen.instance.serverTransaction(xmlState, 9);
        } else if (selectedCommand.equals("1.2.5")) {
            PdtScreen.instance.serverTransaction(xmlState, 7);
        } else if (selectedCommand.equals("Log off")) {
            System.out.println("HOW TO HANDLE = " + selectedCommand + "   ???");
            PdtScreen.instance.removeAll();
            PdtScreen.instance.pdt_header.removeAll();
            PdtScreen.instance.work_space.panel.removeAll();
            PdtScreen.instance.logged_on_user = null;
            Cache.instance.lists_cache_max_size = 0L;
            this.login();
            GridBagConstraints content_header_caption_con = new GridBagConstraints();
            content_header_caption_con.fill = 1;
            content_header_caption_con.gridwidth = 0;
            PdtScreen.instance.workspace_title.setText("");
            PdtScreen.instance.workspace_title.setVisible(false);
            PdtScreen.instance.add((Component)PdtScreen.instance.workspace_title, content_header_caption_con);
            GridBagConstraints emptyWorkspacePanel_con = new GridBagConstraints();
            emptyWorkspacePanel_con.gridwidth = 0;
            emptyWorkspacePanel_con.fill = 1;
            PdtScreen.instance.work_space.workspace_config = null;
            PdtScreen.instance.work_space.controls = null;
            PdtScreen.instance.work_space.setActiveTextBox(null);
            PdtScreen.instance.work_space.widest_label = 0;
            PdtScreen.instance.work_space.setVisible(false);
            PdtScreen.instance.add((Component)PdtScreen.instance.work_space, emptyWorkspacePanel_con);
            ArrayList buttonsList = PdtScreen.instance.screen_config.getNodeList("ConfigurationRecords/Buttons");
            XmlNode buttons = (XmlNode)buttonsList.get(0);
            Panel buttons_pane = (Panel)PdtScreen.instance.footer.getComponent(1);
            int one_button_width = buttons_pane.getWidth() / 3;
            int[] buttons_pane_columns_widths = new int[]{one_button_width, one_button_width, one_button_width};
            ((GridBagLayout)buttons_pane.getLayout()).columnWidths = buttons_pane_columns_widths;
            PdtScreen.instance.footer.button1.setVisible(true);
            PdtScreen.instance.footer.button1.setLabel((String)buttons.attributes.get("B1Label"));
            PdtScreen.instance.footer.button2.setVisible(true);
            PdtScreen.instance.footer.button2.setLabel((String)buttons.attributes.get("B2Label"));
            PdtScreen.instance.footer.button3.setVisible(true);
            PdtScreen.instance.footer.button3.setLabel((String)buttons.attributes.get("B3Label"));
            PdtScreen.instance.footer.message_panel.setMessage(null);
            PdtScreen.instance.add(PdtScreen.instance.footer);
            PdtScreen.instance.footer.setVisible(false);
        }
    }

    @Override
    public void cancel_action() {
        this.action_cancelled = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Choice clickedMenu = (Choice)e.getSource();
        String selection = (String)e.getItem();
        try {
            if (!selection.equals("<empty>") && !selection.equals("Log off")) {
                StringTokenizer tokenizer = new StringTokenizer(selection, "[");
                String value = tokenizer.nextToken();
                String rawDisplay = tokenizer.nextToken();
                String display = rawDisplay.substring(0, rawDisplay.length() - 1);
                StringTokenizer childTokenizer = new StringTokenizer(value, ".");
                if (clickedMenu.getName().equals("special_commands") && !selection.equals("<empty>")) {
                    this.getScreenSpecial(value);
                } else if (clickedMenu.getName().equals("level1")) {
                    Event.instance.RaiseEvent(17, null, this);
                    XmlNode querResult = this.header_config.getNode("ConfigurationRecords/menus/menu/menu[display=" + display + ",value=" + value + "]");
                    if (querResult.attributes.get("node_type").equals("2")) {
                        this.current_menu_leaf_value = value;
                        this.getScreen();
                    } else {
                        this.populateLevel2(querResult);
                    }
                } else if (clickedMenu.getName().equals("level2")) {
                    Event.instance.RaiseEvent(18, null, this);
                    String parentMenuItem = childTokenizer.nextToken() + "." + childTokenizer.nextToken();
                    XmlNode querResult = this.header_config.getNode("ConfigurationRecords/menus/menu/menu[value=" + parentMenuItem + "]/menu[display=" + display + ",value=" + value + "]");
                    if (querResult.attributes.get("node_type").equals("2")) {
                        this.current_menu_leaf_value = value;
                        this.getScreen();
                    } else {
                        this.populateLevel3(querResult);
                    }
                } else if (clickedMenu.getName().equals("level3")) {
                    Event.instance.RaiseEvent(19, null, this);
                    this.current_menu_leaf_value = value;
                    this.getScreen();
                }
            } else if (selection.equals("<empty>") && clickedMenu.getName().equals("level1")) {
                this.level2_menus.removeAll();
                this.level2_menus.addItem("<empty>");
                this.level3_menus.removeAll();
                this.level3_menus.addItem("<empty>");
            } else if (selection.equals("<empty>") && clickedMenu.getName().equals("level2")) {
                this.level3_menus.removeAll();
                this.level3_menus.addItem("<empty>");
            } else if (clickedMenu.getName().equals("special_commands") && selection.equals("Log off")) {
                this.getScreenSpecial(selection);
            }
        }
        catch (Exception ex) {
            throw new Error(ex.getMessage());
        }
    }
}

