/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Cache;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtControl;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.RecordSet;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Choice;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PdtDropDown
extends PdtControl {
    private Choice drop_down;
    private Map idValues;

    public PdtDropDown(XmlNode control_config) {
        super(control_config);
    }

    public Map getIdValues() {
        return this.idValues;
    }

    @Override
    public String getValue() {
        return this.drop_down.getSelectedItem();
    }

    public void clearValues() {
        this.drop_down.removeAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object input) {
        HashMap inputList = (HashMap)input;
        if (inputList.get("list") != null) {
            String csvList = (String)inputList.get("list");
            StringTokenizer tokeniser = new StringTokenizer(csvList, ",");
            while (tokeniser.hasMoreTokens()) {
                String toke = tokeniser.nextToken();
                if (toke.indexOf(124) != -1) {
                    if (this.getIdValues() == null) {
                        this.idValues = new HashMap();
                    }
                    StringTokenizer pairsTokeniser = new StringTokenizer(toke, "|");
                    String key = pairsTokeniser.nextToken();
                    this.drop_down.addItem(key);
                    this.getIdValues().put(key, pairsTokeniser.nextToken());
                    continue;
                }
                this.drop_down.addItem(toke);
            }
        } else {
            if (inputList.get("get_list") == null) throw new Error("ERROR in populaing a dropdown.... drop_down's get_list and/or list attribute is null OR empty");
            String recSetName = (String)inputList.get("get_list");
            boolean runAtServer = Boolean.valueOf((String)inputList.get("run_at_server"));
            if (inputList.get("list_field") == null || ((String)inputList.get("list_field")).trim().equals("")) throw new Error("ERROR in populaing a dropdown.... list_field attribute is null OR empty.You must specify list_field with get_list");
            String listName = (String)inputList.get("list_field");
            RecordSet recSet = Cache.instance.getRecordSet(recSetName, new HashMap(), runAtServer);
            List dropDownList = recSet.getList(listName);
            for (int i = 0; i < dropDownList.size(); ++i) {
                this.drop_down.addItem((String)dropDownList.get(i));
            }
        }
        if (inputList.get("value") == null) return;
        this.drop_down.select((String)inputList.get("value"));
    }

    @Override
    public void buildSpecificControl() {
        if (this.control_config.attributes.get("name") == null || ((String)this.control_config.attributes.get("name")).trim().equals("")) {
            throw new Error("Error while creating control .... control doesn't have a name.");
        }
        this.drop_down = new Choice();
        this.drop_down.setName((String)this.control_config.attributes.get("name"));
        this.setValue(this.control_config.attributes);
        this.drop_down.addItemListener(this);
        this.drop_down.addKeyListener(this);
        this.drawControl();
    }

    @Override
    public Component getNativeControl() {
        return this.drop_down;
    }

    @Override
    public boolean isInputControl() {
        return true;
    }

    public ArrayList getDependentControls() {
        ArrayList<PdtControl> dependentList = new ArrayList<PdtControl>();
        if (this.cascades != null && this.cascades.size() > 0) {
            XmlNode cascadeNode = (XmlNode)this.control_config.getNodeList("cascades").get(0);
            ArrayList controlCascades = cascadeNode.children;
            for (int i = 0; i < controlCascades.size(); ++i) {
                XmlNode cascade = (XmlNode)controlCascades.get(i);
                String targetControlName = (String)cascade.attributes.get("target_control_name");
                for (int j = 0; j < PdtWorkSpace.instance.controls.size(); ++j) {
                    PdtControl control = (PdtControl)PdtWorkSpace.instance.controls.get(j);
                    if (control.getNativeControl() == null || !control.getNativeControl().getName().equals(targetControlName)) continue;
                    dependentList.add(control);
                }
            }
        }
        return dependentList;
    }

    public void clearDependentControlList(String parent_control) {
        this.drop_down.removeAll();
        this.drop_down.addItem("Select:'" + parent_control + "'");
        ArrayList dependentLists = this.getDependentControls();
        for (int i = 0; i < dependentLists.size(); ++i) {
            PdtDropDown dependentList = (PdtDropDown)dependentLists.get(i);
            dependentList.clearDependentControlList(this.drop_down.getName());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.valueEntered();
            PdtWorkSpace.instance.nextInputControl(this);
        } else if (e.getKeyCode() == 55) {
            PdtWorkSpace.instance.setScrollPosition(PdtWorkSpace.instance.getScrollPosition().x - 2, 0);
        } else if (e.getKeyCode() == 57) {
            PdtWorkSpace.instance.setScrollPosition(PdtWorkSpace.instance.getScrollPosition().x + 2, 0);
        } else if (e.getKeyCode() == 56) {
            PdtWorkSpace.instance.setScrollPosition(0, PdtWorkSpace.instance.getScrollPosition().y - 2);
        } else if (e.getKeyCode() == 53) {
            PdtWorkSpace.instance.setScrollPosition(0, PdtWorkSpace.instance.getScrollPosition().y + 2);
        }
    }
}

