/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtControl;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.awtextra.AbsoluteConstraints;

public class PdtDate
extends PdtControl {
    private Choice year;
    private Choice month;
    private Choice day;
    private static HashMap yearMonths = new HashMap(12);

    public PdtDate(XmlNode control_config) {
        super(control_config);
    }

    @Override
    public String getValue() {
        if (this.year.isVisible() && this.month.isVisible() && this.day.isVisible()) {
            return this.year.getSelectedItem() + "-" + this.month.getSelectedItem() + "-" + this.day.getSelectedItem();
        }
        return "";
    }

    @Override
    public void setValue(Object input) {
        throw new Error("Error while trying to set the value of a date control .... functionality not available yet.");
    }

    @Override
    public void buildSpecificControl() {
        int currentDay;
        String currentMonth;
        int currentYear;
        if (this.control_config.attributes.get("name") != null && !((String)this.control_config.attributes.get("name")).trim().equals("")) {
            this.year = new Choice();
            this.year.setName((String)this.control_config.attributes.get("name") + "_year");
            this.year.addItemListener(this);
            this.year.addKeyListener(this);
            this.year.setFont(this.getTextFont());
            this.month = new Choice();
            this.month.setName((String)this.control_config.attributes.get("name") + "_month");
            this.month.addItemListener(this);
            this.month.addKeyListener(this);
            this.month.setFont(this.getTextFont());
            this.day = new Choice();
            this.day.setName((String)this.control_config.attributes.get("name") + "_day");
            this.day.addItemListener(this);
            this.day.addKeyListener(this);
            this.day.setFont(this.getTextFont());
            this.setYearMonths();
            if (this.control_config.attributes.get("value") != null && !((String)this.control_config.attributes.get("value")).trim().equals("")) {
                String date = (String)this.control_config.attributes.get("value");
                StringTokenizer tokeniser = new StringTokenizer(date, "-");
                currentYear = Integer.parseInt(tokeniser.nextToken());
                currentMonth = tokeniser.nextToken();
                currentDay = Integer.parseInt(tokeniser.nextToken());
            } else {
                Calendar calendar = Calendar.getInstance();
                currentYear = calendar.get(1);
                currentMonth = this.getMonth(calendar.get(2));
                currentDay = calendar.get(5);
            }
        } else {
            throw new Error("Error while creating control .... control doesn't have a name.");
        }
        this.year.addItem("" + currentYear);
        this.populateYear(currentYear, 3, 10, this.year);
        this.month.addItem(currentMonth);
        this.populateMonth();
        this.day.addItem("" + currentDay);
        this.populateDay();
        AbsoluteConstraints year_constraints = new AbsoluteConstraints(PdtWorkSpace.instance.widest_label, 0);
        this.add((Component)this.year, year_constraints);
        AbsoluteConstraints month_constraints = new AbsoluteConstraints(PdtWorkSpace.instance.widest_label + 51, 0);
        this.add((Component)this.month, month_constraints);
        AbsoluteConstraints day_constraints = new AbsoluteConstraints(PdtWorkSpace.instance.widest_label + 98, 0);
        this.add((Component)this.day, day_constraints);
        Checkbox show_hide_date = new Checkbox("", true);
        show_hide_date.addItemListener(this);
        AbsoluteConstraints show_hide_constraints = new AbsoluteConstraints(PdtWorkSpace.instance.widest_label + 105 + 32, 0);
        this.add((Component)show_hide_date, show_hide_constraints);
        AbsoluteConstraints label_constraints = new AbsoluteConstraints(0, 0);
        this.add((Component)this.label, label_constraints);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().getClass().getName().equals("java.awt.Choice")) {
            Choice clickedItem = (Choice)e.getSource();
            if (clickedItem.getName().equals(this.year.getName()) || clickedItem.getName().equals(this.month.getName())) {
                String currentDay = this.day.getSelectedItem();
                this.day.removeAll();
                this.day.addItem(currentDay);
                this.populateDay();
            } else {
                this.valueEntered();
            }
        } else if (e.getSource().getClass().getName().equals("java.awt.Checkbox")) {
            if (this.day.isVisible() && this.month.isVisible() && this.year.isVisible()) {
                this.day.setVisible(false);
                this.month.setVisible(false);
                this.year.setVisible(false);
            } else {
                this.day.setVisible(true);
                this.month.setVisible(true);
                this.year.setVisible(true);
            }
        }
    }

    private void setYearMonths() {
        yearMonths.put("Jan", "1");
        yearMonths.put("Feb", "2");
        yearMonths.put("Mar", "3");
        yearMonths.put("Apr", "4");
        yearMonths.put("May", "5");
        yearMonths.put("Jun", "6");
        yearMonths.put("Jul", "7");
        yearMonths.put("Aug", "8");
        yearMonths.put("Sep", "9");
        yearMonths.put("Oct", "10");
        yearMonths.put("Nov", "11");
        yearMonths.put("Dec", "12");
    }

    private String getMonth(int month) {
        ++month;
        for (Map.Entry me : yearMonths.entrySet()) {
            if (!("" + month).equals(me.getValue().toString())) continue;
            return me.getKey().toString();
        }
        return null;
    }

    private int getMonth(String month) {
        for (Map.Entry me : yearMonths.entrySet()) {
            if (!month.equals(me.getKey().toString())) continue;
            return Integer.parseInt(me.getValue().toString());
        }
        return -1;
    }

    private boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private void populateDay() {
        int currentMonth = this.getMonth(this.month.getSelectedItem());
        int currentYear = Integer.parseInt(this.year.getSelectedItem());
        if (currentMonth < 8) {
            if (currentMonth == 2) {
                if (this.isLeapYear(currentYear)) {
                    for (int i = 1; i < 30; ++i) {
                        this.day.addItem("" + i);
                    }
                } else {
                    for (int i = 1; i < 29; ++i) {
                        this.day.addItem("" + i);
                    }
                }
            } else if (currentMonth % 2 == 1) {
                for (int i = 1; i < 32; ++i) {
                    this.day.addItem("" + i);
                }
            } else {
                for (int i = 1; i < 31; ++i) {
                    this.day.addItem("" + i);
                }
            }
        } else if (currentMonth % 2 == 0) {
            for (int i = 1; i < 32; ++i) {
                this.day.addItem("" + i);
            }
        } else {
            for (int i = 1; i < 31; ++i) {
                this.day.addItem("" + i);
            }
        }
    }

    private void populateMonth() {
        if (!this.month.getSelectedItem().equals("Jan")) {
            this.month.addItem("Jan");
        }
        if (!this.month.getSelectedItem().equals("Feb")) {
            this.month.addItem("Feb");
        }
        if (!this.month.getSelectedItem().equals("Mar")) {
            this.month.addItem("Mar");
        }
        if (!this.month.getSelectedItem().equals("Apr")) {
            this.month.addItem("Apr");
        }
        if (!this.month.getSelectedItem().equals("May")) {
            this.month.addItem("May");
        }
        if (!this.month.getSelectedItem().equals("Jun")) {
            this.month.addItem("Jun");
        }
        if (!this.month.getSelectedItem().equals("Jul")) {
            this.month.addItem("Jul");
        }
        if (!this.month.getSelectedItem().equals("Aug")) {
            this.month.addItem("Aug");
        }
        if (!this.month.getSelectedItem().equals("Sept")) {
            this.month.addItem("Sept");
        }
        if (!this.month.getSelectedItem().equals("Oct")) {
            this.month.addItem("Oct");
        }
        if (!this.month.getSelectedItem().equals("Nov")) {
            this.month.addItem("Nov");
        }
        if (!this.month.getSelectedItem().equals("Dec")) {
            this.month.addItem("Dec");
        }
    }

    private void populateYear(int origin, int startValue, int rangeWidth, Choice yearDropDown) {
        int insertionValue = origin - startValue;
        if (insertionValue < origin) {
            yearDropDown.addItem("" + insertionValue);
            this.populateYear(origin, --startValue, rangeWidth, yearDropDown);
        } else if (insertionValue == origin) {
            startValue = -1;
            this.populateYear(origin, startValue, rangeWidth, yearDropDown);
        } else if (insertionValue < origin + rangeWidth + 1) {
            yearDropDown.addItem("" + insertionValue);
            this.populateYear(origin, --startValue, rangeWidth, yearDropDown);
        } else {
            return;
        }
    }

    @Override
    public Component getNativeControl() {
        return null;
    }

    @Override
    public boolean isInputControl() {
        return true;
    }

    @Override
    public void setFocus() {
        this.year.requestFocus();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }
}

