/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtCheckBox;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtControl;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtDate;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtDropDown;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtStaticText;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtTextArea;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtTextBox;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtTextLine;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;

public class PdtControlFactory {
    public static PdtControl createControl(XmlNode control_config) throws Exception {
        if (control_config.attributes.get("type") != null && !((String)control_config.attributes.get("type")).trim().equals("")) {
            PdtControl control = PdtControlFactory.renderControl(control_config);
            GridBagConstraints control_con = new GridBagConstraints();
            control_con.gridwidth = 0;
            control_con.fill = 2;
            PdtWorkSpace.instance.panel.add((Component)control, control_con);
            return control;
        }
        throw new Exception("Error in ControlFactory Type attribute not specified for control,name=" + control_config.attributes.get("name"));
    }

    public static PdtControl renderControl(XmlNode control_config) {
        PdtControl control;
        if (control_config.attributes.get("type").equals("check_box")) {
            control = new PdtCheckBox(control_config);
        } else if (control_config.attributes.get("type").equals("text_box")) {
            control = new PdtTextBox(control_config);
            if (PdtWorkSpace.instance.getActiveTextBox() == null) {
                PdtWorkSpace.instance.setActiveTextBox((PdtTextBox)control);
            }
        } else if (control_config.attributes.get("type").equals("static_text")) {
            control = new PdtStaticText(control_config);
        } else if (control_config.attributes.get("type").equals("text_line")) {
            control = new PdtTextLine(control_config);
        } else if (control_config.attributes.get("type").equals("text_area")) {
            control = new PdtTextArea(control_config);
        } else if (control_config.attributes.get("type").equals("drop_down")) {
            control = new PdtDropDown(control_config);
        } else if (control_config.attributes.get("type").equals("date")) {
            control = new PdtDate(control_config);
        } else {
            throw new UnsupportedOperationException("Type [" + control_config.attributes.get("type") + "] Not supported yet.....");
        }
        return control;
    }

    public static void addBottomPadding(int emptyLines) {
        for (int i = 0; i < emptyLines; ++i) {
            GridBagConstraints emptyLabelLeft_con = new GridBagConstraints();
            emptyLabelLeft_con.insets = new Insets(0, 0, 0, 0);
            emptyLabelLeft_con.fill = 1;
            GridBagConstraints emptyLabelRight_con = new GridBagConstraints();
            emptyLabelRight_con.gridwidth = 0;
            emptyLabelRight_con.fill = 1;
            PdtWorkSpace.instance.panel.add((Component)new Label(" "), emptyLabelLeft_con);
            PdtWorkSpace.instance.panel.add((Component)new Label(" "), emptyLabelRight_con);
        }
    }
}

