/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Cascade;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.CascadeFactory;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Overridable;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtDropDown;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtScreen;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtTextBox;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtWorkSpace;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.WorkSpaceDimensions;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public abstract class PdtControl
extends Panel
implements ActionListener,
FocusListener,
KeyListener,
Overridable,
ItemListener {
    public static final int KEY_DOWN = 117;
    public static final int KEY_UP = 112;
    public XmlNode control_config;
    public Label label;
    public ArrayList cascades;
    private boolean action_cancelled = false;

    public PdtControl(XmlNode control_config) {
        Event.instance.RaiseEvent(0, null, this);
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else {
            AbsoluteLayout layout = new AbsoluteLayout();
            this.setLayout((LayoutManager)layout);
            this.control_config = control_config;
            this.buildLabel();
            this.buildControl();
            this.cascades = new ArrayList();
            ArrayList cascadesNodeList = control_config.getNodeList("cascades");
            if (cascadesNodeList.size() > 0) {
                XmlNode cascadesNode = (XmlNode)cascadesNodeList.get(0);
                for (int i = 0; i < cascadesNode.children.size(); ++i) {
                    Cascade cascade = CascadeFactory.createCascade((XmlNode)cascadesNode.children.get(i));
                    this.cascades.add(cascade);
                }
            }
        }
        Event.instance.RaiseEvent(1, null, this);
    }

    public String isInputValid() {
        Event.instance.RaiseEvent(2, null, this);
        if (!this.action_cancelled) {
            String validationErrorStackTrace = "";
            String value = this.getValue();
            if (this.control_config.attributes.get("is_required") != null && ((String)this.control_config.attributes.get("is_required")).equals("true") && (value == null || value.trim().equals(""))) {
                validationErrorStackTrace = validationErrorStackTrace + this.getNativeControl().getName() + " is a required field.It cannot be empty";
            }
            if (validationErrorStackTrace.trim().equals("")) {
                return null;
            }
            return validationErrorStackTrace;
        }
        this.action_cancelled = false;
        return null;
    }

    public void buildLabel() {
        Event.instance.RaiseEvent(3, null, this);
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else {
            String labelCaption = this.control_config.attributes.get("label") != null && !((String)this.control_config.attributes.get("label")).trim().equals("") ? (String)this.control_config.attributes.get("label") : (String)this.control_config.attributes.get("name");
            this.label = new Label(labelCaption);
            this.label.setFont(this.getTextFont());
        }
    }

    public abstract String getValue();

    public abstract void setValue(Object var1);

    public void styleValidationError() {
        this.label.setForeground(new Color(246, 0, 0));
    }

    public void clearValidationStyle() {
        if (this.label != null) {
            this.label.setForeground(new Color(0, 0, 0));
        }
    }

    public void buildControl() {
        Event.instance.RaiseEvent(5, null, this);
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else {
            this.buildSpecificControl();
            if (this.getNativeControl() != null) {
                this.getNativeControl().setFont(this.getTextFont());
            }
        }
        Event.instance.RaiseEvent(6, null, this);
    }

    public abstract void buildSpecificControl();

    @Override
    public void cancel_action() {
        this.action_cancelled = true;
    }

    public abstract Component getNativeControl();

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this instanceof PdtTextBox) {
            PdtWorkSpace.instance.setActiveTextBox((PdtTextBox)this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            PdtWorkSpace.instance.nextInputControl(this);
            this.valueEntered();
        } else if (e.getKeyCode() == 9) {
            PdtWorkSpace.instance.nextInputControl(this);
            this.valueEntered();
        } else if (e.getKeyCode() == 37) {
            PdtWorkSpace.instance.setScrollPosition(PdtWorkSpace.instance.getScrollPosition().x - 2, 0);
        } else if (e.getKeyCode() == 39) {
            PdtWorkSpace.instance.setScrollPosition(PdtWorkSpace.instance.getScrollPosition().x + 2, 0);
        } else if (e.getKeyCode() == 38) {
            PdtWorkSpace.instance.setScrollPosition(0, PdtWorkSpace.instance.getScrollPosition().y - 2);
        } else if (e.getKeyCode() == 40) {
            PdtWorkSpace.instance.setScrollPosition(0, PdtWorkSpace.instance.getScrollPosition().y + 2);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected void valueEntered() {
        Event.instance.RaiseEvent(7, this.getValue(), this);
        if (this.action_cancelled) {
            this.action_cancelled = false;
        } else {
            this.cascade();
        }
    }

    protected void cascade() {
        for (int i = 0; i < this.cascades.size(); ++i) {
            Cascade cascade = (Cascade)this.cascades.get(i);
            cascade.cascade(this);
        }
    }

    public abstract boolean isInputControl();

    public void updateXml() {
        if (this.getValue() != null) {
            String value = this.getValue().toString().replace('\'', '!');
            value = value.replace('\"', '$');
            value = value.replace('=', '^');
            this.control_config.attributes.put("value", value);
            if (this instanceof PdtDropDown && ((PdtDropDown)this).getIdValues() != null) {
                this.control_config.attributes.put("id_value", ((PdtDropDown)this).getIdValues().get(value));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.valueEntered();
        if (e.getSource().getClass().getName().equals("java.awt.Choice")) {
            ArrayList dependentLists = ((PdtDropDown)this).getDependentControls();
            for (int i = 0; i < dependentLists.size(); ++i) {
                PdtDropDown dependentList = (PdtDropDown)dependentLists.get(i);
                ArrayList childDependentControls = dependentList.getDependentControls();
                for (int j = 0; j < childDependentControls.size(); ++j) {
                    PdtDropDown childDependtList = (PdtDropDown)childDependentControls.get(j);
                    childDependtList.clearDependentControlList(dependentList.getNativeControl().getName());
                }
            }
        }
    }

    public void setFocus() {
        PdtScreen.instance.resetPdtMonitor();
        this.getNativeControl().requestFocus();
        PdtWorkSpace.instance.setActiveControl(this);
        if (this instanceof PdtTextBox) {
            PdtWorkSpace.instance.setActiveTextBox((PdtTextBox)this);
        }
    }

    protected void drawControl() {
        AbsoluteConstraints label_constraints = new AbsoluteConstraints(0, 0);
        this.add((Component)this.label, label_constraints);
        AbsoluteConstraints native_control_constraints = new AbsoluteConstraints(PdtWorkSpace.instance.widest_label, 0);
        this.add(this.getNativeControl(), native_control_constraints);
    }

    public Font getTextFont() {
        int size = WorkSpaceDimensions.getWorkSpaceDimensions().getFontSize();
        return new Font("Arial", 0, size);
    }
}

