/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced.pdt;

import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtServerProxy;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.PdtSettings;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.RecordSet;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.ServerRecordSet;
import com.nosoft.mobile.mes.xml.XmlNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Cache {
    public static final Cache instance = new Cache();
    private Map cached_recordsets = new HashMap();
    public long lists_cache_max_size;

    private long getCachedRecordSetByteSize() {
        long current_total_byte_size = 0L;
        if (!this.cached_recordsets.isEmpty()) {
            for (Map.Entry record_set_entry : this.cached_recordsets.entrySet()) {
                RecordSet record_set = (RecordSet)record_set_entry.getValue();
                current_total_byte_size += record_set.byte_size;
            }
        }
        return current_total_byte_size;
    }

    public void addRecordSet(String recordSetName, RecordSet recordSet) {
        if (recordSet.byte_size + this.getCachedRecordSetByteSize() < this.getlists_cache_max_size()) {
            this.cached_recordsets.put(recordSetName, recordSet);
        } else {
            this.clearCache(recordSetName, recordSet);
        }
    }

    public void clearCache(String recordSetToInsertName, RecordSet recordSetToInsert) {
        if (!this.cached_recordsets.isEmpty()) {
            Map.Entry oldestCachedRecordEntry = this.cached_recordsets.entrySet().iterator().next();
            this.cached_recordsets.remove(oldestCachedRecordEntry.getKey());
            if (recordSetToInsert.byte_size + this.getCachedRecordSetByteSize() < this.getlists_cache_max_size()) {
                this.cached_recordsets.put(recordSetToInsertName, recordSetToInsert);
            } else {
                this.clearCache(recordSetToInsertName, recordSetToInsert);
            }
        }
    }

    public long getlists_cache_max_size() {
        if (this.lists_cache_max_size < 1L) {
            PdtSettings.getInstance();
            Properties settings = PdtSettings.getSettings();
            String str_memory_limit = (String)settings.get("memory_limit");
            this.lists_cache_max_size = str_memory_limit != null ? Long.parseLong(str_memory_limit) : 10000L;
        }
        return this.lists_cache_max_size;
    }

    public Map getCached_recordsets() {
        return this.cached_recordsets;
    }

    public RecordSet getRecordSet(String data_service_name, Map params, boolean runAtServer) {
        RecordSet resultRecordSet;
        if (this.getCached_recordsets().containsKey(data_service_name) && !runAtServer) {
            resultRecordSet = (RecordSet)this.getCached_recordsets().get(data_service_name);
        } else if (!runAtServer) {
            XmlNode workspaceDefinition = PdtServerProxy.call("services/pdt_data_service", data_service_name, params);
            resultRecordSet = new RecordSet(workspaceDefinition);
            this.addRecordSet(data_service_name, resultRecordSet);
        } else {
            resultRecordSet = new ServerRecordSet(data_service_name, params);
            this.addRecordSet(data_service_name, resultRecordSet);
        }
        return resultRecordSet;
    }
}

