/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.gui.pdtadvanced;

import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.gui.pdtadvanced.MessageOrion;
import com.nosoft.mobile.mes.gui.pdtadvanced.pdt.Event;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MessagePanel
extends Panel {
    private Button button2;
    private Button button3;
    private Label label1;
    private Label label2;
    private ScrollPane scrollPane1;
    private TextArea textArea1;
    private Vector msgSysArray = new Vector();
    private Vector msgUsrArray = new Vector();
    private int currentMessageNumber = 1;
    private int maxMessages = 50;
    public static final MessagePanel instance = new MessagePanel();

    public MessagePanel() {
        this.setLocation(0, 0);
        this.initComponents();
        this.setVisible(true);
        this.setMsglabel(this.msgSysArray.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addSysMsgArray(MessageOrion msgOrion) {
        this.msgSysArray.add(msgOrion);
        try {
            if (this.msgSysArray.size() != 2) return;
        }
        catch (Exception e) {
            System.out.println(" Error message from Message Panel method addSysMsgArray  " + e.getMessage());
        }
    }

    public synchronized void sysMsg(String msg) {
        MessageOrion newMsg = new MessageOrion();
        newMsg.setMessage(msg);
        this.addSysMsgArray(newMsg);
        this.UpdateInternal(msg);
    }

    public synchronized void sysMsg(String msg, String font) {
        MessageOrion newMsg = new MessageOrion();
        newMsg.setMessage(msg);
        newMsg.setFontParemeters(font);
        this.addSysMsgArray(newMsg);
        this.UpdateInternal(msg);
    }

    public void setMessage(String msg) {
        if (this.msgSysArray.size() > 0) {
            MessageOrion currentMsg = (MessageOrion)this.msgSysArray.get(this.msgSysArray.size() - 1);
            currentMsg.setMessage(currentMsg.getMessage() + " " + msg);
            this.UpdateInternal(msg);
        } else {
            this.addMessage(msg);
        }
    }

    public synchronized void UpdateInternal(String msg) {
        Event.instance.RaiseEvent(23, msg, this);
        this.currentMessageNumber = 1;
        this.setMsglabel(-1);
        this.setLatestMsg();
    }

    public void addMessage(String msg) {
        MessageOrion newMsg = new MessageOrion();
        newMsg.setMessage(msg);
        this.addSysMsgArray(newMsg);
        this.UpdateInternal(msg);
        this.setMsglabel(-1);
        Event.instance.RaiseEvent(23, msg, this);
    }

    public synchronized void setMsg(String msg) {
        MessageOrion newMsg = new MessageOrion();
        newMsg.setMessage(msg);
        this.addSysMsgArray(newMsg);
    }

    private void IncreaseMessageNr() {
        if (this.msgSysArray.size() > 0) {
            if (this.currentMessageNumber + 1 <= this.msgSysArray.size()) {
                ++this.currentMessageNumber;
                this.setTextArea(this.currentMessageNumber);
            }
            this.setMsglabel(-1);
        }
    }

    public void setMsglabel(int msgnr) {
        try {
            if (msgnr == -1) {
                this.label2.setText(this.currentMessageNumber + "/(" + this.msgSysArray.size() + ")");
            } else {
                this.label2.setText(msgnr + "/(" + this.msgSysArray.size() + ")");
            }
        }
        catch (Exception e) {
            System.out.println("This is an error" + e.getMessage());
        }
    }

    private void deacreaseMessageCount() {
        if (this.msgSysArray.size() > 0) {
            if (this.currentMessageNumber - 1 >= 1) {
                --this.currentMessageNumber;
                this.setTextArea(this.currentMessageNumber);
            }
            this.setMsglabel(-1);
        }
    }

    public void setLatestMsg() {
        this.setTextArea(this.msgSysArray.size());
    }

    public void initComponents() {
        int width = Gui.gui.getWidth() - 5;
        int height = Gui.gui.getHeight() - 5;
        this.setSize(width, height);
        this.label1 = new Label();
        this.button2 = new Button();
        this.button3 = new Button();
        this.label2 = new Label();
        this.scrollPane1 = new ScrollPane();
        this.textArea1 = new TextArea();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.label1.setText("Message Panel");
        this.button2.setLabel("<");
        this.button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.deacreaseMessageCount();
            }
        });
        this.add((Component)this.button2, new AbsoluteConstraints(10, 0, -1, -1));
        this.button3.setLabel(">");
        this.button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.IncreaseMessageNr();
            }
        });
        this.add((Component)this.button3, new AbsoluteConstraints(180, 0, -1, -1));
        this.label2.setText("0/(0)");
        this.add((Component)this.label2, new AbsoluteConstraints(60, 0, -1, -1));
        this.add((Component)this.textArea1, new AbsoluteConstraints(5, 30, width - 15, height - 70));
        this.setVisible(true);
    }

    public void setTextArea(int msg_nr) {
        MessageOrion msgText = (MessageOrion)this.msgSysArray.get(this.msgSysArray.size() - this.currentMessageNumber);
        System.out.println(msgText.getMessage());
        Font msgFont = new Font("Arial", 1, 15);
        this.textArea1.setFont(msgFont);
        this.textArea1.setText(msgText.getMessage());
    }

    public void showMsgPanel() {
        this.setVisible(true);
    }

    public void hideMsgPanel() {
        this.setVisible(false);
    }
}

