/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.factories;

import com.nosoft.mobile.mes.messages.Message;
import com.nosoft.mobile.mes.messages.MessageInterface;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFactory {
    public XmlFactory xml = this;
    private static MessageInterface msg = Message.getInstance();
    private String name;
    protected boolean allowMsg = false;
    protected boolean enable = false;
    protected boolean runStatus = false;
    protected Node xmlnode;

    public void setAllowMsg(boolean m) {
        this.allowMsg = m;
    }

    public static synchronized Document setupXMLDocument(String filename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dbuilder = factory.newDocumentBuilder();
            Document document = dbuilder.parse(new File(filename));
            return document;
        }
        catch (IOException e) {
            msg.sysMsg("bold+red", "IOException opening the XML file " + filename + "...");
            return null;
        }
        catch (Exception e) {
            msg.sysMsg("bold+red", "Exception opening XML file " + filename + "...");
            return null;
        }
    }

    public static synchronized NodeList getXMLNodeList(Document doc, int cnt, String tagName) {
        try {
            NodeList nl = doc.getElementsByTagName(tagName).item(cnt).getChildNodes();
            return nl;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String getTagAttributes(NodeList nodes, String tag) {
        String str = "";
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!tag.equals(nodes.item(i).getNodeName())) continue;
                NamedNodeMap nnm = nodes.item(i).getAttributes();
                for (int j = 0; j < nnm.getLength(); ++j) {
                    str = str + nnm.item(j) + " ";
                }
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static synchronized String lookupValue(NodeList nodes, String name) {
        String s = "XML tag name <" + name + "> not found or the tag contains a blank value (make blanks=null)... ";
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!name.equals(nodes.item(i).getNodeName())) continue;
                return nodes.item(i).getFirstChild().getNodeValue();
            }
            msg.sysMsg("bold+red", s);
        }
        catch (Exception e) {
            msg.sysMsg("bold+red", s);
        }
        return "";
    }

    public static synchronized boolean setItemValue(NodeList nl, String name, String value) {
        int nlTot = nl.getLength();
        for (int i = 0; i < nlTot; ++i) {
            if (!name.equals(nl.item(i).getNodeName())) continue;
            try {
                nl.item(i).setNodeValue(value);
                return true;
            }
            catch (DOMException de) {
                String s = "DOMException while setting tag <" + name + "> to " + value;
                msg.sysMsg("bold+red", s);
            }
        }
        return false;
    }

    public static synchronized void saveValue(Node parentnode, String fileName, String name, String value) {
        NodeList children = parentnode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!name.equals(children.item(i).getNodeName())) continue;
            children.item(i).getFirstChild().setNodeValue(value);
            XmlFactory.writeXmlFile(parentnode.getOwnerDocument(), fileName);
            return;
        }
        Element n = parentnode.getOwnerDocument().createElement(name);
        n.appendChild(parentnode.getOwnerDocument().createTextNode(value));
        parentnode.appendChild(n);
        XmlFactory.writeXmlFile(parentnode.getOwnerDocument(), fileName);
    }

    public static synchronized void writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            msg.sysMsg("bold+red", "TransformerConfigurationException while writing the XML file " + filename + "...");
        }
        catch (TransformerException e) {
            msg.sysMsg("bold+red", "TransformerException while writing the XML file " + filename + "...");
        }
    }

    public static synchronized NodeList recurseXMLNodeList(NodeList nl, String tag) {
        int l = nl.getLength();
        for (int i = 0; i < l; ++i) {
            Node nd = nl.item(i);
            NodeList nnl = nd.getChildNodes();
            String name = nl.item(i).getNodeName();
            if ("null".equals(name) || "#text".equals(name) || "#comment".equals(name)) continue;
            if (tag.equals(nl.item(i).getNodeName())) {
                return nnl;
            }
            if (nnl.getLength() <= 0) continue;
            XmlFactory.recurseXMLNodeList(nnl, tag);
        }
        return null;
    }

    public static synchronized String parseXMLString(String str) {
        int e;
        String value = "";
        int s = str.indexOf(62);
        if (s > -1 && (e = str.indexOf(60, s + 1)) > -1) {
            try {
                value = str.substring(s + 1, e).trim();
            }
            catch (IndexOutOfBoundsException iob) {
                msg.sysMsg("bold+red", "XMLString: IndexOutOfBoundsException while parsing the XML tag " + str + "...");
            }
        }
        return value;
    }

    public static synchronized String parseTagAttribute(String attribute, String str) {
        String start1 = "\"";
        String start2 = "=%22";
        String start3 = "=%E2%80%9D";
        String end1 = "\" ";
        String end2 = "\"%20";
        String end3 = "%22";
        String end4 = "\"/>";
        String end5 = "%E2%80%9D";
        String next1 = "=\"";
        String value = "";
        str = " " + str + " ";
        if (str.contains(" " + attribute)) {
            int k = str.indexOf(attribute + "=");
            String buf = str.substring(k);
            int s = buf.indexOf(start1);
            if (s < 0) {
                s = buf.indexOf(start2);
                if (s > -1) {
                    s += start2.length() - 1;
                } else {
                    s = buf.indexOf(start3);
                    if (s > -1) {
                        s += start3.length() - 1;
                    }
                }
            }
            if (s > -1) {
                int e = -1;
                e = buf.indexOf(end1, s + 1);
                if (e < 0 && (e = buf.indexOf(end2, s + 1)) < 0 && (e = buf.indexOf(end3, s + 1)) < 0 && (e = buf.indexOf(end4, s + 1)) < 0 && (e = buf.indexOf(end5, s + 1)) < 0) {
                    return value;
                }
                if (e > -1) {
                    int n = buf.indexOf(next1, s + 1);
                    if (n > -1 && n < e) {
                        return value;
                    }
                    try {
                        value = buf.substring(s + 1, e).trim();
                    }
                    catch (NumberFormatException nfe) {
                        msg.sysMsg("bold+red", "XMLAttribute: NumberFormatException while parsing for the XML attribute " + attribute + "...");
                    }
                    catch (IndexOutOfBoundsException iob) {
                        msg.sysMsg("bold+red", "XMLAttribute: IndexOutOfBoundsException while parsing for the XML attribute " + attribute + "...");
                    }
                }
            }
        }
        return value;
    }

    public static synchronized long parseXMLValue(String str) {
        int e;
        long value = -1L;
        int s = str.indexOf(62);
        if (s > -1 && (e = str.indexOf(60, s + 1)) > -1) {
            try {
                value = Long.parseLong(str.substring(s + 1, e).trim());
            }
            catch (NumberFormatException nfe) {
                msg.sysMsg("bold+red", "XMLValue: NumberFormatException while parsing the XML tag " + str + "...");
            }
            catch (IndexOutOfBoundsException iob) {
                msg.sysMsg("bold+red", "XMLValue: IndexOutOfBoundsException while parsing the XML tag " + str + "...");
            }
        }
        return value;
    }
}

