/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.devices.server;

import com.nosoft.mobile.mes.data.Data;
import com.nosoft.mobile.mes.devices.Device;
import com.nosoft.mobile.mes.devices.DeviceInterface;
import com.nosoft.mobile.mes.factories.XmlFactory;
import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.messages.Message;
import com.nosoft.mobile.sys.Sys;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Server
extends Device
implements DeviceInterface {
    protected String serverIpAddress = "127.0.0.1";
    protected int serverPort = 2014;
    protected String serverPortStr = "2014";
    protected int transactionPort = 2020;
    protected String transactionPortStr = "2020";
    protected String webServerIpAddress = "127.0.0.1";
    protected int webServerHttpPort = 2080;
    protected String webServerHttpPortStr = "2080";
    protected String webServerBusinessURL = "";
    protected int TTL = 10000;

    public Server() {
        this.dev = this;
        gui = Gui.gui;
        msg = Message.getInstance();
        lmm = Sys.fsys;
        lmmData = Data.getDataHandle();
        this.isLinux = lmm.isLinux();
    }

    public Server(boolean allowMsg, boolean enable) {
        this();
        this.allowMsg = allowMsg;
        this.enable = enable;
    }

    public Server(boolean allowMsg, boolean enable, Node xmlnode) {
        this(allowMsg, enable);
        if (!this.xmlConfigDevice(xmlnode)) {
            return;
        }
    }

    @Override
    public boolean xmlConfigDevice(Node xmlnode) {
        NodeList nodes = xmlnode.getChildNodes();
        try {
            this.name = this.deviceName = XmlFactory.lookupValue(nodes, "Name");
            this.deviceType = XmlFactory.lookupValue(nodes, "DeviceType").toLowerCase();
            if (this.deviceType.isEmpty()) {
                this.deviceType = "server";
            }
            this.setServerIpAddressStr(XmlFactory.lookupValue(nodes, "IPAddress"));
            this.setServerPortStr(XmlFactory.lookupValue(nodes, "Port"));
            this.setWebServerIpAddress(XmlFactory.lookupValue(nodes, "WebIPAddress"));
            this.setWebServerPortStr(XmlFactory.lookupValue(nodes, "WebPort"));
            this.setTransactionPortStr(XmlFactory.lookupValue(nodes, "TransactionPort"));
            this.setServerBusinessURL(XmlFactory.lookupValue(nodes, "BusinessURL"));
            this.setTTL(XmlFactory.lookupValue(nodes, "TTL"));
            msg.sysMsg("bold+black", "Server " + this.name + " started...");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean setParameterData(String parameterData) {
        return true;
    }

    @Override
    public String getServerIpAddressStr() {
        return this.serverIpAddress;
    }

    @Override
    public void setServerIpAddressStr(String ServerIpAddress) {
        this.serverIpAddress = ServerIpAddress;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(int ServerPort) {
        this.serverPort = ServerPort;
        this.setServerPortStr("" + ServerPort);
    }

    @Override
    public boolean setServerPortStr(String ServerPort) {
        this.serverPortStr = ServerPort;
        int tmp = this.serverPort;
        try {
            this.serverPort = Integer.parseInt(ServerPort);
        }
        catch (NumberFormatException nfe) {
            this.serverPort = tmp;
            return false;
        }
        return true;
    }

    @Override
    public String getWebServerIpAddress() {
        return this.webServerIpAddress;
    }

    @Override
    public void setWebServerIpAddress(String gWebServerIpAddress) {
        this.webServerIpAddress = gWebServerIpAddress;
    }

    @Override
    public void setWebServerPort(int gServerHttpPort) {
        this.webServerHttpPort = gServerHttpPort;
        this.setWebServerPortStr("" + gServerHttpPort);
    }

    @Override
    public boolean setWebServerPortStr(String ServerHttpPort) {
        this.webServerHttpPortStr = ServerHttpPort;
        int tmp = this.webServerHttpPort;
        try {
            this.webServerHttpPort = Integer.parseInt(ServerHttpPort);
        }
        catch (NumberFormatException nfe) {
            this.webServerHttpPort = tmp;
            return false;
        }
        return true;
    }

    @Override
    public int getWebServerPort() {
        return this.webServerHttpPort;
    }

    @Override
    public int getTransactionPort() {
        return this.transactionPort;
    }

    @Override
    public void setTransactionPort(int transactionPort) {
        this.transactionPort = transactionPort;
        this.setServerPortStr("" + transactionPort);
    }

    @Override
    public boolean setTransactionPortStr(String gTransactionPortStr) {
        this.transactionPortStr = gTransactionPortStr;
        int tmp = this.transactionPort;
        try {
            this.transactionPort = Integer.parseInt(gTransactionPortStr);
        }
        catch (NumberFormatException nfe) {
            this.transactionPort = tmp;
            return false;
        }
        return true;
    }

    @Override
    public String getServerBusinessURL() {
        return this.webServerBusinessURL;
    }

    @Override
    public void setServerBusinessURL(String gServerBusinessURL) {
        this.webServerBusinessURL = gServerBusinessURL;
    }

    @Override
    public int getTTL() {
        return this.TTL;
    }

    @Override
    public void setTTL(String strTTL) {
        int br = 5000;
        try {
            br = Integer.parseInt(strTTL);
        }
        catch (NumberFormatException nfe) {
            br = 10000;
        }
        this.TTL = br;
    }
}

