/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.devices.serial;

import com.nosoft.mobile.mes.data.Data;
import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.devices.Device;
import com.nosoft.mobile.mes.devices.DeviceInterface;
import com.nosoft.mobile.mes.factories.XmlAttributeFactory;
import com.nosoft.mobile.mes.factories.XmlFactory;
import com.nosoft.mobile.mes.gui.Gui;
import com.nosoft.mobile.mes.messages.Message;
import com.nosoft.mobile.mes.util.HexConv;
import com.nosoft.mobile.mes.util.ScanEvaluation;
import com.nosoft.mobile.mes.util.ScanInput;
import com.nosoft.mobile.mes.util.WaitTimer;
import com.nosoft.mobile.sys.Sys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RS232Jssc
extends Device
implements FinalData,
DeviceInterface {
    private int devicePort = 0;
    private String comPortStr = "";
    private int comPortAddr = 0;
    private String comPortAddrS = "0x3F8";
    private long comBaud = 0L;
    private char comParity = (char)78;
    private String comParityS = "N";
    private int comData = 0;
    private int comStop = 0;
    private char comFlow = (char)83;
    private String comFlowS = "N";
    private long comTOl = 0L;
    private int comBaudi = 0;
    private int comParityi = 0;
    private int comDatai = 0;
    private int comStopi = 0;
    private int comFlowi = 0;
    protected long rxBufLen = 0L;
    protected char[] rxBuf;
    protected long rxCnt = 0L;
    protected long txBufLen = 0L;
    protected char[] txBuf;
    protected long txCnt = 0L;
    protected boolean xOn = true;
    protected boolean stx = false;
    protected boolean etx = false;
    protected boolean cr = false;
    protected boolean lf = false;
    protected ScanEvaluation scanEval = null;
    protected int[] inputLengths = null;
    protected String[] inputLabels = null;
    protected String[] recogStrings = null;
    protected boolean scanQueReset = false;
    protected String scanResetValue = "";
    protected boolean captureNoRead = false;
    protected String noReadString = "";
    protected String triggerID = "";
    protected boolean triggerIDBool = false;
    protected boolean removeLead = false;
    protected boolean removeTrail = false;
    protected String removeLeadChar = "";
    protected String removeTrailChar = "";
    protected SerialPort serialPort;
    protected SerialReader serialReader = null;
    protected List driverBuf = Collections.synchronizedList(new ArrayList());
    public static final int RS232RING = 256;
    protected XmlAttributeFactory xmlAttr = new XmlAttributeFactory();
    private boolean debug = false;
    private boolean debugLocal = false;
    protected Receive rx = null;
    protected Thread eventSource = null;

    public RS232Jssc() {
        this.dev = this;
        gui = Gui.gui;
        msg = Message.getInstance();
        lmm = Sys.fsys;
        lmmData = Data.getDataHandle();
        this.isLinux = lmm.isLinux();
        this.name = "SerialDevice";
        this.deviceType = "scanner";
    }

    public RS232Jssc(boolean allowMsg, boolean enable) {
        this();
        this.allowMsg = allowMsg;
        this.enable = enable;
    }

    public RS232Jssc(boolean allowMsg, boolean enable, Node xmlnode) {
        this(allowMsg, enable);
        if (!this.xmlConfigDevice(xmlnode)) {
            return;
        }
        this.startDevice();
    }

    @Override
    public void startDevice() {
        if (this.enable && !this.runStatus) {
            this.runStatus = true;
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    this.setName("ScannerGeneric.startDevice_rx");
                    RS232Jssc.this.rx = new Receive();
                    RS232Jssc.this.eventSource = new Thread(RS232Jssc.this.rx);
                    RS232Jssc.this.eventSource.start();
                    RS232Jssc.this.eventSource.setName("ScannerGeneric.Receive.run");
                }
            };
        }
    }

    @Override
    public boolean xmlConfigDevice(Node xmlnode) {
        NodeList nodes = xmlnode.getChildNodes();
        try {
            String et;
            this.name = XmlFactory.lookupValue(nodes, "Name");
            this.deviceName = XmlFactory.lookupValue(nodes, "DeviceName");
            this.deviceType = XmlFactory.lookupValue(nodes, "DeviceType").toLowerCase();
            if (this.deviceType.isEmpty()) {
                this.deviceType = "generic";
            }
            this.comPortStr = this.isLinux ? this.deviceName : this.deviceName.toUpperCase();
            try {
                this.devicePort = Integer.parseInt(XmlFactory.lookupValue(nodes, "DevicePort"));
            }
            catch (NumberFormatException nfe) {
                this.devicePort = 0;
            }
            if (this.devicePort > 0) {
                --this.devicePort;
            } else {
                this.enable = false;
                this.runStatus = false;
                msg.sysMsg("bold+red", "Invalid RS232 port in XML configuration file...");
                return false;
            }
            this.driverName = XmlFactory.lookupValue(nodes, "DriverName");
            this.comPortAddrS = XmlFactory.lookupValue(nodes, "DeviceAddress");
            this.comPortAddr = HexConv.hexStringToInt(this.comPortAddrS);
            try {
                this.comTOl = Integer.parseInt(XmlFactory.lookupValue(nodes, "TTL"));
            }
            catch (NumberFormatException nfe) {
                this.comTOl = 5000L;
            }
            String st = XmlFactory.lookupValue(nodes, "StartOfInput");
            if (st.equals("stx")) {
                this.stx = true;
            }
            switch (et = XmlFactory.lookupValue(nodes, "EndOfInput")) {
                case "etx": {
                    this.cr = false;
                    this.lf = false;
                    this.etx = true;
                    break;
                }
                case "cr": {
                    this.cr = true;
                    this.lf = false;
                    this.etx = false;
                    break;
                }
                case "lf": {
                    this.cr = false;
                    this.lf = true;
                    this.etx = false;
                }
            }
            if (this.deviceName.toLowerCase().contains("com") || this.deviceName.toLowerCase().contains("/dev/tty")) {
                this.comPortAddr = Integer.parseInt(XmlFactory.lookupValue(nodes, "DevicePort"));
                if (this.comPortAddr > 0) {
                    --this.comPortAddr;
                }
                this.comBaud = Long.parseLong(XmlFactory.lookupValue(nodes, "Baud"));
                this.comParityS = XmlFactory.lookupValue(nodes, "Parity");
                try {
                    this.comParity = this.comParityS.charAt(0);
                }
                catch (IndexOutOfBoundsException iob) {
                    this.comParity = (char)78;
                    msg.sysMsg("bold+red", "Parity set to 'N' on " + this.deviceName + " ...");
                }
                this.comData = Integer.parseInt(XmlFactory.lookupValue(nodes, "DataBits"));
                this.comStop = Integer.parseInt(XmlFactory.lookupValue(nodes, "StopBits"));
            }
            this.comFlowS = XmlFactory.lookupValue(nodes, "FlowControl");
            try {
                this.comFlow = this.comFlowS.charAt(0);
            }
            catch (IndexOutOfBoundsException iob) {
                this.comFlow = (char)83;
                msg.sysMsg("bold+red", "Flow control set to 'S' on " + this.deviceName + " ...");
            }
            this.rxBufLen = Long.parseLong(XmlFactory.lookupValue(nodes, "InputBuffer"));
            this.rxBuf = new char[(int)this.rxBufLen];
            this.txBufLen = Long.parseLong(XmlFactory.lookupValue(nodes, "OutputBuffer"));
            this.txBuf = new char[(int)this.txBufLen];
            this.comTOl = Long.parseLong(XmlFactory.lookupValue(nodes, "TTL"));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        catch (IndexOutOfBoundsException iob) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        this.setParameterData(XmlFactory.getTagAttributes(nodes, "Parameters"));
        if (this.openDev(this.devicePort, this.comBaud, this.comParity, this.comData, this.comStop, this.comFlow, this.rxBufLen, this.txBufLen) == 1) {
            switch (this.deviceType) {
                case "scanner": {
                    msg.sysMsg("bold+black", "Scanner " + this.name + " started on port=" + this.deviceName + " ...");
                    break;
                }
                default: {
                    msg.sysMsg("bold+black", "Serial device " + this.name + " started on port=" + this.deviceName + " ...");
                }
            }
        }
        return true;
    }

    public boolean setParameterData(String parameterData) {
        boolean cnt = false;
        boolean b = false;
        if (parameterData.length() < 1) {
            return b;
        }
        this.scanEval = new ScanEvaluation(msg, this.name, parameterData);
        boolean rules = "true".equalsIgnoreCase(this.xmlAttr.parseTagAttribute("Rules", parameterData).toLowerCase());
        if (rules) {
            this.debugLocal = "true".equalsIgnoreCase(this.xmlAttr.parseTagAttribute("Debug", parameterData).toLowerCase());
            this.captureNoRead = "true".equalsIgnoreCase(this.xmlAttr.parseTagAttribute("NoReadProcess", parameterData).toLowerCase());
            this.noReadString = this.xmlAttr.parseTagAttribute("NoReadString", parameterData);
            if (this.noReadString.isEmpty()) {
                this.noReadString = "NOREAD";
            }
            this.triggerID = this.xmlAttr.parseTagAttribute("TriggerID", parameterData);
            if (!this.triggerID.isEmpty()) {
                this.triggerIDBool = true;
            }
            this.scanResetValue = this.xmlAttr.parseTagAttribute("ResetValue", parameterData);
            if (!this.scanResetValue.isEmpty()) {
                this.scanQueReset = true;
            }
            this.removeLeadChar = this.xmlAttr.parseTagAttribute("RemoveLeadCharacter", parameterData);
            if (!this.removeLeadChar.isEmpty()) {
                this.removeLead = true;
            }
            this.removeTrailChar = this.xmlAttr.parseTagAttribute("RemoveTrailCharacter", parameterData);
            if (!this.removeTrailChar.isEmpty()) {
                this.removeTrail = true;
            }
        }
        return b;
    }

    @Override
    public void interrupt() {
        this.enable = false;
        this.runStatus = false;
        super.interrupt();
    }

    @Override
    public void run() {
    }

    public int openDev() {
        return this.openDev(this.devicePort, this.comBaud, this.comParity, this.comData, this.comStop, this.comFlow, this.rxBufLen, this.txBufLen);
    }

    public int openDev(int port, long baudRate, char parity, int data, int stop, char flow, long rxBufSize, long txBufSize) {
        this.devicePort = port;
        this.comBaud = baudRate;
        this.comParity = parity;
        this.comData = data;
        this.comStop = stop;
        this.comFlow = flow;
        this.serialPort = new SerialPort(this.comPortStr);
        if (!(this.serialPort instanceof SerialPort)) {
            msg.sysMsg("bold+red", this.comPortStr + ": Method openDev - serialPort is not an instanceof SerialPort....");
            return -1;
        }
        if (this.isLinux) {
            int cnt = 0;
            boolean r = true;
            while (r) {
                try {
                    this.serialPort.openPort();
                    msg.sysMsg("bold+black", this.deviceName + ": Port open...");
                    r = false;
                }
                catch (SerialPortException spe) {
                    msg.sysMsg("bold+red", this.deviceName + ": Com exception, port not open - retrying...");
                }
                if (!r) continue;
                WaitTimer wt = new WaitTimer();
                wt.waitFor(1000);
                if (++cnt <= 6) continue;
                r = false;
                msg.sysMsg("bold+red", this.deviceName + ": Com exception, port not open - final fail...");
                return -2;
            }
        } else {
            try {
                this.serialPort.openPort();
            }
            catch (SerialPortException spe) {
                try {
                    this.serialPort.closePort();
                }
                catch (SerialPortException ignored) {
                    // empty catch block
                }
                msg.sysMsg("bold+red", this.deviceName + ": Com exception, port not open...");
                return -2;
            }
        }
        this.comBaudi = (int)baudRate;
        switch (this.comBaudi) {
            case 300: 
            case 600: 
            case 1200: 
            case 2400: 
            case 4800: 
            case 9600: 
            case 19200: 
            case 38400: 
            case 57600: 
            case 152000: {
                break;
            }
            default: {
                try {
                    this.serialPort.closePort();
                }
                catch (SerialPortException ignored) {
                    // empty catch block
                }
                return -12;
            }
        }
        if (parity == 'N') {
            this.comParityi = 0;
        } else if (parity == 'E') {
            this.comParityi = 2;
        } else if (parity == 'O') {
            this.comParityi = 1;
        } else if (parity == 'M') {
            this.comParityi = 3;
        } else if (parity == 'S') {
            this.comParityi = 4;
        } else {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException ignored) {
                // empty catch block
            }
            return -13;
        }
        if (data != 5 && data != 6 && data != 7 && data != 8) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException ignored) {
                // empty catch block
            }
            return -15;
        }
        this.comDatai = data;
        if (stop != 1 && stop != 2) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException ignored) {
                // empty catch block
            }
            return -14;
        }
        this.comStopi = stop;
        if (this.comFlow == 'N') {
            this.comFlowi = 0;
        } else if (this.comFlow == 'S') {
            this.comFlowi = 12;
        } else if (this.comFlow == 'H') {
            this.comFlowi = 3;
        } else if (this.comFlow == 'I') {
            this.comFlowi = 0;
        } else {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException ignored) {
                // empty catch block
            }
            return -16;
        }
        try {
            this.serialPort.setFlowControlMode(this.comFlowi);
        }
        catch (SerialPortException e) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException ignored) {
                // empty catch block
            }
            msg.sysMsg("bold+red", this.deviceName + ": Com exception trying to set flow control...");
            return -16;
        }
        try {
            this.serialPort.setParams(this.comBaudi, this.comDatai, this.comStopi, this.comParityi);
        }
        catch (SerialPortException e) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException ignored) {
                // empty catch block
            }
            msg.sysMsg("bold+red", this.deviceName + ": Com exception trying to set parameters...");
            return -3;
        }
        new Thread(){
            {
                this.start();
            }

            @Override
            public void run() {
                this.setName("ScannerGeneric.startDevice_rx");
                RS232Jssc.this.serialReader = new SerialReader();
                try {
                    int mask = 0;
                    mask = RS232Jssc.this.isLinux ? 32769 : 1;
                    RS232Jssc.this.serialPort.setEventsMask(mask);
                    RS232Jssc.this.serialPort.addEventListener((SerialPortEventListener)RS232Jssc.this.serialReader);
                }
                catch (SerialPortException e) {
                    msg.sysMsg("bold+red", RS232Jssc.this.comPortStr + ": Method openDev " + -17 + ": Too many listeners....");
                    try {
                        RS232Jssc.this.serialPort.closePort();
                    }
                    catch (SerialPortException serialPortException) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        return 1;
    }

    @Override
    public int closeDev() {
        if (this.serialReader != null) {
            // empty if block
        }
        if (this.serialPort != null) {
            try {
                if (this.serialPort.isOpened()) {
                    this.serialPort.closePort();
                }
            }
            catch (SerialPortException is) {
                System.out.println(this.deviceName + ": Method closeDev - Close port exception...");
            }
            this.serialPort = null;
        }
        return 1;
    }

    @Override
    public boolean shutDown(boolean allowMsg) {
        Thread.currentThread().interrupt();
        this.setAllowMsg(allowMsg);
        this.closeDev();
        if (this.rx != null) {
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    this.setName("ScannerGeneric.shutDown_rx");
                    RS232Jssc.this.rx.shutDown(true);
                }
            };
        }
        return true;
    }

    @Override
    public void addObserver(Observer observer) {
        if (this.rx != null) {
            this.rx.addObserver(observer);
        }
    }

    class Receive
    extends Observable
    implements Runnable {
        private boolean runStatus = true;
        private WaitTimer wt = new WaitTimer();

        public synchronized void endWaitCycle() {
            this.wt.endWaitCycle();
        }

        @Override
        public void run() {
            WaitTimer wt = new WaitTimer();
            while (this.runStatus) {
                wt.waitFor(100);
                if (RS232Jssc.this.driverBuf == null) continue;
                try {
                    while (!RS232Jssc.this.driverBuf.isEmpty()) {
                        String line = "";
                        try {
                            line = (String)RS232Jssc.this.driverBuf.remove(0);
                        }
                        catch (ArrayIndexOutOfBoundsException aioob) {
                            continue;
                        }
                        if (line == null || line.isEmpty()) continue;
                        int len = line.length();
                        byte[] inCh = line.getBytes();
                        for (int i = 0; i < len; ++i) {
                            line = this.parseRawData(inCh[i]);
                            if (line.length() <= 0) continue;
                            this.parseData(line);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        private String removeLeadCharacters(String value) {
            if (value.isEmpty()) {
                return "";
            }
            String str = value;
            boolean l = true;
            while (l) {
                if (str.startsWith(RS232Jssc.this.removeLeadChar)) {
                    str = str.substring(1);
                    continue;
                }
                l = false;
            }
            return str;
        }

        private String removeTrailCharacters(String value) {
            if (value.isEmpty()) {
                return "";
            }
            String str = value;
            boolean l = true;
            while (l) {
                if (str.endsWith(RS232Jssc.this.removeTrailChar)) {
                    str = str.substring(0, str.length() - 1);
                    continue;
                }
                l = false;
            }
            return str;
        }

        private void parseData(final String inLine) {
            if (!RS232Jssc.this.enable) {
                return;
            }
            new Thread(){
                {
                    this.start();
                }

                @Override
                public void run() {
                    this.setName("ScannerGeneric.Receive.parseData");
                    String scanValue = inLine;
                    try {
                        if (RS232Jssc.this.removeLead) {
                            scanValue = Receive.this.removeLeadCharacters(scanValue);
                        }
                        if (RS232Jssc.this.removeTrail) {
                            scanValue = Receive.this.removeTrailCharacters(scanValue);
                        }
                        Receive.this.setChanged();
                        Receive.this.notifyObservers(new ScanInput(RS232Jssc.this.dev, RS232Jssc.this.enable, RS232Jssc.this.name, RS232Jssc.this.deviceName, RS232Jssc.this.deviceType, RS232Jssc.this.scanEval, scanValue));
                    }
                    catch (Exception e) {
                        System.out.println(RS232Jssc.this.deviceName + ": Parse exception...");
                    }
                }
            };
        }

        protected String parseRawData(byte inCh) {
            switch (inCh) {
                case 13: {
                    if (RS232Jssc.this.inLine.isEmpty() || !RS232Jssc.this.cr) break;
                    if (!RS232Jssc.this.captureNoRead && !RS232Jssc.this.noReadString.isEmpty() && RS232Jssc.this.inLine.contains(RS232Jssc.this.noReadString)) {
                        RS232Jssc.this.rxCnt = 0L;
                        RS232Jssc.this.inLine = "";
                        return "";
                    }
                    String data = RS232Jssc.this.inLine;
                    RS232Jssc.this.rxCnt = 0L;
                    RS232Jssc.this.inLine = "";
                    if (RS232Jssc.this.debugLocal) {
                        String m = "cr=<" + data + ">";
                        System.out.println(m);
                        msg.sysMsg("bold+black", m);
                    }
                    return data;
                }
                case 10: {
                    if (RS232Jssc.this.inLine.isEmpty() || !RS232Jssc.this.lf) break;
                    if (!RS232Jssc.this.captureNoRead && !RS232Jssc.this.noReadString.isEmpty() && RS232Jssc.this.inLine.contains(RS232Jssc.this.noReadString)) {
                        RS232Jssc.this.rxCnt = 0L;
                        RS232Jssc.this.inLine = "";
                        return "";
                    }
                    String data = RS232Jssc.this.inLine;
                    RS232Jssc.this.rxCnt = 0L;
                    RS232Jssc.this.inLine = "";
                    if (RS232Jssc.this.debugLocal) {
                        String m = "lf=<" + data + ">";
                        System.out.println(m);
                        msg.sysMsg("bold+black", m);
                    }
                    return data;
                }
                case 2: {
                    if (!RS232Jssc.this.stx) break;
                    RS232Jssc.this.rxCnt = 0L;
                    RS232Jssc.this.inLine = "";
                    break;
                }
                case 3: {
                    if (RS232Jssc.this.inLine.isEmpty() || !RS232Jssc.this.etx) break;
                    if (!RS232Jssc.this.captureNoRead && !RS232Jssc.this.noReadString.isEmpty() && RS232Jssc.this.inLine.contains(RS232Jssc.this.noReadString)) {
                        RS232Jssc.this.rxCnt = 0L;
                        RS232Jssc.this.inLine = "";
                        return "";
                    }
                    String data = RS232Jssc.this.inLine;
                    RS232Jssc.this.rxCnt = 0L;
                    RS232Jssc.this.inLine = "";
                    if (RS232Jssc.this.debugLocal) {
                        String m = "etx=<" + data + ">";
                        System.out.println(m);
                        msg.sysMsg("bold+black", m);
                    }
                    return data;
                }
                case 17: {
                    RS232Jssc.this.xOn = true;
                    break;
                }
                case 19: {
                    RS232Jssc.this.xOn = false;
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    break;
                }
                default: {
                    byte chI = inCh;
                    if (chI <= 31 || chI >= 127 || (long)RS232Jssc.this.inLine.length() >= RS232Jssc.this.rxBufLen) break;
                    RS232Jssc.this.inLine = RS232Jssc.this.inLine + (char)inCh;
                    RS232Jssc.this.rxCnt = (RS232Jssc.this.rxCnt + 1L) % RS232Jssc.this.rxBufLen;
                }
            }
            return "";
        }

        public boolean shutDown(boolean allowMsg) {
            this.runStatus = false;
            Thread.currentThread().interrupt();
            return true;
        }
    }

    public class SerialReader
    extends Observable
    implements SerialPortEventListener {
        public synchronized void serialEvent(SerialPortEvent event) {
            if (event == null) {
                return;
            }
            if (event.getEventType() == 32768) {
                new Thread(){
                    {
                        this.start();
                    }

                    @Override
                    public void run() {
                        this.setName("RS232Jssc.serialEvent");
                        RS232Jssc.this.closeDev();
                        RS232Jssc.this.openDev(RS232Jssc.this.devicePort, RS232Jssc.this.comBaud, RS232Jssc.this.comParity, RS232Jssc.this.comData, RS232Jssc.this.comStop, RS232Jssc.this.comFlow, 128L, 128L, RS232Jssc.this.comTOl);
                    }
                };
            } else if (event.getEventType() == 1) {
                int value = event.getEventValue();
                if (value < 1) {
                    return;
                }
                try {
                    byte[] rxBuf = RS232Jssc.this.serialPort.readBytes(value);
                    String vs = new String(rxBuf);
                    if (vs.contains("<Version ")) {
                        return;
                    }
                    RS232Jssc.this.driverBuf.add(vs);
                    RS232Jssc.this.rx.endWaitCycle();
                }
                catch (SerialPortException spe) {
                    String m = RS232Jssc.this.comPortStr + " Receive data exception...";
                }
            }
        }
    }
}

