/*
 * Decompiled with CFR 0.152.
 */
package com.nosoft.mobile.mes.data;

import com.nosoft.mobile.mes.data.DataInterface;
import com.nosoft.mobile.mes.data.FinalData;
import com.nosoft.mobile.mes.devices.DeviceInterface;
import com.nosoft.mobile.mes.devices.serial.RS232Jssc;
import com.nosoft.mobile.mes.devices.server.Server;
import com.nosoft.mobile.mes.factories.XmlFactory;
import com.nosoft.mobile.mes.messages.MessageInterface;
import com.nosoft.mobile.sys.SysInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Data
implements FinalData,
DataInterface {
    protected static DataInterface lmmData = null;
    protected SysInterface sys = null;
    protected MessageInterface msg = null;
    protected DeviceInterface defServer = null;
    protected DeviceInterface defScanner = null;
    protected String name = "Data";
    protected boolean allowMsg = true;
    protected boolean enable = false;
    protected boolean runStatus = false;
    protected String rootFolder = "/home/root/RobotApp/SysRobot/";
    protected String jarFile = "SysRobot.jar";
    protected String cfgFile = "config.xml";
    protected Map devMap = Collections.synchronizedMap(new HashMap());
    protected String gMode = "DHCP";
    protected byte[] gIpAddress;
    protected String gIpAddressStr = "127.0.0.1";
    protected byte[] gMACaddr = new byte[6];
    protected String gMACaddrStr = "";
    protected String gMACaddrConfigStr = "";
    protected int gLocalPort;
    protected String gNetMask = "255.255.255.0";
    protected String gGateway = "0.0.0.0";
    protected String company;
    protected String moduleName;
    protected String moduleAliasName;
    protected int moduleNumber;
    protected String transactionType;
    protected int transactionMode;
    protected int buttonTotal;
    protected int scanPrefixSkip;
    protected String loggedOnUser;
    protected String loggedOnSuperUser;
    protected String bootScanWord = "";
    protected String errorMsg = "";
    protected String gPrinter;
    protected boolean debug = false;

    public Data() {
        Data.setDataHandle(this);
    }

    public Data(boolean allowMsg, boolean enable) {
        this();
        this.allowMsg = allowMsg;
        this.enable = enable;
    }

    public Data(SysInterface sys, boolean allowMsg, boolean enable) {
        this(allowMsg, enable);
        this.sys = sys;
    }

    public static DataInterface getDataHandle() {
        return lmmData;
    }

    public static void setDataHandle(Data aLmmData) {
        lmmData = aLmmData;
    }

    private boolean getLocalNetworkInfo() {
        try {
            Document doc = null;
            InetAddress ip = InetAddress.getLocalHost();
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                int zeroCounter = 0;
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    if (mac[i] == 0) {
                        ++zeroCounter;
                    }
                    if (zeroCounter <= 2) continue;
                }
                if (mac.length != 6) continue;
                this.setgMACaddr(mac);
                doc = this.getNetworkConfig();
                if (doc == null) continue;
                this.writeDomDoc(doc, this.rootFolder + "/config/config.xml");
                this.msg.sysMsg("bold+black", "MAC: " + this.getMACaddrString());
                return true;
            }
        }
        catch (UnknownHostException e) {
            this.msg.sysMsg("bold+red", "Err: Unknown host...");
        }
        catch (SocketException e) {
            this.msg.sysMsg("bold+red", "Err: Socket exception...");
        }
        return false;
    }

    @Override
    public boolean doSetup() {
        if (!this.getLocalNetworkInfo()) {
            this.parse(this.rootFolder + "/config/config.xml");
        }
        if (!this.configureSetup(lmmData)) {
            // empty if block
        }
        return true;
    }

    public Document parse(String file) {
        File xmlFile = new File(file);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(xmlFile);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            return null;
        }
        return this.parseConfigurationDoc(doc);
    }

    public Document parseConfigurationDoc(Document doc) {
        if (doc != null) {
            doc.getDocumentElement().normalize();
            NodeList nListP = doc.getChildNodes();
            for (int n = 0; n < nListP.getLength(); ++n) {
                Node pn = nListP.item(n);
                if (!pn.getNodeName().matches("SystemSchema")) continue;
                NodeList nList = pn.getChildNodes();
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Node cNode = nList.item(temp);
                    if (cNode.getNodeType() != 1) continue;
                    Element eElement = (Element)cNode;
                    if (eElement.getNodeName().matches("MessagePanel")) {
                        this.msg.xmlConfigDevice(cNode);
                        continue;
                    }
                    if (eElement.getNodeName().matches("SystemProperties")) {
                        this.parseSystemProperties(cNode);
                        continue;
                    }
                    if (eElement.getNodeName().matches("Devices")) {
                        this.setupDevices(cNode);
                        continue;
                    }
                    System.out.println("Skipping unknown Node: " + eElement.getNodeName());
                }
            }
        }
        return doc;
    }

    public void writeDomDoc(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            this.msg.sysMsg("bold+red", "Err: Transform XML cfg to file...");
        }
        catch (TransformerException e) {
            this.msg.sysMsg("bold+red", "Err: Transform XML to file...");
        }
    }

    private void parseSystemProperties(Node node) {
        NodeList nList = node.getChildNodes();
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node cNode = nList.item(temp);
            if (cNode.getNodeType() != 1) continue;
            Element eElement = (Element)cNode;
            if (eElement.getNodeName().matches("Company")) {
                this.setCompany(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("ModuleName")) {
                this.setModuleName(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("ModuleAlias")) {
                this.setAliasName(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("ModuleNumber")) {
                this.setModuleNumber(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("IPAddress")) {
                this.setLocalIp(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("Netmask")) {
                this.setNetMask(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("Gateway")) {
                this.setGateway(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("TransactionType")) {
                this.setTransactionType(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("TransactionMode")) {
                this.setTransactionMode(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("ButtonTotal")) {
                this.setButtonTotal(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("ScanPrefixSkip")) {
                this.setScanPrefixSkip(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("BootScanWord")) {
                this.setBootScanWord(eElement.getTextContent());
                continue;
            }
            if (eElement.getNodeName().matches("SystemDebug")) {
                this.setDebug("true".equalsIgnoreCase(eElement.getTextContent()));
                continue;
            }
            System.out.println("parseInit unknown Node: " + eElement.getNodeName());
        }
    }

    public boolean setupDevices(Node nd) {
        NodeList nList = nd.getChildNodes();
        if (nList != null) {
            int nlTot = nList.getLength();
            for (int i = 0; i < nlTot; ++i) {
                DeviceInterface d = null;
                nd = nList.item(i);
                String name = nd.getNodeName();
                if (name.equalsIgnoreCase("null") || name.equalsIgnoreCase("#text") || name.equalsIgnoreCase("#comment")) continue;
                String deviceName = "";
                String alloc = "";
                if ("Server".equals(name)) {
                    deviceName = this.getTagValue(nd, "Name");
                    alloc = "Server";
                    this.defServer = d = new Server(this.allowMsg, true, nd);
                } else if ("RS232".equals(name)) {
                    deviceName = this.getTagValue(nd, "DeviceName");
                    String driverName = this.getTagValue(nd, "DriverName");
                    if (!driverName.toLowerCase().equals("jssc")) continue;
                    alloc = "RS232Jssc";
                    d = new RS232Jssc(this.allowMsg, true, nd);
                    String sc = this.getTagValue(nd, "DeviceType").toLowerCase();
                    if (sc.contains("scanner")) {
                        this.defScanner = d;
                    }
                }
                if (d == null || !d.getEnable()) continue;
                this.devMap.put(deviceName, d);
                this.msg.sysMsg("black", alloc + " device allocated ...");
            }
        }
        return true;
    }

    public String getTagValue(Node xmlnode, String tag) {
        NodeList nodes = xmlnode.getChildNodes();
        String name = XmlFactory.lookupValue(nodes, tag);
        return name;
    }

    public Document getConfig(DataInterface lmmData, String file) {
        return this.parse(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getNetworkConfig() {
        Document document;
        Document doc = null;
        String srvr = this.sys.getMesServerCmdLineIp();
        if (srvr.contains("127.0.0.1")) {
            this.msg.sysMsg("bold+red", "Err: Server IP = '127.0.0.1'...");
            return null;
        }
        String urlData = "http://" + srvr + ":2080/config " + "<TransmitFile PID=\"57\" " + "Name=\"downloads/mobiles/" + this.getMACaddrConfigString() + "_config.xml\" DataType=\"xml\" />";
        InputStream instream = null;
        try {
            URL url = new URL(urlData);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(20000);
            con.setReadTimeout(20000);
            instream = con.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(instream);
            if (doc == null) {
                this.msg.sysMsg("bold+red", "Err: XML Doc = null...");
                Document document2 = null;
                return document2;
            }
            this.parseConfigurationDoc(doc);
        }
        catch (SocketTimeoutException ste) {
            this.msg.sysMsg("bold+red", "Err: Config URL Timeout...");
            document = null;
            return document;
        }
        catch (IOException e) {
            this.msg.sysMsg("bold+red", "Err: Config IO - No server connection...");
            document = null;
            return document;
        }
        catch (SAXException ex) {
            this.msg.sysMsg("bold+red", "Err: Config URL SAX...");
            document = null;
            return document;
        }
        catch (ParserConfigurationException ex) {
            this.msg.sysMsg("bold+red", "Err: Config URL Parse...");
            document = null;
            return document;
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException ex) {}
            }
            if (doc == null) {
                this.msg.sysMsg("bold+red", "Config on server not available, trying local drive...");
            }
        }
        return doc;
    }

    public boolean configureSetup(DataInterface gData) {
        return true;
    }

    public boolean shutDownDevices() {
        Set set = this.devMap.keySet();
        for (String key : set) {
            DeviceInterface di;
            if (key == null || key.isEmpty() || (di = (DeviceInterface)this.devMap.get(key)) == null) continue;
            di.shutDown(true);
        }
        return true;
    }

    @Override
    public boolean shutDown(boolean allowMsg) {
        this.setEnable(false);
        this.setAllowMsg(allowMsg);
        this.shutDownDevices();
        return true;
    }

    public boolean isAllowMsg() {
        return this.allowMsg;
    }

    public void setAllowMsg(boolean allowMsg) {
        this.allowMsg = allowMsg;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Override
    public String getHomePath() {
        return this.rootFolder;
    }

    @Override
    public String getJarFile() {
        return this.rootFolder + "dist/" + this.jarFile;
    }

    @Override
    public String getConfigFile() {
        return this.rootFolder + this.cfgFile;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setModuleName(String Name) {
        this.moduleName = Name;
    }

    @Override
    public byte[] getMACaddr() {
        return this.gMACaddr;
    }

    @Override
    public void setgMACaddr(byte[] gMACaddr) {
        this.gMACaddr = gMACaddr;
        if (gMACaddr == null) {
            this.gMACaddrStr = "00:00:00:00:00:00";
            this.gMACaddrConfigStr = "00_00_00_00_00_00";
        } else if (gMACaddr.length < 6) {
            this.gMACaddrStr = "00:00:00:00:00:00";
            this.gMACaddrConfigStr = "00_00_00_00_00_00";
        } else {
            this.gMACaddrStr = String.format("%02X:%02X:%02X:%02X:%02X:%02X", gMACaddr[0] & 0xFF, gMACaddr[1] & 0xFF, gMACaddr[2] & 0xFF, gMACaddr[3] & 0xFF, gMACaddr[4] & 0xFF, gMACaddr[5] & 0xFF);
            this.gMACaddrConfigStr = String.format("%02X_%02X_%02X_%02X_%02X_%02X", gMACaddr[0] & 0xFF, gMACaddr[1] & 0xFF, gMACaddr[2] & 0xFF, gMACaddr[3] & 0xFF, gMACaddr[4] & 0xFF, gMACaddr[5] & 0xFF);
        }
        System.out.println(this.gMACaddrConfigStr);
    }

    @Override
    public String getMACaddrString() {
        return this.gMACaddrStr;
    }

    @Override
    public String getMACaddrConfigString() {
        return this.gMACaddrConfigStr;
    }

    @Override
    public void setMacAddrStr(String macAddr) {
        this.gMACaddrStr = macAddr;
    }

    @Override
    public byte[] geLocaltIpByteArray() {
        return this.gIpAddress;
    }

    @Override
    public String getLocalIp() {
        return this.gIpAddressStr;
    }

    @Override
    public void setLocalIp(String IpAddress) {
        this.gIpAddressStr = IpAddress;
    }

    @Override
    public void setLocalIpByteArray(byte[] IpAddress) {
        this.gIpAddress = IpAddress;
        this.gIpAddressStr = IpAddress == null ? "127.0.0.1" : (IpAddress.length < 4 ? "127.0.0.1" : "" + (IpAddress[0] & 0xFF) + "." + (IpAddress[1] & 0xFF) + "." + (IpAddress[2] & 0xFF) + "." + (IpAddress[3] & 0xFF));
    }

    @Override
    public int getLocalPort() {
        return this.gLocalPort;
    }

    @Override
    public void setLocalPort(int LocalPort) {
        this.gLocalPort = LocalPort;
    }

    @Override
    public String getBootMode() {
        return this.gMode;
    }

    @Override
    public void setBootMode(String gMode) {
        this.gMode = gMode;
    }

    @Override
    public String getNetMask() {
        return this.gNetMask;
    }

    @Override
    public void setNetMask(String gNetMask) {
        this.gNetMask = gNetMask;
    }

    @Override
    public String getGateway() {
        return this.gGateway;
    }

    @Override
    public void setGateway(String gGateway) {
        this.gGateway = gGateway;
    }

    public String getPrinter() {
        return this.gPrinter;
    }

    public void setPrinter(String Printer) {
        this.gPrinter = Printer;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public String getAliasName() {
        return this.moduleAliasName;
    }

    @Override
    public void setAliasName(String aliasName) {
        this.moduleAliasName = aliasName;
    }

    @Override
    public int getModuleNumber() {
        return this.moduleNumber;
    }

    @Override
    public void setModuleNumber(String bayNumber) {
        try {
            this.moduleNumber = Integer.parseInt(bayNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getTransactionType() {
        return this.transactionType;
    }

    @Override
    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType.toLowerCase();
    }

    @Override
    public int getTransactionMode() {
        return this.transactionMode;
    }

    @Override
    public void setTransactionMode(String transactionMode) {
        try {
            this.transactionMode = Integer.parseInt(transactionMode);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public int getButtonTotal() {
        return this.buttonTotal;
    }

    @Override
    public void setButtonTotal(String buttonTotal) {
        try {
            this.buttonTotal = Integer.parseInt(buttonTotal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getBootScanWord() {
        return this.bootScanWord;
    }

    @Override
    public void setBootScanWord(String bootScanWord) {
        this.bootScanWord = bootScanWord;
    }

    @Override
    public String getLoggedOnUser() {
        return this.loggedOnUser;
    }

    @Override
    public void setLoggedOnUser(String loggedOnUser) {
        this.loggedOnUser = loggedOnUser;
    }

    @Override
    public String getLoggedOnSuperUser() {
        return this.loggedOnSuperUser;
    }

    @Override
    public void setLoggedOnSuperUser(String loggedOnSuperUser) {
        this.loggedOnSuperUser = loggedOnSuperUser;
    }

    @Override
    public String getErrorMsg() {
        String msg = new String(this.errorMsg);
        this.errorMsg = "";
        return msg;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public int getScanPrefixSkip() {
        return this.scanPrefixSkip;
    }

    @Override
    public void setScanPrefixSkip(String scanPrefixSkip) {
        try {
            this.scanPrefixSkip = Integer.parseInt(scanPrefixSkip);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getMesServerIp() {
        if (this.defServer == null) {
            return "127.0.0.1";
        }
        return this.defServer.getServerIpAddressStr();
    }

    @Override
    public String getWebServerIp() {
        if (this.defServer == null) {
            return "127.0.0.1";
        }
        return this.defServer.getWebServerIpAddress();
    }

    @Override
    public int getMesServerPort() {
        if (this.defServer == null) {
            return 2014;
        }
        return this.defServer.getServerPort();
    }

    @Override
    public int getWebServerPort() {
        if (this.defServer == null) {
            return 2080;
        }
        return this.defServer.getWebServerPort();
    }

    @Override
    public int getMesTransactionPort() {
        if (this.defServer == null) {
            return 2080;
        }
        return this.defServer.getTransactionPort();
    }

    @Override
    public int getTTL() {
        if (this.defServer == null) {
            return 2080;
        }
        return this.defServer.getTTL();
    }

    @Override
    public String getServerBusinessURL() {
        if (this.defServer == null) {
            return "";
        }
        return this.defServer.getServerBusinessURL();
    }

    @Override
    public DeviceInterface getDefaultScanner() {
        return this.defScanner;
    }
}

