/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Portmapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class LinuxSerial
extends SerialPort {
    private int port_fd = 0;
    private int rcvThreshold = -1;
    private int rcvTimeout = -1;
    private int framing_byte = -1;
    private int ibuffer_size = 1024;
    private int obuffer_size = 1024;
    private SerialPortEventListener listener = null;
    private SSCheckStatusThread checkStatus = null;
    private SSReaderThread readerThread = null;
    private SSInputStream inputStream = null;
    private SSOutputStream outputStream = null;
    private int baud = 9600;
    private int databits = 8;
    private int parity = 0;
    private int stopbits = 1;
    private int flowcontrol = 0;
    private boolean portInError = false;
    private boolean write_finished_flag = false;
    private Object write_finished_flag_lock = new Object();
    private static final int STATUS_DTR = 1;
    private static final int STATUS_RTS = 2;
    private static final int STATUS_CTS = 4;
    private static final int STATUS_DSR = 8;
    private static final int STATUS_RI = 16;
    private static final int STATUS_CD = 32;
    private static final int STATUS_DATA_AVAIL = 1;
    private static final int STATUS_OUTPUTEMPTY = 2;
    private int notificationMask = 0;
    private static final int NOTIFY_DataAvailable = 1;
    private static final int NOTIFY_OutputEmpty = 2;
    private static final int NOTIFY_CTS = 4;
    private static final int NOTIFY_DSR = 8;
    private static final int NOTIFY_RingIndicator = 16;
    private static final int NOTIFY_CarrierDetect = 32;
    private static final int NOTIFY_OverrunError = 64;
    private static final int NOTIFY_ParityError = 128;
    private static final int NOTIFY_FramingError = 256;
    private static final int NOTIFY_BreakInterrupt = 512;

    public LinuxSerial(String theName) throws IOException {
        this.name = theName;
        if (this.port_fd != 0) {
            return;
        }
        String portName = Portmapping.translatePortname(theName);
        if (System.getProperty("debug_portmap") != null) {
            System.err.println("LinuxSerial(" + theName + ") = " + portName);
        }
        try {
            this.port_fd = this.nativeOpenPort(portName);
        }
        catch (IOException e) {
            throw new IOException("  Error opening \"" + portName + "\"\n  " + e.getMessage());
        }
        try {
            this.nativeSetSerialPortParams(this.port_fd, this.baud, this.databits, this.stopbits, this.parity, this.flowcontrol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readerThread = new SSReaderThread();
        this.readerThread.start();
    }

    private native int nativeOpenPort(String var1) throws IOException;

    public int getBaudRate() {
        if (this.port_fd != 0) {
            return this.nativeGetBaudRate(this.port_fd);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeGetBaudRate(int var1);

    public int getDataBits() {
        if (this.port_fd != 0) {
            return this.nativeGetDataBits(this.port_fd);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeGetDataBits(int var1);

    public int getStopBits() {
        if (this.port_fd != 0) {
            return this.nativeGetStopBits(this.port_fd);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeGetStopBits(int var1);

    public int getParity() {
        if (this.port_fd != 0) {
            return this.nativeGetParity(this.port_fd);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeGetParity(int var1);

    public void sendBreak(int millis) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.nativeSendBreak(this.port_fd, millis);
    }

    private native void nativeSendBreak(int var1, int var2);

    public int getFlowControlMode() {
        if (this.port_fd != 0) {
            return this.nativeGetFlowControlMode(this.port_fd);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeGetFlowControlMode(int var1);

    public int getInputBufferSize() {
        return this.ibuffer_size;
    }

    public void setInputBufferSize(int size) {
        this.ibuffer_size = size;
    }

    public int getOutputBufferSize() {
        return this.obuffer_size;
    }

    public void disableReceiveTimeout() {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.rcvTimeout = -1;
    }

    public void enableReceiveTimeout(int timeout) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        if (timeout < 0) {
            throw new UnsupportedCommOperationException("This timeout value is not supported");
        }
        this.rcvTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout != -1;
    }

    public void setOutputBufferSize(int size) {
        this.obuffer_size = size;
    }

    public boolean isCD() {
        if (this.port_fd != 0) {
            return (this.nativeGetStatusFlags(this.port_fd) & 0x20) > 0;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isCTS() {
        if (this.port_fd != 0) {
            return (this.nativeGetStatusFlags(this.port_fd) & 4) > 0;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isDSR() {
        if (this.port_fd != 0) {
            return (this.nativeGetStatusFlags(this.port_fd) & 8) > 0;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isDTR() {
        if (this.port_fd != 0) {
            return (this.nativeGetStatusFlags(this.port_fd) & 1) > 0;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isRI() {
        if (this.port_fd != 0) {
            return (this.nativeGetStatusFlags(this.port_fd) & 0x10) > 0;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isRTS() {
        if (this.port_fd != 0) {
            return (this.nativeGetStatusFlags(this.port_fd) & 2) > 0;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeGetStatusFlags(int var1);

    public void setDTR(boolean dtr) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.nativeSetDTR(this.port_fd, dtr);
    }

    private native void nativeSetDTR(int var1, boolean var2);

    public void setRTS(boolean rts) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.nativeSetRTS(this.port_fd, rts);
    }

    private native void nativeSetRTS(int var1, boolean var2);

    public boolean isReceiveFramingEnabled() {
        return this.framing_byte != -1;
    }

    public void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.framing_byte = framingByte & 0xFF;
        this.nativeSetFramingByte(this.port_fd, this.framing_byte);
    }

    public void disableReceiveFraming() {
        this.framing_byte = -1;
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.nativeSetFramingByte(this.port_fd, this.framing_byte);
    }

    public int getReceiveFramingByte() {
        return this.framing_byte;
    }

    private native void nativeSetFramingByte(int var1, int var2);

    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold >= 0;
    }

    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (thresh < 0) {
            throw new UnsupportedCommOperationException("This threshold value is not supported");
        }
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.rcvThreshold = thresh;
    }

    public void disableReceiveThreshold() {
        if (this.port_fd <= 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.rcvThreshold = -1;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void setSerialPortParams(int baudrate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        if (dataBits < 5 || dataBits > 8) {
            throw new UnsupportedCommOperationException("Unsupported number of databits");
        }
        if (stopBits != 1 && stopBits != 2 && stopBits != 3) {
            throw new UnsupportedCommOperationException("Unsupported number of stopbits");
        }
        if (parity != 2 && parity != 1 && parity != 0) {
            throw new UnsupportedCommOperationException("Unsupported parity value");
        }
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.nativeSetSerialPortParams(this.port_fd, baudrate, dataBits, stopBits, parity, this.flowcontrol);
        this.baud = baudrate;
        this.databits = dataBits;
        this.stopbits = stopBits;
        this.parity = parity;
    }

    private native void nativeSetSerialPortParams(int var1, int var2, int var3, int var4, int var5, int var6);

    public void setFlowControlMode(int FlowControl) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new UnsupportedCommOperationException("This port has not been opened yet");
        }
        if ((FlowControl & 3) != 0 && (FlowControl & 0xC) != 0) {
            throw new UnsupportedCommOperationException("Cannot mix hardware and software flow control");
        }
        try {
            this.nativeSetSerialPortParams(this.port_fd, this.baud, this.databits, this.stopbits, this.parity, FlowControl);
            this.flowcontrol = FlowControl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        this.notificationMask &= 0xFFFFFDFF;
        if (enable) {
            this.notificationMask |= 0x200;
        }
    }

    public void notifyOnCarrierDetect(boolean enable) {
        this.notificationMask &= 0xFFFFFFDF;
        if (enable) {
            this.notificationMask |= 0x20;
        }
    }

    public void notifyOnCTS(boolean enable) {
        this.notificationMask &= 0xFFFFFFFB;
        if (enable) {
            this.notificationMask |= 4;
        }
    }

    public void notifyOnDataAvailable(boolean enable) {
        this.notificationMask &= 0xFFFFFFFE;
        if (enable) {
            this.notificationMask |= 1;
        }
    }

    public void notifyOnDSR(boolean enable) {
        this.notificationMask &= 0xFFFFFFF7;
        if (enable) {
            this.notificationMask |= 8;
        }
    }

    public void notifyOnFramingError(boolean enable) {
        this.notificationMask &= 0xFFFFFEFF;
        if (enable) {
            this.notificationMask |= 0x100;
        }
    }

    public void notifyOnOutputEmpty(boolean enable) {
        this.notificationMask &= 0xFFFFFFFD;
        if (enable) {
            this.notificationMask |= 2;
        }
    }

    public void notifyOnOverrunError(boolean enable) {
        this.notificationMask &= 0xFFFFFFBF;
        if (enable) {
            this.notificationMask |= 0x40;
        }
    }

    public void notifyOnParityError(boolean enable) {
        this.notificationMask &= 0xFFFFFF7F;
        if (enable) {
            this.notificationMask = this.notificationMask |= 0x80;
        }
    }

    public void notifyOnRingIndicator(boolean enable) {
        this.notificationMask &= 0xFFFFFFEF;
        if (enable) {
            this.notificationMask |= 0x10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.port_fd == 0) {
            super.close();
            return;
        }
        try {
            this.nativeClosePort(this.port_fd);
            this.port_fd = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    private native void nativeClosePort(int var1);

    private native int nativeAvailable(int var1);

    private native int nativeRead(int var1, byte[] var2, int var3, int var4, int var5, int var6);

    private native int nativeWrite(int var1, byte[] var2, int var3, int var4);

    private native int nativeFlush(int var1);

    private native void nativeWaitForEvent(int var1);

    private native int nativeCheckBreak(int var1);

    private native int nativeCheckParityErrors(int var1);

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        if (this.port_fd != 0) {
            if (this.listener != null) {
                throw new TooManyListenersException("Only one listener is allowed");
            }
            this.listener = lsnr;
            if (this.checkStatus == null) {
                this.checkStatus = new SSCheckStatusThread();
            }
        } else {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.checkStatus.start();
    }

    public void removeEventListener() {
        this.listener = null;
        this.port_fd = 0;
    }

    public InputStream getInputStream() throws IOException {
        if (this.port_fd != 0) {
            if (this.inputStream == null) {
                this.inputStream = new SSInputStream();
            }
            return this.inputStream;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.port_fd != 0) {
            if (this.outputStream == null) {
                this.outputStream = new SSOutputStream();
            }
            return this.outputStream;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    private native int nativeReaderThread(int var1);

    static {
        System.loadLibrary("LinuxSerialParallel");
    }

    private class SSReaderThread
    extends Thread {
        private SSReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LinuxSerial.this.nativeReaderThread(LinuxSerial.this.port_fd) < 0) {
                LinuxSerial linuxSerial = LinuxSerial.this;
                synchronized (linuxSerial) {
                    LinuxSerial.this.portInError = true;
                }
            }
        }
    }

    private class SSCheckStatusThread
    extends Thread {
        private boolean lastCD;
        private boolean lastRI;
        private boolean lastCTS;
        private boolean lastDSR;
        private boolean lastOE;
        private boolean lastPE;
        private boolean lastFE;
        private boolean lastBI;

        private SSCheckStatusThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.lastCD = LinuxSerial.this.isCD();
            this.lastRI = LinuxSerial.this.isRI();
            this.lastDSR = LinuxSerial.this.isDSR();
            this.lastCTS = LinuxSerial.this.isCTS();
            while (LinuxSerial.this.port_fd != 0) {
                boolean newRI;
                int statusFlag;
                int npar;
                LinuxSerial.this.nativeWaitForEvent(LinuxSerial.this.port_fd);
                if (LinuxSerial.this.port_fd == 0) break;
                if (LinuxSerial.this.nativeAvailable(LinuxSerial.this.port_fd) > 0) {
                    this.RaiseEvent(LinuxSerial.this.notificationMask, 1, 1, false, true);
                }
                if (LinuxSerial.this.port_fd == 0) break;
                Object object = LinuxSerial.this.write_finished_flag_lock;
                synchronized (object) {
                    if (LinuxSerial.this.write_finished_flag) {
                        LinuxSerial.this.write_finished_flag = false;
                        this.RaiseEvent(LinuxSerial.this.notificationMask, 2, 2, false, true);
                    }
                }
                if (LinuxSerial.this.port_fd == 0) break;
                int nbrks = LinuxSerial.this.nativeCheckBreak(LinuxSerial.this.port_fd);
                if (nbrks > 0) {
                    while (nbrks-- > 0) {
                        this.RaiseEvent(LinuxSerial.this.notificationMask, 512, 10, false, true);
                        if (LinuxSerial.this.port_fd != 0) continue;
                    }
                }
                if ((npar = LinuxSerial.this.nativeCheckParityErrors(LinuxSerial.this.port_fd)) > 0) {
                    while (npar-- > 0) {
                        this.RaiseEvent(LinuxSerial.this.notificationMask, 128, 8, false, true);
                        if (LinuxSerial.this.port_fd != 0) continue;
                    }
                }
                boolean newCD = ((statusFlag = LinuxSerial.this.nativeGetStatusFlags(LinuxSerial.this.port_fd)) & 0x20) > 0;
                boolean newDSR = (statusFlag & 8) > 0;
                boolean newCTS = (statusFlag & 4) > 0;
                boolean bl = newRI = (statusFlag & 0x10) > 0;
                if (newCD != this.lastCD) {
                    this.RaiseEvent(LinuxSerial.this.notificationMask, 32, 6, this.lastCD, newCD);
                    this.lastCD = newCD;
                }
                if (LinuxSerial.this.port_fd == 0) break;
                if (newDSR != this.lastDSR) {
                    this.RaiseEvent(LinuxSerial.this.notificationMask, 8, 4, this.lastDSR, newDSR);
                    this.lastDSR = newDSR;
                }
                if (LinuxSerial.this.port_fd == 0) break;
                if (newCTS != this.lastCTS) {
                    this.RaiseEvent(LinuxSerial.this.notificationMask, 4, 3, this.lastCTS, newCTS);
                    this.lastCTS = newCTS;
                }
                if (LinuxSerial.this.port_fd == 0) break;
                if (newRI != this.lastRI) {
                    this.RaiseEvent(LinuxSerial.this.notificationMask, 16, 5, this.lastRI, newRI);
                    this.lastRI = newRI;
                }
                if (LinuxSerial.this.port_fd != 0) continue;
                break;
            }
        }

        private void RaiseEvent(int notificationMask, int event_notify_bit, int event, boolean lastValue, boolean newValue) {
            if (LinuxSerial.this.listener != null && lastValue != newValue && (notificationMask & event_notify_bit) != 0) {
                LinuxSerial.this.listener.serialEvent(new SerialPortEvent(LinuxSerial.this, event, lastValue, newValue));
            }
        }
    }

    public class SSOutputStream
    extends OutputStream {
        public void write(int b) throws IOException {
            byte[] tmpbuf = new byte[]{(byte)b};
            this.write(tmpbuf, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int offset, int len) throws IOException {
            int write_up_to = len;
            int status = 0;
            if (LinuxSerial.this.port_fd != 0) {
                if (b != null) {
                    if (len + offset > b.length) {
                        write_up_to = b.length - offset;
                    }
                    status = LinuxSerial.this.nativeWrite(LinuxSerial.this.port_fd, b, offset, write_up_to);
                    Object object = LinuxSerial.this.write_finished_flag_lock;
                    synchronized (object) {
                        LinuxSerial.this.write_finished_flag = true;
                    }
                }
            } else {
                throw new IOException("This port has not been opened yet");
            }
        }

        public void flush() throws IOException {
            int status = -1;
            if (LinuxSerial.this.port_fd != 0) {
                status = LinuxSerial.this.nativeFlush(LinuxSerial.this.port_fd);
                if (status == -1) {
                    throw new IOException("Failed to flush OutputStream");
                }
            } else {
                throw new IOException("This port has not been opened yet");
            }
        }
    }

    public class SSInputStream
    extends InputStream {
        public int available() throws IOException {
            if (LinuxSerial.this.portInError) {
                return Integer.MAX_VALUE;
            }
            if (LinuxSerial.this.port_fd != 0) {
                return LinuxSerial.this.nativeAvailable(LinuxSerial.this.port_fd);
            }
            throw new IOException("This port has not been opened yet");
        }

        public int read(byte[] b, int offset, int len) throws IOException {
            int read_up_to = len;
            int status = 0;
            if (b == null) {
                throw new NullPointerException("input NullPointer in read");
            }
            if (len + offset > b.length) {
                read_up_to = b.length - offset;
            }
            if (LinuxSerial.this.port_fd != 0) {
                status = LinuxSerial.this.nativeRead(LinuxSerial.this.port_fd, b, offset, read_up_to, LinuxSerial.this.rcvTimeout, LinuxSerial.this.rcvThreshold);
                return status;
            }
            throw new IOException("This port has not been opened yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            int ret = 0;
            byte[] tmpbuf = new byte[1];
            SSInputStream sSInputStream = this;
            synchronized (sSInputStream) {
                if (LinuxSerial.this.portInError) {
                    this.close();
                    throw new IOException("Port closed due to error");
                }
            }
            if (LinuxSerial.this.port_fd != 0) {
                ret = LinuxSerial.this.nativeRead(LinuxSerial.this.port_fd, tmpbuf, 0, 1, LinuxSerial.this.rcvTimeout, LinuxSerial.this.rcvThreshold);
                if (ret == 1) {
                    return tmpbuf[0] & 0xFF;
                }
                return -1;
            }
            throw new IOException("This port has not been opened yet");
        }
    }
}

