/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.comm.ParallelPort;
import javax.comm.UnsupportedCommOperationException;

public class ReceiveFraming
extends Panel
implements MouseListener,
ActionListener {
    private int value;
    private int defaultValue;
    private Label label;
    private TextField data;
    private ParallelPort port = null;
    private boolean inputBuffer;

    public ReceiveFraming(int n, ParallelPort parallelPort) {
        this.setPort(parallelPort);
        this.inputBuffer = this.inputBuffer;
        this.setLayout((LayoutManager)new BorderLayout());
        this.label = new Label("Framing");
        this.label.addMouseListener((MouseListener)this);
        this.add("West", (Component)this.label);
        this.data = new TextField(new Integer(this.defaultValue).toString(), n);
        this.data.addActionListener((ActionListener)this);
        this.add("East", (Component)this.data);
        this.showValue();
        this.defaultValue = this.value;
    }

    public void setPort(ParallelPort parallelPort) {
        this.port = parallelPort;
    }

    public int getValue() {
        this.value = this.port != null && this.port.isReceiveFramingEnabled() ? this.port.getReceiveFramingByte() : 0;
        return this.value;
    }

    public void showValue() {
        this.data.setText("0x" + Integer.toString(this.getValue(), 16));
    }

    public void setValue(int n) {
        if (this.port != null) {
            if (n > 0) {
                try {
                    this.port.enableReceiveFraming(n);
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                    unsupportedCommOperationException.printStackTrace();
                }
            } else {
                this.port.disableReceiveFraming();
            }
        }
        this.showValue();
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            this.setValue(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Bad value = 0x" + actionEvent.getActionCommand());
            this.showValue();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setValue(this.defaultValue);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

