/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEvent;
import javax.comm.ParallelPortEventListener;
import javax.comm.PortInUseException;

public class ParallelPortDisplay
extends Panel
implements ParallelPortEventListener,
MouseListener,
CommPortOwnershipListener {
    protected CommPortIdentifier portID;
    protected ParallelPort port = null;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream outSave;
    protected boolean lineMonitor;
    protected boolean open = false;
    private int rcvDelay;
    private Thread rcvThread = null;
    private ParallelBlackBox owner;
    private boolean threadRcv;
    private boolean friendly;
    private boolean waiting = false;
    Panel display;
    Panel textPanel;
    Label portName = null;
    LPTMode mode;
    CtlSigDisplay ctlSigs;
    Receiver receiver;
    Transmitter transmitter;

    public ParallelPortDisplay(CommPortIdentifier commPortIdentifier, boolean bl, boolean bl2, int n, ParallelBlackBox parallelBlackBox) throws PortInUseException {
        this.setLayout((LayoutManager)new BorderLayout());
        this.owner = parallelBlackBox;
        this.lineMonitor = false;
        this.outSave = null;
        this.portID = commPortIdentifier;
        this.threadRcv = bl;
        this.friendly = bl2;
        this.rcvDelay = n;
        this.openPBBPort();
    }

    private boolean openPBBPort() throws PortInUseException {
        if (this.open) {
            this.closePBBPort();
        }
        this.portID.addPortOwnershipListener((CommPortOwnershipListener)this);
        try {
            this.port = (ParallelPort)this.portID.open("ParallelBlackBox", 2000);
            if (this.port == null) {
                System.out.println("Error opening port " + this.portID.getName());
                return false;
            }
            this.open = true;
            this.waiting = false;
            if (this.portName != null) {
                this.portName.setForeground(Color.green);
            }
            try {
                this.in = this.port.getInputStream();
            }
            catch (IOException iOException) {
                System.out.println(this.portID.getName() + ": Input stream unavailable - warning only.");
            }
            if (this.in != null) {
                System.out.println(this.portID.getName() + ": Opened input stream.");
            }
            try {
                this.out = this.port.getOutputStream();
            }
            catch (IOException iOException) {
                System.out.println("Fatal Error: Cannot open output stream");
                System.exit(-1);
            }
            if (this.out != null) {
                System.out.println(this.portID.getName() + ": Opened output stream.");
            }
            this.createPanel();
            this.showValues();
            try {
                this.port.addEventListener((ParallelPortEventListener)this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
            this.port.notifyOnBuffer(true);
            this.port.notifyOnError(true);
            if (this.threadRcv && this.rcvThread == null) {
                this.rcvThread = new Thread((Runnable)this.receiver, "Rcv " + this.port.getName());
                this.rcvThread.start();
            } else {
                this.rcvThread = null;
            }
        }
        catch (PortInUseException portInUseException) {
            System.out.println("Queueing open for " + this.portID.getName() + ": port in use by " + portInUseException.currentOwner);
            if (this.portName != null) {
                this.portName.setForeground(Color.yellow);
            }
            this.waiting = true;
        }
        return true;
    }

    public void closePBBPort() {
        if (this.open) {
            System.out.println("Closing " + this.port.getName());
            this.portName.setForeground(Color.red);
            this.open = false;
            this.transmitter.stopTransmit();
            if (this.rcvThread != null) {
                this.rcvThread.interrupt();
                this.rcvThread = null;
            }
            this.port.removeEventListener();
            this.portID.removePortOwnershipListener((CommPortOwnershipListener)this);
            this.port.close();
            this.port = null;
            this.ctlSigs.setPort(this.port);
            this.receiver.setPort(this.port);
            this.transmitter.setPort(this.port);
            this.transmitter.clearValues();
            this.receiver.clearValues();
            this.ctlSigs.clearValues();
            this.ctlSigs.clearErrorValues();
            this.showValues();
        }
    }

    public ParallelPort getPort() {
        return this.open ? this.port : null;
    }

    private OutputStream getOutputStream() {
        return this.out;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outSave = this.getOutputStream();
        this.out = outputStream;
    }

    public void setLineMonitor(ParallelPortDisplay parallelPortDisplay, boolean bl) {
        this.lineMonitor = bl;
        parallelPortDisplay.lineMonitor = bl;
        if (this.lineMonitor) {
            this.setOutputStream(parallelPortDisplay.getOutputStream());
            parallelPortDisplay.setOutputStream(this.outSave);
        } else {
            parallelPortDisplay.setOutputStream(this.getOutputStream());
            this.setOutputStream(this.outSave);
        }
    }

    private void createPanel() {
        if (this.portName != null) {
            this.ctlSigs.setPort(this.port);
            this.receiver.setPort(this.port);
            this.transmitter.setPort(this.port);
        } else {
            this.display = new Panel();
            this.display.setLayout(new FlowLayout());
            this.portName = new Label(this.portID.getName());
            if (this.open) {
                this.portName.setForeground(Color.green);
            } else if (this.waiting) {
                this.portName.setForeground(Color.yellow);
            } else {
                this.portName.setForeground(Color.red);
            }
            this.portName.addMouseListener((MouseListener)this);
            this.display.add(this.portName);
            this.mode = new LPTMode(this);
            this.display.add((Component)this.mode);
            this.add("North", (Component)this.display);
            this.ctlSigs = new CtlSigDisplay(this.port);
            this.add("South", (Component)this.ctlSigs);
            this.textPanel = new Panel();
            this.textPanel.setLayout(new BorderLayout());
            this.receiver = new Receiver(this, 6, 40, this.rcvDelay);
            this.textPanel.add("East", (Component)this.receiver);
            this.transmitter = new Transmitter(this, 6, 40);
            this.textPanel.add("West", (Component)this.transmitter);
            this.add("Center", (Component)this.textPanel);
            this.owner.addPanel(this);
        }
    }

    protected void showValues() {
        this.mode.showValue();
        this.transmitter.showValues();
        this.receiver.showValues();
        this.ctlSigs.showValues();
        this.ctlSigs.showErrorValues();
    }

    public void parallelEvent(ParallelPortEvent parallelPortEvent) {
        if (this.port == null) {
            System.out.println(this.port.getName() + "got parallel event on a closed port");
            return;
        }
        switch (parallelPortEvent.getEventType()) {
            case 1: {
                this.ctlSigs.showErrorValues();
                break;
            }
            case 2: {
                this.ctlSigs.BE = true;
                this.ctlSigs.showErrorValues();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.open) {
            this.closePBBPort();
        } else {
            try {
                this.openPBBPort();
            }
            catch (PortInUseException portInUseException) {
                System.out.println(this.portID.getName() + " is in use by " + portInUseException.currentOwner);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void ownershipChange(int n) {
        switch (n) {
            case 2: {
                System.out.println(this.portID.getName() + ": PORT_UNOWNED");
                if (!this.waiting) break;
                try {
                    this.openPBBPort();
                }
                catch (PortInUseException portInUseException) {
                    System.out.println(this.portID.getName() + " s/b free but is in use by " + portInUseException.currentOwner);
                }
                break;
            }
            case 1: {
                System.out.println(this.portID.getName() + ": PORT_OWNED [by this application]");
                break;
            }
            case 3: {
                System.out.println(this.portID.getName() + ": PORT_OWNERSHIP_REQUESTED [by this application]");
                if (!this.friendly || !this.open) break;
                this.closePBBPort();
            }
        }
    }
}

