/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Panel;
import javax.comm.ParallelPort;

public class ByteStatistics
extends Panel {
    private BufferSize buffer;
    private ByteCounter counter;
    private ByteCounter rate;
    private long lastTime;
    private long lastBaudRate;
    private long lastCount;
    private int bitsPerCharacter;
    private boolean avgRate;
    private boolean inputBuffer;
    private ParallelPort port;

    public ByteStatistics(String string, int n, ParallelPort parallelPort, boolean bl, boolean bl2) {
        this.inputBuffer = bl;
        this.setLayout((LayoutManager)new BorderLayout());
        this.counter = new ByteCounter(string, n);
        this.add("West", (Component)this.counter);
        this.rate = new ByteCounter("Baud Rate", 6);
        this.add("East", (Component)this.rate);
        this.buffer = new BufferSize(6, parallelPort, bl);
        this.add("Center", (Component)this.buffer);
        this.setBitsPerCharacter(10);
        this.setPort(parallelPort);
        this.lastTime = 0L;
        this.lastCount = 0L;
        this.lastBaudRate = 0L;
        this.avgRate = bl2;
    }

    public ByteStatistics(String string, int n, ParallelPort parallelPort, boolean bl) {
        this(string, n, parallelPort, bl, true);
    }

    public void setPort(ParallelPort parallelPort) {
        this.port = parallelPort;
        this.buffer.setPort(parallelPort);
    }

    public void setBitsPerCharacter(int n) {
        this.bitsPerCharacter = n;
    }

    public void showValues() {
        this.buffer.showValue();
    }

    public void clearValues() {
        this.buffer.setValue(0);
        this.counter.setValue(0L);
        this.rate.setValue(0L);
    }

    public long getValue() {
        return this.counter.getValue();
    }

    public void setValue(long l) {
        if (l == 0L) {
            this.resetRate();
        }
        this.counter.setValue(l);
        this.setRate();
    }

    public void incrementValue(long l) {
        this.counter.incrementValue(l);
        this.setRate();
    }

    public void resetRate() {
        this.lastTime = 0L;
        this.lastBaudRate = 0L;
    }

    private void setRate() {
        long l = System.currentTimeMillis();
        long l2 = this.counter.getValue();
        if (this.rate.getValue() == 0L && this.lastBaudRate != 0L) {
            this.resetRate();
        }
        if (this.lastTime == 0L || l2 == 0L || l2 < this.lastCount) {
            this.lastTime = l;
            this.lastCount = l2;
        } else if (l > this.lastTime) {
            long l3 = (l2 - this.lastCount) * (long)this.bitsPerCharacter * 1000L / (l - this.lastTime);
            if (this.avgRate) {
                if (this.inputBuffer && l3 < 10L) {
                    this.resetRate();
                }
            } else {
                this.lastCount = l2;
                this.lastTime = l;
            }
            this.rate.setValue((long)((int)l3));
            this.lastBaudRate = l3;
        }
    }
}

