/*
 * Decompiled with CFR 0.152.
 */
package com.radicales.cal.serial;

import com.radicales.cal.CalDriverEvent;
import com.radicales.cal.CalDriverException;
import com.radicales.cal.serial.SerialJSSC;
import com.radicales.cal.serial.SerialParameters;

public class SerialJSSCReader
extends SerialJSSC {
    private final byte[] gBuffer = new byte[1000];
    private int gPos = 0;
    private byte gDelimeter = (byte)13;

    public SerialJSSCReader(String Name) {
        super(Name);
    }

    public SerialJSSCReader(String Name, String PortName) {
        super(Name, PortName);
    }

    public SerialJSSCReader(SerialParameters Parameters) {
        super(Parameters);
    }

    public SerialJSSCReader(int Id, boolean Start, SerialParameters Parameters) {
        super(Id, Start, Parameters);
    }

    public void setDelimeter(byte Character) {
        this.gDelimeter = Character;
    }

    private void Process(byte[] Buffer, int Length, int to) {
        for (int i = 0; i < Length; ++i) {
            this.gBuffer[this.gPos] = Buffer[i];
            if (Buffer[i] == this.gDelimeter) {
                this.PushData();
                continue;
            }
            if (this.gPos > 500) {
                this.PushData();
                continue;
            }
            ++this.gPos;
        }
    }

    private void PushData() {
        byte[] b = new byte[this.gPos];
        System.arraycopy(this.gBuffer, 0, b, 0, this.gPos);
        for (CalDriverEvent ev : this.drvEventListeners) {
            ev.DriverEventWrite(b, b.length);
        }
        this.gPos = 0;
    }

    @Override
    public void run() {
        byte[] buf = new byte[100];
        int to = 0;
        while (this.drvRunning) {
            try {
                int ret = this.Read(buf);
                if (ret > 0) {
                    this.Process(buf, ret, to);
                    to = 0;
                    continue;
                }
                if (this.gPos > 0 && to > 5) {
                    this.PushData();
                    continue;
                }
                if (this.getParameters().getReceiveTimeout() == 0) {
                    Thread.sleep(50L);
                }
                ++to;
            }
            catch (CalDriverException | InterruptedException ex) {
                this.drvRunning = false;
            }
        }
    }
}

