/*
 * Decompiled with CFR 0.152.
 */
package com.radicales.cal.serial;

import com.radicales.cal.CalDriver;
import com.radicales.cal.CalDriverEvent;
import com.radicales.cal.CalDriverException;
import com.radicales.cal.serial.SerialParameters;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import jssc.SerialPortTimeoutException;

public class SerialJSSC
extends CalDriver
implements SerialPortEventListener {
    private SerialParameters gParameters;
    private SerialPort gSerialPort;
    private static final boolean debug = true;

    public SerialJSSC(String Name) {
        super(2, true);
        this.gParameters = new SerialParameters(Name);
    }

    public SerialJSSC(String Name, String PortName) {
        super(2, true);
        this.gParameters = new SerialParameters(Name);
        this.gParameters.setPortName(PortName);
    }

    public SerialJSSC(SerialParameters Parameters) {
        super(2, true);
        this.gParameters = Parameters;
    }

    public SerialJSSC(int Id, boolean Start, SerialParameters Parameters) {
        super(2, Id, Start, true);
        this.gParameters = Parameters;
    }

    public String getPortName() {
        return this.gParameters.getPortName();
    }

    public SerialParameters getParameters() {
        return this.gParameters;
    }

    @Override
    public void Open() throws CalDriverException {
        String[] portNames;
        boolean match = false;
        super.Open();
        for (String s : portNames = SerialPortList.getPortNames()) {
            if (!s.matches(this.gParameters.getPortName())) continue;
            match = true;
            break;
        }
        if (!(match = true)) {
            System.out.println("Serial: No such port: " + this.gParameters.getPortName());
            throw new CalDriverException("No such serial port " + this.gParameters.getPortName());
        }
        this.gSerialPort = new SerialPort(this.gParameters.getPortName());
        try {
            this.gSerialPort.openPort();
        }
        catch (SerialPortException e) {
            System.out.println("Serial port open error: " + this.gParameters.getPortName() + "(" + e.getMessage() + ")");
            throw new CalDriverException(e.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (Exception e) {
            try {
                this.gSerialPort.closePort();
                System.out.println("Serial: Failed to set port parameters");
                System.out.println(e.getMessage());
                throw new CalDriverException(e.getMessage());
            }
            catch (SerialPortException ex) {
                throw new CalDriverException(e.getMessage());
            }
        }
        try {
            this.gSerialPort.addEventListener(this);
        }
        catch (SerialPortException e) {
            try {
                this.gSerialPort.closePort();
                System.out.println("Serial: Too many event listeners");
                System.out.println(e.getMessage());
                throw new CalDriverException(e.getMessage());
            }
            catch (SerialPortException ex) {
                throw new CalDriverException(e.getMessage());
            }
        }
        try {
            int mask = 8;
            this.gSerialPort.setEventsMask(mask);
        }
        catch (SerialPortException e) {
            throw new CalDriverException(e.getMessage());
        }
    }

    @Override
    public void Flush() throws CalDriverException {
        try {
            this.gSerialPort.purgePort(12);
        }
        catch (SerialPortException e) {
            throw new CalDriverException(e.getMessage());
        }
    }

    @Override
    public void Close() {
        super.Close();
        try {
            this.gSerialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public void setConnectionParameters() throws Exception {
        try {
            this.gSerialPort.setParams(this.gParameters.getBaudRate(), this.gParameters.getDatabits(), this.gParameters.getStopbits(), this.gParameters.getParity());
        }
        catch (SerialPortException e) {
            System.out.println("Serial: Unsupported parameter");
            System.out.println(e.getMessage());
            throw new Exception("Unsupported parameter");
        }
        try {
            this.gSerialPort.setFlowControlMode(this.gParameters.getFlowControlIn() | this.gParameters.getFlowControlOut());
        }
        catch (SerialPortException e) {
            System.out.println("Serial: Failed to set flow control");
            System.out.println(e.getMessage());
            throw new Exception("Unsupported flow control");
        }
    }

    @Override
    public int Write(byte[] Buffer, int Length) throws CalDriverException {
        byte[] b = new byte[Length];
        System.arraycopy(Buffer, 0, b, 0, Length);
        try {
            this.gSerialPort.writeBytes(b);
        }
        catch (SerialPortException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return Length;
    }

    @Override
    public int Write(byte[] Buffer) throws CalDriverException {
        try {
            this.gSerialPort.writeBytes(Buffer);
        }
        catch (SerialPortException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return Buffer.length;
    }

    @Override
    public int Read(byte[] Buffer, int Length) throws CalDriverException {
        int ret = 0;
        try {
            int ab;
            byte[] b = this.gParameters.getReceiveTimeout() > 0 ? this.gSerialPort.readBytes(Length, this.gParameters.getReceiveTimeout()) : ((ab = this.gSerialPort.getInputBufferBytesCount()) > Length ? this.gSerialPort.readBytes(Length) : this.gSerialPort.readBytes());
            if (b != null) {
                try {
                    System.arraycopy(b, 0, Buffer, 0, b.length);
                    ret = b.length;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ret = 0;
                }
            }
        }
        catch (SerialPortException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        catch (SerialPortTimeoutException ext) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public int Read(byte[] Buffer) throws CalDriverException {
        int ret = 0;
        try {
            int ab;
            byte[] b = this.gParameters.getReceiveTimeout() > 0 ? this.gSerialPort.readBytes(Buffer.length, this.gParameters.getReceiveTimeout()) : ((ab = this.gSerialPort.getInputBufferBytesCount()) > Buffer.length ? this.gSerialPort.readBytes(Buffer.length) : this.gSerialPort.readBytes());
            if (b != null) {
                try {
                    System.arraycopy(b, 0, Buffer, 0, b.length);
                    ret = b.length;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ret = 0;
                }
            }
        }
        catch (SerialPortException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        catch (SerialPortTimeoutException ext) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public int Read() throws CalDriverException {
        int ret = 0;
        try {
            byte[] b = this.gParameters.getReceiveTimeout() > 0 ? this.gSerialPort.readBytes(1, this.gParameters.getReceiveTimeout()) : this.gSerialPort.readBytes(1);
            if (b.length > 0) {
                ret = b[0];
            }
        }
        catch (SerialPortException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        catch (SerialPortTimeoutException ext) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public void serialEvent(SerialPortEvent spe) {
        block2: {
            block3: {
                if (spe.isRXCHAR()) break block2;
                if (!spe.isCTS()) break block3;
                for (CalDriverEvent ev : this.drvEventListeners) {
                    ev.DriverEventNotify(31, spe.getEventValue());
                }
                break block2;
            }
            if (!spe.isDSR()) break block2;
            for (CalDriverEvent ev : this.drvEventListeners) {
                ev.DriverEventNotify(32, spe.getEventValue());
            }
        }
    }

    @Override
    public int IoControl(int Code, int Arg) throws CalDriverException {
        int ret = -1;
        try {
            switch (Code) {
                case 20: {
                    if (Arg > 0) {
                        this.gSerialPort.setRTS(true);
                    } else {
                        this.gSerialPort.setRTS(false);
                    }
                    ret = 0;
                    break;
                }
                case 23: {
                    if (Arg > 0) {
                        this.gSerialPort.setDTR(true);
                    } else {
                        this.gSerialPort.setDTR(false);
                    }
                    ret = 0;
                    break;
                }
                case 22: {
                    ret = this.gSerialPort.isCTS() ? 1 : 0;
                }
            }
        }
        catch (SerialPortException ex) {
            throw new CalDriverException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public void run() {
        byte[] buf = new byte[100];
        while (this.drvRunning) {
            try {
                int ret = this.Read(buf);
                if (ret <= 0) continue;
                byte[] b = new byte[ret];
                System.arraycopy(buf, 0, b, 0, ret);
                for (CalDriverEvent ev : this.drvEventListeners) {
                    ev.DriverEventWrite(b, b.length);
                }
            }
            catch (CalDriverException ex) {
                this.drvRunning = false;
            }
        }
    }
}

