@echo off

REM set variables
set _CURR_DIR=%cd%
REM set _ISP="d:\Manufacturing\apps\atbackend\atprogram"
set _ISP="c:\Atmel\atbackend\atprogram"
set _DEVICE=atxmega32a4u
set _TYPE=avrispmk2
set _INTERFACE=pdi
set _ISPCMD=%_ISP% -t %_TYPE% -i %_INTERFACE% -d %_DEVICE%
set _HEX_FILE=ITPC100_HID_KEYBOARD.hex

echo ITPC100 Controller Firmware Programming Script

if ""%1""==""HID"" goto doHID
if ""%1""==""HIDCDC"" goto doCDC
if ""%1""==""HIDCDCIO"" goto doCDCIO
if ""%1""==""HIDCDCIO2"" goto doCDCIO2
echo Firmware not specified, using default HID
goto doCheck

:doHID
echo Using stardard HID firmware
shift
goto doCheck

:doCDC
echo Using firmware for normal CDC
set _HEX_FILE=ITPC100_HID_CDC.hex
shift
goto doCheck

:doCDCIO
echo Using firmware for CDC and IO
set _HEX_FILE=ITPC100_HID_CDC_IO.hex
shift
goto doCheck

:doCDCIO2
echo Using firmware for CDC and IO, Keyboard MAP 2
set _HEX_FILE=ITPC100_HID_CDC_IO_2.hex              
shift 
goto doCheck

:doCheck
REM figure out what we need to do
if ""%1""=="""" goto doCustom
if ""%1"" == ""reset"" goto doReset
if ""%1"" == ""program"" goto doProgram
if ""%1"" == ""all"" goto doProgram

:doCustom
@echo on
echo No command specified. Executing custom command.
%_ISPCMD% %1
@echo off
goto end

:doProgram
echo Erasing, Programming and Verifying
%_ISPCMD% program -e -fl --verify -f %_HEX_FILE%
if ""%1""=="""" goto doBoot
if not ""%1"" == ""all"" goto end

:doReset
echo Booting device...
%_ISPCMD% reset

:end
echo Programming completed!



